/*
 * Decompiled with CFR 0.152.
 */
package shape_msgs.msg.dds;

import geometry_msgs.msg.dds.PointPubSubType;
import java.util.function.Supplier;
import shape_msgs.msg.dds.MeshPubSubType;
import shape_msgs.msg.dds.MeshTriangle;
import shape_msgs.msg.dds.MeshTrianglePubSubType;
import us.ihmc.communication.packets.Packet;
import us.ihmc.euclid.interfaces.EpsilonComparable;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.interfaces.Settable;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.idl.IDLSequence;
import us.ihmc.pubsub.TopicDataType;

public class Mesh
extends Packet<Mesh>
implements Settable<Mesh>,
EpsilonComparable<Mesh> {
    public IDLSequence.Object<MeshTriangle> triangles_ = new IDLSequence.Object(100, (TopicDataType)new MeshTrianglePubSubType());
    public IDLSequence.Object<Point3D> vertices_ = new IDLSequence.Object(100, (TopicDataType)new PointPubSubType());

    public Mesh() {
    }

    public Mesh(Mesh other) {
        this();
        this.set(other);
    }

    public void set(Mesh other) {
        this.triangles_.set(other.triangles_);
        this.vertices_.set(other.vertices_);
    }

    public IDLSequence.Object<MeshTriangle> getTriangles() {
        return this.triangles_;
    }

    public IDLSequence.Object<Point3D> getVertices() {
        return this.vertices_;
    }

    public static Supplier<MeshPubSubType> getPubSubType() {
        return MeshPubSubType::new;
    }

    public Supplier<TopicDataType> getPubSubTypePacket() {
        return MeshPubSubType::new;
    }

    public boolean epsilonEquals(Mesh other, double epsilon) {
        int i;
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (this.triangles_.size() != other.triangles_.size()) {
            return false;
        }
        for (i = 0; i < this.triangles_.size(); ++i) {
            if (((MeshTriangle)((Object)this.triangles_.get(i))).epsilonEquals((MeshTriangle)((Object)other.triangles_.get(i)), epsilon)) continue;
            return false;
        }
        if (this.vertices_.size() != other.vertices_.size()) {
            return false;
        }
        for (i = 0; i < this.vertices_.size(); ++i) {
            if (((Point3D)this.vertices_.get(i)).epsilonEquals((EuclidGeometry)other.vertices_.get(i), epsilon)) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (!(other instanceof Mesh)) {
            return false;
        }
        Mesh otherMyClass = (Mesh)((Object)other);
        if (!this.triangles_.equals(otherMyClass.triangles_)) {
            return false;
        }
        return this.vertices_.equals(otherMyClass.vertices_);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Mesh {");
        builder.append("triangles=");
        builder.append(this.triangles_);
        builder.append(", ");
        builder.append("vertices=");
        builder.append(this.vertices_);
        builder.append("}");
        return builder.toString();
    }
}

