/*
 * Decompiled with CFR 0.152.
 */
package statistics_msgs.msg.dds;

import builtin_interfaces.msg.dds.Time;
import builtin_interfaces.msg.dds.TimePubSubType;
import java.util.function.Supplier;
import statistics_msgs.msg.dds.MetricsMessagePubSubType;
import statistics_msgs.msg.dds.StatisticDataPoint;
import statistics_msgs.msg.dds.StatisticDataPointPubSubType;
import us.ihmc.communication.packets.Packet;
import us.ihmc.euclid.interfaces.EpsilonComparable;
import us.ihmc.euclid.interfaces.Settable;
import us.ihmc.idl.IDLSequence;
import us.ihmc.idl.IDLTools;
import us.ihmc.pubsub.TopicDataType;

public class MetricsMessage
extends Packet<MetricsMessage>
implements Settable<MetricsMessage>,
EpsilonComparable<MetricsMessage> {
    public StringBuilder measurement_source_name_ = new StringBuilder(255);
    public StringBuilder metrics_source_ = new StringBuilder(255);
    public StringBuilder unit_ = new StringBuilder(255);
    public Time window_start_ = new Time();
    public Time window_stop_ = new Time();
    public IDLSequence.Object<StatisticDataPoint> statistics_ = new IDLSequence.Object(100, (TopicDataType)new StatisticDataPointPubSubType());

    public MetricsMessage() {
    }

    public MetricsMessage(MetricsMessage other) {
        this();
        this.set(other);
    }

    public void set(MetricsMessage other) {
        this.measurement_source_name_.setLength(0);
        this.measurement_source_name_.append((CharSequence)other.measurement_source_name_);
        this.metrics_source_.setLength(0);
        this.metrics_source_.append((CharSequence)other.metrics_source_);
        this.unit_.setLength(0);
        this.unit_.append((CharSequence)other.unit_);
        TimePubSubType.staticCopy(other.window_start_, this.window_start_);
        TimePubSubType.staticCopy(other.window_stop_, this.window_stop_);
        this.statistics_.set(other.statistics_);
    }

    public void setMeasurementSourceName(String measurement_source_name) {
        this.measurement_source_name_.setLength(0);
        this.measurement_source_name_.append(measurement_source_name);
    }

    public String getMeasurementSourceNameAsString() {
        return this.getMeasurementSourceName().toString();
    }

    public StringBuilder getMeasurementSourceName() {
        return this.measurement_source_name_;
    }

    public void setMetricsSource(String metrics_source) {
        this.metrics_source_.setLength(0);
        this.metrics_source_.append(metrics_source);
    }

    public String getMetricsSourceAsString() {
        return this.getMetricsSource().toString();
    }

    public StringBuilder getMetricsSource() {
        return this.metrics_source_;
    }

    public void setUnit(String unit) {
        this.unit_.setLength(0);
        this.unit_.append(unit);
    }

    public String getUnitAsString() {
        return this.getUnit().toString();
    }

    public StringBuilder getUnit() {
        return this.unit_;
    }

    public Time getWindowStart() {
        return this.window_start_;
    }

    public Time getWindowStop() {
        return this.window_stop_;
    }

    public IDLSequence.Object<StatisticDataPoint> getStatistics() {
        return this.statistics_;
    }

    public static Supplier<MetricsMessagePubSubType> getPubSubType() {
        return MetricsMessagePubSubType::new;
    }

    public Supplier<TopicDataType> getPubSubTypePacket() {
        return MetricsMessagePubSubType::new;
    }

    public boolean epsilonEquals(MetricsMessage other, double epsilon) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (!IDLTools.epsilonEqualsStringBuilder((StringBuilder)this.measurement_source_name_, (StringBuilder)other.measurement_source_name_, (double)epsilon)) {
            return false;
        }
        if (!IDLTools.epsilonEqualsStringBuilder((StringBuilder)this.metrics_source_, (StringBuilder)other.metrics_source_, (double)epsilon)) {
            return false;
        }
        if (!IDLTools.epsilonEqualsStringBuilder((StringBuilder)this.unit_, (StringBuilder)other.unit_, (double)epsilon)) {
            return false;
        }
        if (!this.window_start_.epsilonEquals(other.window_start_, epsilon)) {
            return false;
        }
        if (!this.window_stop_.epsilonEquals(other.window_stop_, epsilon)) {
            return false;
        }
        if (this.statistics_.size() != other.statistics_.size()) {
            return false;
        }
        for (int i = 0; i < this.statistics_.size(); ++i) {
            if (((StatisticDataPoint)((Object)this.statistics_.get(i))).epsilonEquals((StatisticDataPoint)((Object)other.statistics_.get(i)), epsilon)) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (!(other instanceof MetricsMessage)) {
            return false;
        }
        MetricsMessage otherMyClass = (MetricsMessage)((Object)other);
        if (!IDLTools.equals((StringBuilder)this.measurement_source_name_, (StringBuilder)otherMyClass.measurement_source_name_)) {
            return false;
        }
        if (!IDLTools.equals((StringBuilder)this.metrics_source_, (StringBuilder)otherMyClass.metrics_source_)) {
            return false;
        }
        if (!IDLTools.equals((StringBuilder)this.unit_, (StringBuilder)otherMyClass.unit_)) {
            return false;
        }
        if (!this.window_start_.equals((Object)otherMyClass.window_start_)) {
            return false;
        }
        if (!this.window_stop_.equals((Object)otherMyClass.window_stop_)) {
            return false;
        }
        return this.statistics_.equals(otherMyClass.statistics_);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("MetricsMessage {");
        builder.append("measurement_source_name=");
        builder.append((CharSequence)this.measurement_source_name_);
        builder.append(", ");
        builder.append("metrics_source=");
        builder.append((CharSequence)this.metrics_source_);
        builder.append(", ");
        builder.append("unit=");
        builder.append((CharSequence)this.unit_);
        builder.append(", ");
        builder.append("window_start=");
        builder.append((Object)this.window_start_);
        builder.append(", ");
        builder.append("window_stop=");
        builder.append((Object)this.window_stop_);
        builder.append(", ");
        builder.append("statistics=");
        builder.append(this.statistics_);
        builder.append("}");
        return builder.toString();
    }
}

