/*
 * Decompiled with CFR 0.152.
 */
package geometry_msgs.msg.dds;

import geometry_msgs.msg.dds.AccelPubSubType;
import geometry_msgs.msg.dds.Vector3PubSubType;
import java.util.function.Supplier;
import us.ihmc.communication.packets.Packet;
import us.ihmc.euclid.interfaces.EpsilonComparable;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.interfaces.Settable;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.pubsub.TopicDataType;

public class Accel
extends Packet<Accel>
implements Settable<Accel>,
EpsilonComparable<Accel> {
    public Vector3D linear_ = new Vector3D();
    public Vector3D angular_ = new Vector3D();

    public Accel() {
    }

    public Accel(Accel other) {
        this();
        this.set(other);
    }

    public void set(Accel other) {
        Vector3PubSubType.staticCopy(other.linear_, this.linear_);
        Vector3PubSubType.staticCopy(other.angular_, this.angular_);
    }

    public Vector3D getLinear() {
        return this.linear_;
    }

    public Vector3D getAngular() {
        return this.angular_;
    }

    public static Supplier<AccelPubSubType> getPubSubType() {
        return AccelPubSubType::new;
    }

    public Supplier<TopicDataType> getPubSubTypePacket() {
        return AccelPubSubType::new;
    }

    public boolean epsilonEquals(Accel other, double epsilon) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (!this.linear_.epsilonEquals((EuclidGeometry)other.linear_, epsilon)) {
            return false;
        }
        return this.angular_.epsilonEquals((EuclidGeometry)other.angular_, epsilon);
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (!(other instanceof Accel)) {
            return false;
        }
        Accel otherMyClass = (Accel)((Object)other);
        if (!this.linear_.equals((EuclidGeometry)otherMyClass.linear_)) {
            return false;
        }
        return this.angular_.equals((EuclidGeometry)otherMyClass.angular_);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Accel {");
        builder.append("linear=");
        builder.append(this.linear_);
        builder.append(", ");
        builder.append("angular=");
        builder.append(this.angular_);
        builder.append("}");
        return builder.toString();
    }
}

