/*
 * Decompiled with CFR 0.152.
 */
package visualization_msgs.msg.dds;

import builtin_interfaces.msg.dds.Duration;
import builtin_interfaces.msg.dds.DurationPubSubType;
import geometry_msgs.msg.dds.PointPubSubType;
import geometry_msgs.msg.dds.PosePubSubType;
import geometry_msgs.msg.dds.Vector3PubSubType;
import java.util.function.Supplier;
import std_msgs.msg.dds.ColorRGBA;
import std_msgs.msg.dds.ColorRGBAPubSubType;
import std_msgs.msg.dds.Header;
import std_msgs.msg.dds.HeaderPubSubType;
import us.ihmc.communication.packets.Packet;
import us.ihmc.euclid.geometry.Pose3D;
import us.ihmc.euclid.interfaces.EpsilonComparable;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.interfaces.Settable;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.idl.IDLSequence;
import us.ihmc.idl.IDLTools;
import us.ihmc.pubsub.TopicDataType;
import visualization_msgs.msg.dds.MarkerPubSubType;

public class Marker
extends Packet<Marker>
implements Settable<Marker>,
EpsilonComparable<Marker> {
    public static final byte ARROW = 0;
    public static final byte CUBE = 1;
    public static final byte SPHERE = 2;
    public static final byte CYLINDER = 3;
    public static final byte LINE_STRIP = 4;
    public static final byte LINE_LIST = 5;
    public static final byte CUBE_LIST = 6;
    public static final byte SPHERE_LIST = 7;
    public static final byte POINTS = 8;
    public static final byte TEXT_VIEW_FACING = 9;
    public static final byte MESH_RESOURCE = 10;
    public static final byte TRIANGLE_LIST = 11;
    public static final byte ADD = 0;
    public static final byte MODIFY = 0;
    public static final byte DELETE = 2;
    public static final byte DELETEALL = 3;
    public Header header_ = new Header();
    public StringBuilder ns_ = new StringBuilder(255);
    public int id_;
    public int type_;
    public int action_;
    public Pose3D pose_ = new Pose3D();
    public Vector3D scale_ = new Vector3D();
    public ColorRGBA color_ = new ColorRGBA();
    public Duration lifetime_ = new Duration();
    public boolean frame_locked_;
    public IDLSequence.Object<Point3D> points_ = new IDLSequence.Object(100, (TopicDataType)new PointPubSubType());
    public IDLSequence.Object<ColorRGBA> colors_ = new IDLSequence.Object(100, (TopicDataType)new ColorRGBAPubSubType());
    public StringBuilder text_ = new StringBuilder(255);
    public StringBuilder mesh_resource_ = new StringBuilder(255);
    public boolean mesh_use_embedded_materials_;

    public Marker() {
    }

    public Marker(Marker other) {
        this();
        this.set(other);
    }

    public void set(Marker other) {
        HeaderPubSubType.staticCopy(other.header_, this.header_);
        this.ns_.setLength(0);
        this.ns_.append((CharSequence)other.ns_);
        this.id_ = other.id_;
        this.type_ = other.type_;
        this.action_ = other.action_;
        PosePubSubType.staticCopy(other.pose_, this.pose_);
        Vector3PubSubType.staticCopy(other.scale_, this.scale_);
        ColorRGBAPubSubType.staticCopy(other.color_, this.color_);
        DurationPubSubType.staticCopy(other.lifetime_, this.lifetime_);
        this.frame_locked_ = other.frame_locked_;
        this.points_.set(other.points_);
        this.colors_.set(other.colors_);
        this.text_.setLength(0);
        this.text_.append((CharSequence)other.text_);
        this.mesh_resource_.setLength(0);
        this.mesh_resource_.append((CharSequence)other.mesh_resource_);
        this.mesh_use_embedded_materials_ = other.mesh_use_embedded_materials_;
    }

    public Header getHeader() {
        return this.header_;
    }

    public void setNs(String ns) {
        this.ns_.setLength(0);
        this.ns_.append(ns);
    }

    public String getNsAsString() {
        return this.getNs().toString();
    }

    public StringBuilder getNs() {
        return this.ns_;
    }

    public void setId(int id) {
        this.id_ = id;
    }

    public int getId() {
        return this.id_;
    }

    public void setType(int type) {
        this.type_ = type;
    }

    public int getType() {
        return this.type_;
    }

    public void setAction(int action) {
        this.action_ = action;
    }

    public int getAction() {
        return this.action_;
    }

    public Pose3D getPose() {
        return this.pose_;
    }

    public Vector3D getScale() {
        return this.scale_;
    }

    public ColorRGBA getColor() {
        return this.color_;
    }

    public Duration getLifetime() {
        return this.lifetime_;
    }

    public void setFrameLocked(boolean frame_locked) {
        this.frame_locked_ = frame_locked;
    }

    public boolean getFrameLocked() {
        return this.frame_locked_;
    }

    public IDLSequence.Object<Point3D> getPoints() {
        return this.points_;
    }

    public IDLSequence.Object<ColorRGBA> getColors() {
        return this.colors_;
    }

    public void setText(String text) {
        this.text_.setLength(0);
        this.text_.append(text);
    }

    public String getTextAsString() {
        return this.getText().toString();
    }

    public StringBuilder getText() {
        return this.text_;
    }

    public void setMeshResource(String mesh_resource) {
        this.mesh_resource_.setLength(0);
        this.mesh_resource_.append(mesh_resource);
    }

    public String getMeshResourceAsString() {
        return this.getMeshResource().toString();
    }

    public StringBuilder getMeshResource() {
        return this.mesh_resource_;
    }

    public void setMeshUseEmbeddedMaterials(boolean mesh_use_embedded_materials) {
        this.mesh_use_embedded_materials_ = mesh_use_embedded_materials;
    }

    public boolean getMeshUseEmbeddedMaterials() {
        return this.mesh_use_embedded_materials_;
    }

    public static Supplier<MarkerPubSubType> getPubSubType() {
        return MarkerPubSubType::new;
    }

    public Supplier<TopicDataType> getPubSubTypePacket() {
        return MarkerPubSubType::new;
    }

    public boolean epsilonEquals(Marker other, double epsilon) {
        int i;
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (!this.header_.epsilonEquals(other.header_, epsilon)) {
            return false;
        }
        if (!IDLTools.epsilonEqualsStringBuilder((StringBuilder)this.ns_, (StringBuilder)other.ns_, (double)epsilon)) {
            return false;
        }
        if (!IDLTools.epsilonEqualsPrimitive((double)this.id_, (double)other.id_, (double)epsilon)) {
            return false;
        }
        if (!IDLTools.epsilonEqualsPrimitive((double)this.type_, (double)other.type_, (double)epsilon)) {
            return false;
        }
        if (!IDLTools.epsilonEqualsPrimitive((double)this.action_, (double)other.action_, (double)epsilon)) {
            return false;
        }
        if (!this.pose_.epsilonEquals((EuclidGeometry)other.pose_, epsilon)) {
            return false;
        }
        if (!this.scale_.epsilonEquals((EuclidGeometry)other.scale_, epsilon)) {
            return false;
        }
        if (!this.color_.epsilonEquals(other.color_, epsilon)) {
            return false;
        }
        if (!this.lifetime_.epsilonEquals(other.lifetime_, epsilon)) {
            return false;
        }
        if (!IDLTools.epsilonEqualsBoolean((boolean)this.frame_locked_, (boolean)other.frame_locked_, (double)epsilon)) {
            return false;
        }
        if (this.points_.size() != other.points_.size()) {
            return false;
        }
        for (i = 0; i < this.points_.size(); ++i) {
            if (((Point3D)this.points_.get(i)).epsilonEquals((EuclidGeometry)other.points_.get(i), epsilon)) continue;
            return false;
        }
        if (this.colors_.size() != other.colors_.size()) {
            return false;
        }
        for (i = 0; i < this.colors_.size(); ++i) {
            if (((ColorRGBA)((Object)this.colors_.get(i))).epsilonEquals((ColorRGBA)((Object)other.colors_.get(i)), epsilon)) continue;
            return false;
        }
        if (!IDLTools.epsilonEqualsStringBuilder((StringBuilder)this.text_, (StringBuilder)other.text_, (double)epsilon)) {
            return false;
        }
        if (!IDLTools.epsilonEqualsStringBuilder((StringBuilder)this.mesh_resource_, (StringBuilder)other.mesh_resource_, (double)epsilon)) {
            return false;
        }
        return IDLTools.epsilonEqualsBoolean((boolean)this.mesh_use_embedded_materials_, (boolean)other.mesh_use_embedded_materials_, (double)epsilon);
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (!(other instanceof Marker)) {
            return false;
        }
        Marker otherMyClass = (Marker)((Object)other);
        if (!this.header_.equals((Object)otherMyClass.header_)) {
            return false;
        }
        if (!IDLTools.equals((StringBuilder)this.ns_, (StringBuilder)otherMyClass.ns_)) {
            return false;
        }
        if (this.id_ != otherMyClass.id_) {
            return false;
        }
        if (this.type_ != otherMyClass.type_) {
            return false;
        }
        if (this.action_ != otherMyClass.action_) {
            return false;
        }
        if (!this.pose_.equals((EuclidGeometry)otherMyClass.pose_)) {
            return false;
        }
        if (!this.scale_.equals((EuclidGeometry)otherMyClass.scale_)) {
            return false;
        }
        if (!this.color_.equals((Object)otherMyClass.color_)) {
            return false;
        }
        if (!this.lifetime_.equals((Object)otherMyClass.lifetime_)) {
            return false;
        }
        if (this.frame_locked_ != otherMyClass.frame_locked_) {
            return false;
        }
        if (!this.points_.equals(otherMyClass.points_)) {
            return false;
        }
        if (!this.colors_.equals(otherMyClass.colors_)) {
            return false;
        }
        if (!IDLTools.equals((StringBuilder)this.text_, (StringBuilder)otherMyClass.text_)) {
            return false;
        }
        if (!IDLTools.equals((StringBuilder)this.mesh_resource_, (StringBuilder)otherMyClass.mesh_resource_)) {
            return false;
        }
        return this.mesh_use_embedded_materials_ == otherMyClass.mesh_use_embedded_materials_;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Marker {");
        builder.append("header=");
        builder.append((Object)this.header_);
        builder.append(", ");
        builder.append("ns=");
        builder.append((CharSequence)this.ns_);
        builder.append(", ");
        builder.append("id=");
        builder.append(this.id_);
        builder.append(", ");
        builder.append("type=");
        builder.append(this.type_);
        builder.append(", ");
        builder.append("action=");
        builder.append(this.action_);
        builder.append(", ");
        builder.append("pose=");
        builder.append(this.pose_);
        builder.append(", ");
        builder.append("scale=");
        builder.append(this.scale_);
        builder.append(", ");
        builder.append("color=");
        builder.append((Object)this.color_);
        builder.append(", ");
        builder.append("lifetime=");
        builder.append((Object)this.lifetime_);
        builder.append(", ");
        builder.append("frame_locked=");
        builder.append(this.frame_locked_);
        builder.append(", ");
        builder.append("points=");
        builder.append(this.points_);
        builder.append(", ");
        builder.append("colors=");
        builder.append(this.colors_);
        builder.append(", ");
        builder.append("text=");
        builder.append((CharSequence)this.text_);
        builder.append(", ");
        builder.append("mesh_resource=");
        builder.append((CharSequence)this.mesh_resource_);
        builder.append(", ");
        builder.append("mesh_use_embedded_materials=");
        builder.append(this.mesh_use_embedded_materials_);
        builder.append("}");
        return builder.toString();
    }
}

