/*
 * Decompiled with CFR 0.152.
 */
package tf2_msgs.msg.dds;

import java.util.function.Supplier;
import tf2_msgs.msg.dds.TF2ErrorPubSubType;
import us.ihmc.communication.packets.Packet;
import us.ihmc.euclid.interfaces.EpsilonComparable;
import us.ihmc.euclid.interfaces.Settable;
import us.ihmc.idl.IDLTools;
import us.ihmc.pubsub.TopicDataType;

public class TF2Error
extends Packet<TF2Error>
implements Settable<TF2Error>,
EpsilonComparable<TF2Error> {
    public static final byte NO_ERROR = 0;
    public static final byte LOOKUP_ERROR = 1;
    public static final byte CONNECTIVITY_ERROR = 2;
    public static final byte EXTRAPOLATION_ERROR = 3;
    public static final byte INVALID_ARGUMENT_ERROR = 4;
    public static final byte TIMEOUT_ERROR = 5;
    public static final byte TRANSFORM_ERROR = 6;
    public byte error_;
    public StringBuilder error_string_ = new StringBuilder(255);

    public TF2Error() {
    }

    public TF2Error(TF2Error other) {
        this();
        this.set(other);
    }

    public void set(TF2Error other) {
        this.error_ = other.error_;
        this.error_string_.setLength(0);
        this.error_string_.append((CharSequence)other.error_string_);
    }

    public void setError(byte error) {
        this.error_ = error;
    }

    public byte getError() {
        return this.error_;
    }

    public void setErrorString(String error_string) {
        this.error_string_.setLength(0);
        this.error_string_.append(error_string);
    }

    public String getErrorStringAsString() {
        return this.getErrorString().toString();
    }

    public StringBuilder getErrorString() {
        return this.error_string_;
    }

    public static Supplier<TF2ErrorPubSubType> getPubSubType() {
        return TF2ErrorPubSubType::new;
    }

    public Supplier<TopicDataType> getPubSubTypePacket() {
        return TF2ErrorPubSubType::new;
    }

    public boolean epsilonEquals(TF2Error other, double epsilon) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (!IDLTools.epsilonEqualsPrimitive((double)this.error_, (double)other.error_, (double)epsilon)) {
            return false;
        }
        return IDLTools.epsilonEqualsStringBuilder((StringBuilder)this.error_string_, (StringBuilder)other.error_string_, (double)epsilon);
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (!(other instanceof TF2Error)) {
            return false;
        }
        TF2Error otherMyClass = (TF2Error)((Object)other);
        if (this.error_ != otherMyClass.error_) {
            return false;
        }
        return IDLTools.equals((StringBuilder)this.error_string_, (StringBuilder)otherMyClass.error_string_);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("TF2Error {");
        builder.append("error=");
        builder.append(this.error_);
        builder.append(", ");
        builder.append("error_string=");
        builder.append((CharSequence)this.error_string_);
        builder.append("}");
        return builder.toString();
    }
}

