/*
 * Decompiled with CFR 0.152.
 */
package sensor_msgs.msg.dds;

import builtin_interfaces.msg.dds.TimePubSubType;
import java.io.IOException;
import sensor_msgs.msg.dds.TimeReference;
import std_msgs.msg.dds.HeaderPubSubType;
import us.ihmc.idl.CDR;
import us.ihmc.idl.InterchangeSerializer;
import us.ihmc.pubsub.TopicDataType;
import us.ihmc.pubsub.common.SerializedPayload;

public class TimeReferencePubSubType
implements TopicDataType<TimeReference> {
    public static final String name = "sensor_msgs::msg::dds_::TimeReference_";
    private final CDR serializeCDR = new CDR();
    private final CDR deserializeCDR = new CDR();

    public final String getDefinitionChecksum() {
        return "85fd3a8e2171ad3873e842825bce084599e00198222dfcf78f5987800b8221b2";
    }

    public final String getDefinitionVersion() {
        return "local";
    }

    public void serialize(TimeReference data, SerializedPayload serializedPayload) throws IOException {
        this.serializeCDR.serialize(serializedPayload);
        TimeReferencePubSubType.write(data, this.serializeCDR);
        this.serializeCDR.finishSerialize();
    }

    public void deserialize(SerializedPayload serializedPayload, TimeReference data) throws IOException {
        this.deserializeCDR.deserialize(serializedPayload);
        TimeReferencePubSubType.read(data, this.deserializeCDR);
        this.deserializeCDR.finishDeserialize();
    }

    public static int getMaxCdrSerializedSize() {
        return TimeReferencePubSubType.getMaxCdrSerializedSize(0);
    }

    public static int getMaxCdrSerializedSize(int current_alignment) {
        int initial_alignment = current_alignment;
        current_alignment += HeaderPubSubType.getMaxCdrSerializedSize(current_alignment);
        current_alignment += TimePubSubType.getMaxCdrSerializedSize(current_alignment);
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4) + 255 + 1;
        return current_alignment - initial_alignment;
    }

    public static final int getCdrSerializedSize(TimeReference data) {
        return TimeReferencePubSubType.getCdrSerializedSize(data, 0);
    }

    public static final int getCdrSerializedSize(TimeReference data, int current_alignment) {
        int initial_alignment = current_alignment;
        current_alignment += HeaderPubSubType.getCdrSerializedSize(data.getHeader(), current_alignment);
        current_alignment += TimePubSubType.getCdrSerializedSize(data.getTimeRef(), current_alignment);
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4) + data.getTimeSource().length() + 1;
        return current_alignment - initial_alignment;
    }

    public static void write(TimeReference data, CDR cdr) {
        HeaderPubSubType.write(data.getHeader(), cdr);
        TimePubSubType.write(data.getTimeRef(), cdr);
        if (data.getTimeSource().length() > 255) {
            throw new RuntimeException("timeSource field exceeds the maximum length");
        }
        cdr.write_type_d(data.getTimeSource());
    }

    public static void read(TimeReference data, CDR cdr) {
        HeaderPubSubType.read(data.getHeader(), cdr);
        TimePubSubType.read(data.getTimeRef(), cdr);
        cdr.read_type_d(data.getTimeSource());
    }

    public final void serialize(TimeReference data, InterchangeSerializer ser) {
        ser.write_type_a("header", (TopicDataType)new HeaderPubSubType(), (Object)data.getHeader());
        ser.write_type_a("time_ref", (TopicDataType)new TimePubSubType(), (Object)data.getTimeRef());
        ser.write_type_d("timeSource", data.getTimeSource());
    }

    public final void deserialize(InterchangeSerializer ser, TimeReference data) {
        ser.read_type_a("header", (TopicDataType)new HeaderPubSubType(), (Object)data.getHeader());
        ser.read_type_a("time_ref", (TopicDataType)new TimePubSubType(), (Object)data.getTimeRef());
        ser.read_type_d("timeSource", data.getTimeSource());
    }

    public static void staticCopy(TimeReference src, TimeReference dest) {
        dest.set(src);
    }

    public TimeReference createData() {
        return new TimeReference();
    }

    public int getTypeSize() {
        return CDR.getTypeSize((int)TimeReferencePubSubType.getMaxCdrSerializedSize());
    }

    public String getName() {
        return name;
    }

    public void serialize(TimeReference data, CDR cdr) {
        TimeReferencePubSubType.write(data, cdr);
    }

    public void deserialize(TimeReference data, CDR cdr) {
        TimeReferencePubSubType.read(data, cdr);
    }

    public void copy(TimeReference src, TimeReference dest) {
        TimeReferencePubSubType.staticCopy(src, dest);
    }

    public TimeReferencePubSubType newInstance() {
        return new TimeReferencePubSubType();
    }
}

