/*
 * Decompiled with CFR 0.152.
 */
package sensor_msgs.msg.dds;

import geometry_msgs.msg.dds.Point32PubSubType;
import java.io.IOException;
import sensor_msgs.msg.dds.ChannelFloat32;
import sensor_msgs.msg.dds.ChannelFloat32PubSubType;
import sensor_msgs.msg.dds.PointCloud;
import std_msgs.msg.dds.HeaderPubSubType;
import us.ihmc.euclid.tuple3D.Point3D32;
import us.ihmc.idl.CDR;
import us.ihmc.idl.InterchangeSerializer;
import us.ihmc.pubsub.TopicDataType;
import us.ihmc.pubsub.common.SerializedPayload;

public class PointCloudPubSubType
implements TopicDataType<PointCloud> {
    public static final String name = "sensor_msgs::msg::dds_::PointCloud_";
    private final CDR serializeCDR = new CDR();
    private final CDR deserializeCDR = new CDR();

    public final String getDefinitionChecksum() {
        return "69cdba19a70d87cda842eb0ba2d46d9a8cc0bff9fbcb839c553c25375d5447c6";
    }

    public final String getDefinitionVersion() {
        return "local";
    }

    public void serialize(PointCloud data, SerializedPayload serializedPayload) throws IOException {
        this.serializeCDR.serialize(serializedPayload);
        PointCloudPubSubType.write(data, this.serializeCDR);
        this.serializeCDR.finishSerialize();
    }

    public void deserialize(SerializedPayload serializedPayload, PointCloud data) throws IOException {
        this.deserializeCDR.deserialize(serializedPayload);
        PointCloudPubSubType.read(data, this.deserializeCDR);
        this.deserializeCDR.finishDeserialize();
    }

    public static int getMaxCdrSerializedSize() {
        return PointCloudPubSubType.getMaxCdrSerializedSize(0);
    }

    public static int getMaxCdrSerializedSize(int current_alignment) {
        int i0;
        int initial_alignment = current_alignment;
        current_alignment += HeaderPubSubType.getMaxCdrSerializedSize(current_alignment);
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        for (i0 = 0; i0 < 100; ++i0) {
            current_alignment += Point32PubSubType.getMaxCdrSerializedSize(current_alignment);
        }
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        for (i0 = 0; i0 < 100; ++i0) {
            current_alignment += ChannelFloat32PubSubType.getMaxCdrSerializedSize(current_alignment);
        }
        return current_alignment - initial_alignment;
    }

    public static final int getCdrSerializedSize(PointCloud data) {
        return PointCloudPubSubType.getCdrSerializedSize(data, 0);
    }

    public static final int getCdrSerializedSize(PointCloud data, int current_alignment) {
        int i0;
        int initial_alignment = current_alignment;
        current_alignment += HeaderPubSubType.getCdrSerializedSize(data.getHeader(), current_alignment);
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        for (i0 = 0; i0 < data.getPoints().size(); ++i0) {
            current_alignment += Point32PubSubType.getCdrSerializedSize((Point3D32)data.getPoints().get(i0), current_alignment);
        }
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        for (i0 = 0; i0 < data.getChannels().size(); ++i0) {
            current_alignment += ChannelFloat32PubSubType.getCdrSerializedSize((ChannelFloat32)((Object)data.getChannels().get(i0)), current_alignment);
        }
        return current_alignment - initial_alignment;
    }

    public static void write(PointCloud data, CDR cdr) {
        HeaderPubSubType.write(data.getHeader(), cdr);
        if (data.getPoints().size() > 100) {
            throw new RuntimeException("points field exceeds the maximum length");
        }
        cdr.write_type_e(data.getPoints());
        if (data.getChannels().size() > 100) {
            throw new RuntimeException("channels field exceeds the maximum length");
        }
        cdr.write_type_e(data.getChannels());
    }

    public static void read(PointCloud data, CDR cdr) {
        HeaderPubSubType.read(data.getHeader(), cdr);
        cdr.read_type_e(data.getPoints());
        cdr.read_type_e(data.getChannels());
    }

    public final void serialize(PointCloud data, InterchangeSerializer ser) {
        ser.write_type_a("header", (TopicDataType)new HeaderPubSubType(), (Object)data.getHeader());
        ser.write_type_e("points", data.getPoints());
        ser.write_type_e("channels", data.getChannels());
    }

    public final void deserialize(InterchangeSerializer ser, PointCloud data) {
        ser.read_type_a("header", (TopicDataType)new HeaderPubSubType(), (Object)data.getHeader());
        ser.read_type_e("points", data.getPoints());
        ser.read_type_e("channels", data.getChannels());
    }

    public static void staticCopy(PointCloud src, PointCloud dest) {
        dest.set(src);
    }

    public PointCloud createData() {
        return new PointCloud();
    }

    public int getTypeSize() {
        return CDR.getTypeSize((int)PointCloudPubSubType.getMaxCdrSerializedSize());
    }

    public String getName() {
        return name;
    }

    public void serialize(PointCloud data, CDR cdr) {
        PointCloudPubSubType.write(data, cdr);
    }

    public void deserialize(PointCloud data, CDR cdr) {
        PointCloudPubSubType.read(data, cdr);
    }

    public void copy(PointCloud src, PointCloud dest) {
        PointCloudPubSubType.staticCopy(src, dest);
    }

    public PointCloudPubSubType newInstance() {
        return new PointCloudPubSubType();
    }
}

