/*
 * Decompiled with CFR 0.152.
 */
package sensor_msgs.msg.dds;

import geometry_msgs.msg.dds.Vector3PubSubType;
import java.util.Arrays;
import java.util.function.Supplier;
import sensor_msgs.msg.dds.MagneticFieldPubSubType;
import std_msgs.msg.dds.Header;
import std_msgs.msg.dds.HeaderPubSubType;
import us.ihmc.communication.packets.Packet;
import us.ihmc.euclid.interfaces.EpsilonComparable;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.interfaces.Settable;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.idl.IDLTools;
import us.ihmc.pubsub.TopicDataType;

public class MagneticField
extends Packet<MagneticField>
implements Settable<MagneticField>,
EpsilonComparable<MagneticField> {
    public Header header_ = new Header();
    public Vector3D magnetic_field_ = new Vector3D();
    public double[] magnetic_field_covariance_ = new double[9];

    public MagneticField() {
    }

    public MagneticField(MagneticField other) {
        this();
        this.set(other);
    }

    public void set(MagneticField other) {
        HeaderPubSubType.staticCopy(other.header_, this.header_);
        Vector3PubSubType.staticCopy(other.magnetic_field_, this.magnetic_field_);
        for (int i1 = 0; i1 < this.magnetic_field_covariance_.length; ++i1) {
            this.magnetic_field_covariance_[i1] = other.magnetic_field_covariance_[i1];
        }
    }

    public Header getHeader() {
        return this.header_;
    }

    public Vector3D getMagneticField() {
        return this.magnetic_field_;
    }

    public double[] getMagneticFieldCovariance() {
        return this.magnetic_field_covariance_;
    }

    public static Supplier<MagneticFieldPubSubType> getPubSubType() {
        return MagneticFieldPubSubType::new;
    }

    public Supplier<TopicDataType> getPubSubTypePacket() {
        return MagneticFieldPubSubType::new;
    }

    public boolean epsilonEquals(MagneticField other, double epsilon) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (!this.header_.epsilonEquals(other.header_, epsilon)) {
            return false;
        }
        if (!this.magnetic_field_.epsilonEquals((EuclidGeometry)other.magnetic_field_, epsilon)) {
            return false;
        }
        for (int i3 = 0; i3 < this.magnetic_field_covariance_.length; ++i3) {
            if (IDLTools.epsilonEqualsPrimitive((double)this.magnetic_field_covariance_[i3], (double)other.magnetic_field_covariance_[i3], (double)epsilon)) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (!(other instanceof MagneticField)) {
            return false;
        }
        MagneticField otherMyClass = (MagneticField)((Object)other);
        if (!this.header_.equals((Object)otherMyClass.header_)) {
            return false;
        }
        if (!this.magnetic_field_.equals((EuclidGeometry)otherMyClass.magnetic_field_)) {
            return false;
        }
        for (int i5 = 0; i5 < this.magnetic_field_covariance_.length; ++i5) {
            if (this.magnetic_field_covariance_[i5] == otherMyClass.magnetic_field_covariance_[i5]) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("MagneticField {");
        builder.append("header=");
        builder.append((Object)this.header_);
        builder.append(", ");
        builder.append("magnetic_field=");
        builder.append(this.magnetic_field_);
        builder.append(", ");
        builder.append("magnetic_field_covariance=");
        builder.append(Arrays.toString(this.magnetic_field_covariance_));
        builder.append("}");
        return builder.toString();
    }
}

