/*
 * Decompiled with CFR 0.152.
 */
package nav_msgs.msg.dds;

import geometry_msgs.msg.dds.PoseWithCovariancePubSubType;
import geometry_msgs.msg.dds.TwistWithCovariancePubSubType;
import java.io.IOException;
import nav_msgs.msg.dds.Odometry;
import std_msgs.msg.dds.HeaderPubSubType;
import us.ihmc.idl.CDR;
import us.ihmc.idl.InterchangeSerializer;
import us.ihmc.pubsub.TopicDataType;
import us.ihmc.pubsub.common.SerializedPayload;

public class OdometryPubSubType
implements TopicDataType<Odometry> {
    public static final String name = "nav_msgs::msg::dds_::Odometry_";
    private final CDR serializeCDR = new CDR();
    private final CDR deserializeCDR = new CDR();

    public final String getDefinitionChecksum() {
        return "34831632cf9dda338afec218ff4dc35a46f5934f157d8de6a102c361fdd280f9";
    }

    public final String getDefinitionVersion() {
        return "local";
    }

    public void serialize(Odometry data, SerializedPayload serializedPayload) throws IOException {
        this.serializeCDR.serialize(serializedPayload);
        OdometryPubSubType.write(data, this.serializeCDR);
        this.serializeCDR.finishSerialize();
    }

    public void deserialize(SerializedPayload serializedPayload, Odometry data) throws IOException {
        this.deserializeCDR.deserialize(serializedPayload);
        OdometryPubSubType.read(data, this.deserializeCDR);
        this.deserializeCDR.finishDeserialize();
    }

    public static int getMaxCdrSerializedSize() {
        return OdometryPubSubType.getMaxCdrSerializedSize(0);
    }

    public static int getMaxCdrSerializedSize(int current_alignment) {
        int initial_alignment = current_alignment;
        current_alignment += HeaderPubSubType.getMaxCdrSerializedSize(current_alignment);
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4) + 255 + 1;
        current_alignment += PoseWithCovariancePubSubType.getMaxCdrSerializedSize(current_alignment);
        current_alignment += TwistWithCovariancePubSubType.getMaxCdrSerializedSize(current_alignment);
        return current_alignment - initial_alignment;
    }

    public static final int getCdrSerializedSize(Odometry data) {
        return OdometryPubSubType.getCdrSerializedSize(data, 0);
    }

    public static final int getCdrSerializedSize(Odometry data, int current_alignment) {
        int initial_alignment = current_alignment;
        current_alignment += HeaderPubSubType.getCdrSerializedSize(data.getHeader(), current_alignment);
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4) + data.getChildFrameId().length() + 1;
        current_alignment += PoseWithCovariancePubSubType.getCdrSerializedSize(data.getPose(), current_alignment);
        current_alignment += TwistWithCovariancePubSubType.getCdrSerializedSize(data.getTwist(), current_alignment);
        return current_alignment - initial_alignment;
    }

    public static void write(Odometry data, CDR cdr) {
        HeaderPubSubType.write(data.getHeader(), cdr);
        if (data.getChildFrameId().length() > 255) {
            throw new RuntimeException("child_frame_id field exceeds the maximum length");
        }
        cdr.write_type_d(data.getChildFrameId());
        PoseWithCovariancePubSubType.write(data.getPose(), cdr);
        TwistWithCovariancePubSubType.write(data.getTwist(), cdr);
    }

    public static void read(Odometry data, CDR cdr) {
        HeaderPubSubType.read(data.getHeader(), cdr);
        cdr.read_type_d(data.getChildFrameId());
        PoseWithCovariancePubSubType.read(data.getPose(), cdr);
        TwistWithCovariancePubSubType.read(data.getTwist(), cdr);
    }

    public final void serialize(Odometry data, InterchangeSerializer ser) {
        ser.write_type_a("header", (TopicDataType)new HeaderPubSubType(), (Object)data.getHeader());
        ser.write_type_d("child_frame_id", data.getChildFrameId());
        ser.write_type_a("pose", (TopicDataType)new PoseWithCovariancePubSubType(), (Object)data.getPose());
        ser.write_type_a("twist", (TopicDataType)new TwistWithCovariancePubSubType(), (Object)data.getTwist());
    }

    public final void deserialize(InterchangeSerializer ser, Odometry data) {
        ser.read_type_a("header", (TopicDataType)new HeaderPubSubType(), (Object)data.getHeader());
        ser.read_type_d("child_frame_id", data.getChildFrameId());
        ser.read_type_a("pose", (TopicDataType)new PoseWithCovariancePubSubType(), (Object)data.getPose());
        ser.read_type_a("twist", (TopicDataType)new TwistWithCovariancePubSubType(), (Object)data.getTwist());
    }

    public static void staticCopy(Odometry src, Odometry dest) {
        dest.set(src);
    }

    public Odometry createData() {
        return new Odometry();
    }

    public int getTypeSize() {
        return CDR.getTypeSize((int)OdometryPubSubType.getMaxCdrSerializedSize());
    }

    public String getName() {
        return name;
    }

    public void serialize(Odometry data, CDR cdr) {
        OdometryPubSubType.write(data, cdr);
    }

    public void deserialize(Odometry data, CDR cdr) {
        OdometryPubSubType.read(data, cdr);
    }

    public void copy(Odometry src, Odometry dest) {
        OdometryPubSubType.staticCopy(src, dest);
    }

    public OdometryPubSubType newInstance() {
        return new OdometryPubSubType();
    }
}

