/*
 * Decompiled with CFR 0.152.
 */
package sensor_msgs.msg.dds;

import java.util.Arrays;
import java.util.function.Supplier;
import sensor_msgs.msg.dds.NavSatFixPubSubType;
import sensor_msgs.msg.dds.NavSatStatus;
import sensor_msgs.msg.dds.NavSatStatusPubSubType;
import std_msgs.msg.dds.Header;
import std_msgs.msg.dds.HeaderPubSubType;
import us.ihmc.communication.packets.Packet;
import us.ihmc.euclid.interfaces.EpsilonComparable;
import us.ihmc.euclid.interfaces.Settable;
import us.ihmc.idl.IDLTools;
import us.ihmc.pubsub.TopicDataType;

public class NavSatFix
extends Packet<NavSatFix>
implements Settable<NavSatFix>,
EpsilonComparable<NavSatFix> {
    public static final byte COVARIANCE_TYPE_UNKNOWN = 0;
    public static final byte COVARIANCE_TYPE_APPROXIMATED = 1;
    public static final byte COVARIANCE_TYPE_DIAGONAL_KNOWN = 2;
    public static final byte COVARIANCE_TYPE_KNOWN = 3;
    public Header header_ = new Header();
    public NavSatStatus status_ = new NavSatStatus();
    public double latitude_;
    public double longitude_;
    public double altitude_;
    public double[] position_covariance_ = new double[9];
    public byte position_covariance_type_;

    public NavSatFix() {
    }

    public NavSatFix(NavSatFix other) {
        this();
        this.set(other);
    }

    public void set(NavSatFix other) {
        HeaderPubSubType.staticCopy(other.header_, this.header_);
        NavSatStatusPubSubType.staticCopy(other.status_, this.status_);
        this.latitude_ = other.latitude_;
        this.longitude_ = other.longitude_;
        this.altitude_ = other.altitude_;
        for (int i1 = 0; i1 < this.position_covariance_.length; ++i1) {
            this.position_covariance_[i1] = other.position_covariance_[i1];
        }
        this.position_covariance_type_ = other.position_covariance_type_;
    }

    public Header getHeader() {
        return this.header_;
    }

    public NavSatStatus getStatus() {
        return this.status_;
    }

    public void setLatitude(double latitude) {
        this.latitude_ = latitude;
    }

    public double getLatitude() {
        return this.latitude_;
    }

    public void setLongitude(double longitude) {
        this.longitude_ = longitude;
    }

    public double getLongitude() {
        return this.longitude_;
    }

    public void setAltitude(double altitude) {
        this.altitude_ = altitude;
    }

    public double getAltitude() {
        return this.altitude_;
    }

    public double[] getPositionCovariance() {
        return this.position_covariance_;
    }

    public void setPositionCovarianceType(byte position_covariance_type) {
        this.position_covariance_type_ = position_covariance_type;
    }

    public byte getPositionCovarianceType() {
        return this.position_covariance_type_;
    }

    public static Supplier<NavSatFixPubSubType> getPubSubType() {
        return NavSatFixPubSubType::new;
    }

    public Supplier<TopicDataType> getPubSubTypePacket() {
        return NavSatFixPubSubType::new;
    }

    public boolean epsilonEquals(NavSatFix other, double epsilon) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (!this.header_.epsilonEquals(other.header_, epsilon)) {
            return false;
        }
        if (!this.status_.epsilonEquals(other.status_, epsilon)) {
            return false;
        }
        if (!IDLTools.epsilonEqualsPrimitive((double)this.latitude_, (double)other.latitude_, (double)epsilon)) {
            return false;
        }
        if (!IDLTools.epsilonEqualsPrimitive((double)this.longitude_, (double)other.longitude_, (double)epsilon)) {
            return false;
        }
        if (!IDLTools.epsilonEqualsPrimitive((double)this.altitude_, (double)other.altitude_, (double)epsilon)) {
            return false;
        }
        for (int i3 = 0; i3 < this.position_covariance_.length; ++i3) {
            if (IDLTools.epsilonEqualsPrimitive((double)this.position_covariance_[i3], (double)other.position_covariance_[i3], (double)epsilon)) continue;
            return false;
        }
        return IDLTools.epsilonEqualsPrimitive((double)this.position_covariance_type_, (double)other.position_covariance_type_, (double)epsilon);
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (!(other instanceof NavSatFix)) {
            return false;
        }
        NavSatFix otherMyClass = (NavSatFix)((Object)other);
        if (!this.header_.equals((Object)otherMyClass.header_)) {
            return false;
        }
        if (!this.status_.equals((Object)otherMyClass.status_)) {
            return false;
        }
        if (this.latitude_ != otherMyClass.latitude_) {
            return false;
        }
        if (this.longitude_ != otherMyClass.longitude_) {
            return false;
        }
        if (this.altitude_ != otherMyClass.altitude_) {
            return false;
        }
        for (int i5 = 0; i5 < this.position_covariance_.length; ++i5) {
            if (this.position_covariance_[i5] == otherMyClass.position_covariance_[i5]) continue;
            return false;
        }
        return this.position_covariance_type_ == otherMyClass.position_covariance_type_;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("NavSatFix {");
        builder.append("header=");
        builder.append((Object)this.header_);
        builder.append(", ");
        builder.append("status=");
        builder.append((Object)this.status_);
        builder.append(", ");
        builder.append("latitude=");
        builder.append(this.latitude_);
        builder.append(", ");
        builder.append("longitude=");
        builder.append(this.longitude_);
        builder.append(", ");
        builder.append("altitude=");
        builder.append(this.altitude_);
        builder.append(", ");
        builder.append("position_covariance=");
        builder.append(Arrays.toString(this.position_covariance_));
        builder.append(", ");
        builder.append("position_covariance_type=");
        builder.append(this.position_covariance_type_);
        builder.append("}");
        return builder.toString();
    }
}

