/*
 * Decompiled with CFR 0.152.
 */
package sensor_msgs.msg.dds;

import java.io.IOException;
import sensor_msgs.msg.dds.CompressedImage;
import std_msgs.msg.dds.HeaderPubSubType;
import us.ihmc.idl.CDR;
import us.ihmc.idl.IDLSequence;
import us.ihmc.idl.InterchangeSerializer;
import us.ihmc.pubsub.TopicDataType;
import us.ihmc.pubsub.common.SerializedPayload;

public class CompressedImagePubSubType
implements TopicDataType<CompressedImage> {
    public static final String name = "sensor_msgs::msg::dds_::CompressedImage_";
    private final CDR serializeCDR = new CDR();
    private final CDR deserializeCDR = new CDR();

    public final String getDefinitionChecksum() {
        return "f54c830d1b2fb7405c89bd687995deb03ba88c50c0c0e0df3e9e5437e8dca85b";
    }

    public final String getDefinitionVersion() {
        return "local";
    }

    public void serialize(CompressedImage data, SerializedPayload serializedPayload) throws IOException {
        this.serializeCDR.serialize(serializedPayload);
        CompressedImagePubSubType.write(data, this.serializeCDR);
        this.serializeCDR.finishSerialize();
    }

    public void deserialize(SerializedPayload serializedPayload, CompressedImage data) throws IOException {
        this.deserializeCDR.deserialize(serializedPayload);
        CompressedImagePubSubType.read(data, this.deserializeCDR);
        this.deserializeCDR.finishDeserialize();
    }

    public static int getMaxCdrSerializedSize() {
        return CompressedImagePubSubType.getMaxCdrSerializedSize(0);
    }

    public static int getMaxCdrSerializedSize(int current_alignment) {
        int initial_alignment = current_alignment;
        current_alignment += HeaderPubSubType.getMaxCdrSerializedSize(current_alignment);
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4) + 255 + 1;
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        current_alignment += 100 + CDR.alignment((int)current_alignment, (int)1);
        return current_alignment - initial_alignment;
    }

    public static final int getCdrSerializedSize(CompressedImage data) {
        return CompressedImagePubSubType.getCdrSerializedSize(data, 0);
    }

    public static final int getCdrSerializedSize(CompressedImage data, int current_alignment) {
        int initial_alignment = current_alignment;
        current_alignment += HeaderPubSubType.getCdrSerializedSize(data.getHeader(), current_alignment);
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4) + data.getFormat().length() + 1;
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        current_alignment += data.getData().size() * 1 + CDR.alignment((int)current_alignment, (int)1);
        return current_alignment - initial_alignment;
    }

    public static void write(CompressedImage data, CDR cdr) {
        HeaderPubSubType.write(data.getHeader(), cdr);
        if (data.getFormat().length() > 255) {
            throw new RuntimeException("format field exceeds the maximum length");
        }
        cdr.write_type_d(data.getFormat());
        if (data.getData().size() > 100) {
            throw new RuntimeException("data field exceeds the maximum length");
        }
        cdr.write_type_e((IDLSequence)data.getData());
    }

    public static void read(CompressedImage data, CDR cdr) {
        HeaderPubSubType.read(data.getHeader(), cdr);
        cdr.read_type_d(data.getFormat());
        cdr.read_type_e((IDLSequence)data.getData());
    }

    public final void serialize(CompressedImage data, InterchangeSerializer ser) {
        ser.write_type_a("header", (TopicDataType)new HeaderPubSubType(), (Object)data.getHeader());
        ser.write_type_d("format", data.getFormat());
        ser.write_type_e("data", (IDLSequence)data.getData());
    }

    public final void deserialize(InterchangeSerializer ser, CompressedImage data) {
        ser.read_type_a("header", (TopicDataType)new HeaderPubSubType(), (Object)data.getHeader());
        ser.read_type_d("format", data.getFormat());
        ser.read_type_e("data", (IDLSequence)data.getData());
    }

    public static void staticCopy(CompressedImage src, CompressedImage dest) {
        dest.set(src);
    }

    public CompressedImage createData() {
        return new CompressedImage();
    }

    public int getTypeSize() {
        return CDR.getTypeSize((int)CompressedImagePubSubType.getMaxCdrSerializedSize());
    }

    public String getName() {
        return name;
    }

    public void serialize(CompressedImage data, CDR cdr) {
        CompressedImagePubSubType.write(data, cdr);
    }

    public void deserialize(CompressedImage data, CDR cdr) {
        CompressedImagePubSubType.read(data, cdr);
    }

    public void copy(CompressedImage src, CompressedImage dest) {
        CompressedImagePubSubType.staticCopy(src, dest);
    }

    public CompressedImagePubSubType newInstance() {
        return new CompressedImagePubSubType();
    }
}

