/*
 * Decompiled with CFR 0.152.
 */
package diagnostic_msgs.msg.dds;

import diagnostic_msgs.msg.dds.DiagnosticArray;
import diagnostic_msgs.msg.dds.DiagnosticStatus;
import diagnostic_msgs.msg.dds.DiagnosticStatusPubSubType;
import java.io.IOException;
import std_msgs.msg.dds.HeaderPubSubType;
import us.ihmc.idl.CDR;
import us.ihmc.idl.InterchangeSerializer;
import us.ihmc.pubsub.TopicDataType;
import us.ihmc.pubsub.common.SerializedPayload;

public class DiagnosticArrayPubSubType
implements TopicDataType<DiagnosticArray> {
    public static final String name = "diagnostic_msgs::msg::dds_::DiagnosticArray_";
    private final CDR serializeCDR = new CDR();
    private final CDR deserializeCDR = new CDR();

    public final String getDefinitionChecksum() {
        return "2a2a9de54629bbfce41305abdad4d0449398b890a64c4bf43bd8a2422aa8d60e";
    }

    public final String getDefinitionVersion() {
        return "local";
    }

    public void serialize(DiagnosticArray data, SerializedPayload serializedPayload) throws IOException {
        this.serializeCDR.serialize(serializedPayload);
        DiagnosticArrayPubSubType.write(data, this.serializeCDR);
        this.serializeCDR.finishSerialize();
    }

    public void deserialize(SerializedPayload serializedPayload, DiagnosticArray data) throws IOException {
        this.deserializeCDR.deserialize(serializedPayload);
        DiagnosticArrayPubSubType.read(data, this.deserializeCDR);
        this.deserializeCDR.finishDeserialize();
    }

    public static int getMaxCdrSerializedSize() {
        return DiagnosticArrayPubSubType.getMaxCdrSerializedSize(0);
    }

    public static int getMaxCdrSerializedSize(int current_alignment) {
        int initial_alignment = current_alignment;
        current_alignment += HeaderPubSubType.getMaxCdrSerializedSize(current_alignment);
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        for (int i0 = 0; i0 < 100; ++i0) {
            current_alignment += DiagnosticStatusPubSubType.getMaxCdrSerializedSize(current_alignment);
        }
        return current_alignment - initial_alignment;
    }

    public static final int getCdrSerializedSize(DiagnosticArray data) {
        return DiagnosticArrayPubSubType.getCdrSerializedSize(data, 0);
    }

    public static final int getCdrSerializedSize(DiagnosticArray data, int current_alignment) {
        int initial_alignment = current_alignment;
        current_alignment += HeaderPubSubType.getCdrSerializedSize(data.getHeader(), current_alignment);
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        for (int i0 = 0; i0 < data.getStatus().size(); ++i0) {
            current_alignment += DiagnosticStatusPubSubType.getCdrSerializedSize((DiagnosticStatus)((Object)data.getStatus().get(i0)), current_alignment);
        }
        return current_alignment - initial_alignment;
    }

    public static void write(DiagnosticArray data, CDR cdr) {
        HeaderPubSubType.write(data.getHeader(), cdr);
        if (data.getStatus().size() > 100) {
            throw new RuntimeException("status field exceeds the maximum length");
        }
        cdr.write_type_e(data.getStatus());
    }

    public static void read(DiagnosticArray data, CDR cdr) {
        HeaderPubSubType.read(data.getHeader(), cdr);
        cdr.read_type_e(data.getStatus());
    }

    public final void serialize(DiagnosticArray data, InterchangeSerializer ser) {
        ser.write_type_a("header", (TopicDataType)new HeaderPubSubType(), (Object)data.getHeader());
        ser.write_type_e("status", data.getStatus());
    }

    public final void deserialize(InterchangeSerializer ser, DiagnosticArray data) {
        ser.read_type_a("header", (TopicDataType)new HeaderPubSubType(), (Object)data.getHeader());
        ser.read_type_e("status", data.getStatus());
    }

    public static void staticCopy(DiagnosticArray src, DiagnosticArray dest) {
        dest.set(src);
    }

    public DiagnosticArray createData() {
        return new DiagnosticArray();
    }

    public int getTypeSize() {
        return CDR.getTypeSize((int)DiagnosticArrayPubSubType.getMaxCdrSerializedSize());
    }

    public String getName() {
        return name;
    }

    public void serialize(DiagnosticArray data, CDR cdr) {
        DiagnosticArrayPubSubType.write(data, cdr);
    }

    public void deserialize(DiagnosticArray data, CDR cdr) {
        DiagnosticArrayPubSubType.read(data, cdr);
    }

    public void copy(DiagnosticArray src, DiagnosticArray dest) {
        DiagnosticArrayPubSubType.staticCopy(src, dest);
    }

    public DiagnosticArrayPubSubType newInstance() {
        return new DiagnosticArrayPubSubType();
    }
}

