/*
 * Decompiled with CFR 0.152.
 */
package sensor_msgs.msg.dds;

import java.io.IOException;
import sensor_msgs.msg.dds.LaserScan;
import std_msgs.msg.dds.HeaderPubSubType;
import us.ihmc.idl.CDR;
import us.ihmc.idl.IDLSequence;
import us.ihmc.idl.InterchangeSerializer;
import us.ihmc.pubsub.TopicDataType;
import us.ihmc.pubsub.common.SerializedPayload;

public class LaserScanPubSubType
implements TopicDataType<LaserScan> {
    public static final String name = "sensor_msgs::msg::dds_::LaserScan_";
    private final CDR serializeCDR = new CDR();
    private final CDR deserializeCDR = new CDR();

    public final String getDefinitionChecksum() {
        return "c73692c598e973bfa26a18a015cf556cee47ce24c979da08f36c09d284031b3c";
    }

    public final String getDefinitionVersion() {
        return "local";
    }

    public void serialize(LaserScan data, SerializedPayload serializedPayload) throws IOException {
        this.serializeCDR.serialize(serializedPayload);
        LaserScanPubSubType.write(data, this.serializeCDR);
        this.serializeCDR.finishSerialize();
    }

    public void deserialize(SerializedPayload serializedPayload, LaserScan data) throws IOException {
        this.deserializeCDR.deserialize(serializedPayload);
        LaserScanPubSubType.read(data, this.deserializeCDR);
        this.deserializeCDR.finishDeserialize();
    }

    public static int getMaxCdrSerializedSize() {
        return LaserScanPubSubType.getMaxCdrSerializedSize(0);
    }

    public static int getMaxCdrSerializedSize(int current_alignment) {
        int initial_alignment = current_alignment;
        current_alignment += HeaderPubSubType.getMaxCdrSerializedSize(current_alignment);
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        current_alignment += 400 + CDR.alignment((int)current_alignment, (int)4);
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        current_alignment += 400 + CDR.alignment((int)current_alignment, (int)4);
        return current_alignment - initial_alignment;
    }

    public static final int getCdrSerializedSize(LaserScan data) {
        return LaserScanPubSubType.getCdrSerializedSize(data, 0);
    }

    public static final int getCdrSerializedSize(LaserScan data, int current_alignment) {
        int initial_alignment = current_alignment;
        current_alignment += HeaderPubSubType.getCdrSerializedSize(data.getHeader(), current_alignment);
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        current_alignment += data.getRanges().size() * 4 + CDR.alignment((int)current_alignment, (int)4);
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        current_alignment += data.getIntensities().size() * 4 + CDR.alignment((int)current_alignment, (int)4);
        return current_alignment - initial_alignment;
    }

    public static void write(LaserScan data, CDR cdr) {
        HeaderPubSubType.write(data.getHeader(), cdr);
        cdr.write_type_5(data.getAngleMin());
        cdr.write_type_5(data.getAngleMax());
        cdr.write_type_5(data.getAngleIncrement());
        cdr.write_type_5(data.getTimeIncrement());
        cdr.write_type_5(data.getScanTime());
        cdr.write_type_5(data.getRangeMin());
        cdr.write_type_5(data.getRangeMax());
        if (data.getRanges().size() > 100) {
            throw new RuntimeException("ranges field exceeds the maximum length");
        }
        cdr.write_type_e((IDLSequence)data.getRanges());
        if (data.getIntensities().size() > 100) {
            throw new RuntimeException("intensities field exceeds the maximum length");
        }
        cdr.write_type_e((IDLSequence)data.getIntensities());
    }

    public static void read(LaserScan data, CDR cdr) {
        HeaderPubSubType.read(data.getHeader(), cdr);
        data.setAngleMin(cdr.read_type_5());
        data.setAngleMax(cdr.read_type_5());
        data.setAngleIncrement(cdr.read_type_5());
        data.setTimeIncrement(cdr.read_type_5());
        data.setScanTime(cdr.read_type_5());
        data.setRangeMin(cdr.read_type_5());
        data.setRangeMax(cdr.read_type_5());
        cdr.read_type_e((IDLSequence)data.getRanges());
        cdr.read_type_e((IDLSequence)data.getIntensities());
    }

    public final void serialize(LaserScan data, InterchangeSerializer ser) {
        ser.write_type_a("header", (TopicDataType)new HeaderPubSubType(), (Object)data.getHeader());
        ser.write_type_5("angle_min", data.getAngleMin());
        ser.write_type_5("angle_max", data.getAngleMax());
        ser.write_type_5("angle_increment", data.getAngleIncrement());
        ser.write_type_5("time_increment", data.getTimeIncrement());
        ser.write_type_5("scan_time", data.getScanTime());
        ser.write_type_5("range_min", data.getRangeMin());
        ser.write_type_5("range_max", data.getRangeMax());
        ser.write_type_e("ranges", (IDLSequence)data.getRanges());
        ser.write_type_e("intensities", (IDLSequence)data.getIntensities());
    }

    public final void deserialize(InterchangeSerializer ser, LaserScan data) {
        ser.read_type_a("header", (TopicDataType)new HeaderPubSubType(), (Object)data.getHeader());
        data.setAngleMin(ser.read_type_5("angle_min"));
        data.setAngleMax(ser.read_type_5("angle_max"));
        data.setAngleIncrement(ser.read_type_5("angle_increment"));
        data.setTimeIncrement(ser.read_type_5("time_increment"));
        data.setScanTime(ser.read_type_5("scan_time"));
        data.setRangeMin(ser.read_type_5("range_min"));
        data.setRangeMax(ser.read_type_5("range_max"));
        ser.read_type_e("ranges", (IDLSequence)data.getRanges());
        ser.read_type_e("intensities", (IDLSequence)data.getIntensities());
    }

    public static void staticCopy(LaserScan src, LaserScan dest) {
        dest.set(src);
    }

    public LaserScan createData() {
        return new LaserScan();
    }

    public int getTypeSize() {
        return CDR.getTypeSize((int)LaserScanPubSubType.getMaxCdrSerializedSize());
    }

    public String getName() {
        return name;
    }

    public void serialize(LaserScan data, CDR cdr) {
        LaserScanPubSubType.write(data, cdr);
    }

    public void deserialize(LaserScan data, CDR cdr) {
        LaserScanPubSubType.read(data, cdr);
    }

    public void copy(LaserScan src, LaserScan dest) {
        LaserScanPubSubType.staticCopy(src, dest);
    }

    public LaserScanPubSubType newInstance() {
        return new LaserScanPubSubType();
    }
}

