/*
 * Decompiled with CFR 0.152.
 */
package diagnostic_msgs.msg.dds;

import diagnostic_msgs.msg.dds.KeyValue;
import java.io.IOException;
import us.ihmc.idl.CDR;
import us.ihmc.idl.InterchangeSerializer;
import us.ihmc.pubsub.TopicDataType;
import us.ihmc.pubsub.common.SerializedPayload;

public class KeyValuePubSubType
implements TopicDataType<KeyValue> {
    public static final String name = "diagnostic_msgs::msg::dds_::KeyValue_";
    private final CDR serializeCDR = new CDR();
    private final CDR deserializeCDR = new CDR();

    public final String getDefinitionChecksum() {
        return "683d2f4a0f766d3a06f94da811dfcbfa9ba2c42059e71f9f39d306dd29a0bbfd";
    }

    public final String getDefinitionVersion() {
        return "local";
    }

    public void serialize(KeyValue data, SerializedPayload serializedPayload) throws IOException {
        this.serializeCDR.serialize(serializedPayload);
        KeyValuePubSubType.write(data, this.serializeCDR);
        this.serializeCDR.finishSerialize();
    }

    public void deserialize(SerializedPayload serializedPayload, KeyValue data) throws IOException {
        this.deserializeCDR.deserialize(serializedPayload);
        KeyValuePubSubType.read(data, this.deserializeCDR);
        this.deserializeCDR.finishDeserialize();
    }

    public static int getMaxCdrSerializedSize() {
        return KeyValuePubSubType.getMaxCdrSerializedSize(0);
    }

    public static int getMaxCdrSerializedSize(int current_alignment) {
        int initial_alignment = current_alignment;
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4) + 255 + 1;
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4) + 255 + 1;
        return current_alignment - initial_alignment;
    }

    public static final int getCdrSerializedSize(KeyValue data) {
        return KeyValuePubSubType.getCdrSerializedSize(data, 0);
    }

    public static final int getCdrSerializedSize(KeyValue data, int current_alignment) {
        int initial_alignment = current_alignment;
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4) + data.getKey().length() + 1;
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4) + data.getValue().length() + 1;
        return current_alignment - initial_alignment;
    }

    public static void write(KeyValue data, CDR cdr) {
        if (data.getKey().length() > 255) {
            throw new RuntimeException("key field exceeds the maximum length");
        }
        cdr.write_type_d(data.getKey());
        if (data.getValue().length() > 255) {
            throw new RuntimeException("value field exceeds the maximum length");
        }
        cdr.write_type_d(data.getValue());
    }

    public static void read(KeyValue data, CDR cdr) {
        cdr.read_type_d(data.getKey());
        cdr.read_type_d(data.getValue());
    }

    public final void serialize(KeyValue data, InterchangeSerializer ser) {
        ser.write_type_d("key", data.getKey());
        ser.write_type_d("value", data.getValue());
    }

    public final void deserialize(InterchangeSerializer ser, KeyValue data) {
        ser.read_type_d("key", data.getKey());
        ser.read_type_d("value", data.getValue());
    }

    public static void staticCopy(KeyValue src, KeyValue dest) {
        dest.set(src);
    }

    public KeyValue createData() {
        return new KeyValue();
    }

    public int getTypeSize() {
        return CDR.getTypeSize((int)KeyValuePubSubType.getMaxCdrSerializedSize());
    }

    public String getName() {
        return name;
    }

    public void serialize(KeyValue data, CDR cdr) {
        KeyValuePubSubType.write(data, cdr);
    }

    public void deserialize(KeyValue data, CDR cdr) {
        KeyValuePubSubType.read(data, cdr);
    }

    public void copy(KeyValue src, KeyValue dest) {
        KeyValuePubSubType.staticCopy(src, dest);
    }

    public KeyValuePubSubType newInstance() {
        return new KeyValuePubSubType();
    }
}

