/*
 * Decompiled with CFR 0.152.
 */
package sensor_msgs.msg.dds;

import geometry_msgs.msg.dds.Vector3PubSubType;
import java.io.IOException;
import sensor_msgs.msg.dds.MagneticField;
import std_msgs.msg.dds.HeaderPubSubType;
import us.ihmc.idl.CDR;
import us.ihmc.idl.InterchangeSerializer;
import us.ihmc.pubsub.TopicDataType;
import us.ihmc.pubsub.common.SerializedPayload;

public class MagneticFieldPubSubType
implements TopicDataType<MagneticField> {
    public static final String name = "sensor_msgs::msg::dds_::MagneticField_";
    private final CDR serializeCDR = new CDR();
    private final CDR deserializeCDR = new CDR();

    public void serialize(MagneticField data, SerializedPayload serializedPayload) throws IOException {
        this.serializeCDR.serialize(serializedPayload);
        MagneticFieldPubSubType.write(data, this.serializeCDR);
        this.serializeCDR.finishSerialize();
    }

    public void deserialize(SerializedPayload serializedPayload, MagneticField data) throws IOException {
        this.deserializeCDR.deserialize(serializedPayload);
        MagneticFieldPubSubType.read(data, this.deserializeCDR);
        this.deserializeCDR.finishDeserialize();
    }

    public static int getMaxCdrSerializedSize() {
        return MagneticFieldPubSubType.getMaxCdrSerializedSize(0);
    }

    public static int getMaxCdrSerializedSize(int current_alignment) {
        int initial_alignment = current_alignment;
        current_alignment += HeaderPubSubType.getMaxCdrSerializedSize(current_alignment);
        current_alignment += Vector3PubSubType.getMaxCdrSerializedSize(current_alignment);
        current_alignment += 72 + CDR.alignment((int)current_alignment, (int)8);
        return current_alignment - initial_alignment;
    }

    public static final int getCdrSerializedSize(MagneticField data) {
        return MagneticFieldPubSubType.getCdrSerializedSize(data, 0);
    }

    public static final int getCdrSerializedSize(MagneticField data, int current_alignment) {
        int initial_alignment = current_alignment;
        current_alignment += HeaderPubSubType.getCdrSerializedSize(data.getHeader(), current_alignment);
        current_alignment += Vector3PubSubType.getCdrSerializedSize(data.getMagneticField(), current_alignment);
        current_alignment += 72 + CDR.alignment((int)current_alignment, (int)8);
        return current_alignment - initial_alignment;
    }

    public static void write(MagneticField data, CDR cdr) {
        HeaderPubSubType.write(data.getHeader(), cdr);
        Vector3PubSubType.write(data.getMagneticField(), cdr);
        for (int i0 = 0; i0 < data.getMagneticFieldCovariance().length; ++i0) {
            cdr.write_type_6(data.getMagneticFieldCovariance()[i0]);
        }
    }

    public static void read(MagneticField data, CDR cdr) {
        HeaderPubSubType.read(data.getHeader(), cdr);
        Vector3PubSubType.read(data.getMagneticField(), cdr);
        for (int i0 = 0; i0 < data.getMagneticFieldCovariance().length; ++i0) {
            data.getMagneticFieldCovariance()[i0] = cdr.read_type_6();
        }
    }

    public final void serialize(MagneticField data, InterchangeSerializer ser) {
        ser.write_type_a("header", (TopicDataType)new HeaderPubSubType(), (Object)data.getHeader());
        ser.write_type_a("magnetic_field", (TopicDataType)new Vector3PubSubType(), (Object)data.getMagneticField());
        ser.write_type_f("magnetic_field_covariance", data.getMagneticFieldCovariance());
    }

    public final void deserialize(InterchangeSerializer ser, MagneticField data) {
        ser.read_type_a("header", (TopicDataType)new HeaderPubSubType(), (Object)data.getHeader());
        ser.read_type_a("magnetic_field", (TopicDataType)new Vector3PubSubType(), (Object)data.getMagneticField());
        ser.read_type_f("magnetic_field_covariance", data.getMagneticFieldCovariance());
    }

    public static void staticCopy(MagneticField src, MagneticField dest) {
        dest.set(src);
    }

    public MagneticField createData() {
        return new MagneticField();
    }

    public int getTypeSize() {
        return CDR.getTypeSize((int)MagneticFieldPubSubType.getMaxCdrSerializedSize());
    }

    public String getName() {
        return name;
    }

    public void serialize(MagneticField data, CDR cdr) {
        MagneticFieldPubSubType.write(data, cdr);
    }

    public void deserialize(MagneticField data, CDR cdr) {
        MagneticFieldPubSubType.read(data, cdr);
    }

    public void copy(MagneticField src, MagneticField dest) {
        MagneticFieldPubSubType.staticCopy(src, dest);
    }

    public MagneticFieldPubSubType newInstance() {
        return new MagneticFieldPubSubType();
    }
}

