/*
 * Decompiled with CFR 0.152.
 */
package sensor_msgs.msg.dds;

import geometry_msgs.msg.dds.Point32PubSubType;
import java.util.function.Supplier;
import sensor_msgs.msg.dds.ChannelFloat32;
import sensor_msgs.msg.dds.ChannelFloat32PubSubType;
import sensor_msgs.msg.dds.PointCloudPubSubType;
import std_msgs.msg.dds.Header;
import std_msgs.msg.dds.HeaderPubSubType;
import us.ihmc.communication.packets.Packet;
import us.ihmc.euclid.interfaces.EpsilonComparable;
import us.ihmc.euclid.interfaces.Settable;
import us.ihmc.euclid.tuple3D.Point3D32;
import us.ihmc.idl.IDLSequence;
import us.ihmc.pubsub.TopicDataType;

public class PointCloud
extends Packet<PointCloud>
implements Settable<PointCloud>,
EpsilonComparable<PointCloud> {
    public Header header_ = new Header();
    public IDLSequence.Object<Point3D32> points_ = new IDLSequence.Object(100, (TopicDataType)new Point32PubSubType());
    public IDLSequence.Object<ChannelFloat32> channels_ = new IDLSequence.Object(100, (TopicDataType)new ChannelFloat32PubSubType());

    public PointCloud() {
    }

    public PointCloud(PointCloud other) {
        this();
        this.set(other);
    }

    public void set(PointCloud other) {
        HeaderPubSubType.staticCopy(other.header_, this.header_);
        this.points_.set(other.points_);
        this.channels_.set(other.channels_);
    }

    public Header getHeader() {
        return this.header_;
    }

    public IDLSequence.Object<Point3D32> getPoints() {
        return this.points_;
    }

    public IDLSequence.Object<ChannelFloat32> getChannels() {
        return this.channels_;
    }

    public static Supplier<PointCloudPubSubType> getPubSubType() {
        return PointCloudPubSubType::new;
    }

    public Supplier<TopicDataType> getPubSubTypePacket() {
        return PointCloudPubSubType::new;
    }

    public boolean epsilonEquals(PointCloud other, double epsilon) {
        int i;
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (!this.header_.epsilonEquals(other.header_, epsilon)) {
            return false;
        }
        if (this.points_.size() != other.points_.size()) {
            return false;
        }
        for (i = 0; i < this.points_.size(); ++i) {
            if (((Point3D32)this.points_.get(i)).epsilonEquals((Point3D32)other.points_.get(i), epsilon)) continue;
            return false;
        }
        if (this.channels_.size() != other.channels_.size()) {
            return false;
        }
        for (i = 0; i < this.channels_.size(); ++i) {
            if (((ChannelFloat32)((Object)this.channels_.get(i))).epsilonEquals((ChannelFloat32)((Object)other.channels_.get(i)), epsilon)) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (!(other instanceof PointCloud)) {
            return false;
        }
        PointCloud otherMyClass = (PointCloud)((Object)other);
        if (!this.header_.equals((Object)otherMyClass.header_)) {
            return false;
        }
        if (!this.points_.equals(otherMyClass.points_)) {
            return false;
        }
        return this.channels_.equals(otherMyClass.channels_);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("PointCloud {");
        builder.append("header=");
        builder.append((Object)this.header_);
        builder.append(", ");
        builder.append("points=");
        builder.append(this.points_);
        builder.append(", ");
        builder.append("channels=");
        builder.append(this.channels_);
        builder.append("}");
        return builder.toString();
    }
}

