/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotEnvironmentAwareness.updaters;

import java.util.concurrent.atomic.AtomicReference;
import us.ihmc.communication.packets.PlanarRegionMessageConverter;
import us.ihmc.messager.Messager;
import us.ihmc.robotEnvironmentAwareness.communication.SegmentationModuleAPI;
import us.ihmc.robotEnvironmentAwareness.communication.converters.REAPlanarRegionsConverter;
import us.ihmc.robotEnvironmentAwareness.updaters.RegionFeaturesProvider;
import us.ihmc.robotics.geometry.PlanarRegionsList;

public class SegmentationModuleStateReporter {
    private final Messager reaMessager;
    private final AtomicReference<Boolean> arePlanarRegionsRequested;
    private final AtomicReference<Boolean> isPlanarRegionSegmentationRequested;
    private final AtomicReference<Boolean> arePlanarRegionsIntersectionsRequested;

    public SegmentationModuleStateReporter(Messager reaMessager) {
        this.reaMessager = reaMessager;
        this.arePlanarRegionsRequested = reaMessager.createInput(SegmentationModuleAPI.RequestPlanarRegions, (Object)false);
        this.isPlanarRegionSegmentationRequested = reaMessager.createInput(SegmentationModuleAPI.RequestPlanarRegionSegmentation, (Object)false);
        this.arePlanarRegionsIntersectionsRequested = reaMessager.createInput(SegmentationModuleAPI.RequestPlanarRegionsIntersections, (Object)false);
    }

    public void reportPlanarRegionsState(RegionFeaturesProvider regionFeaturesProvider) {
        PlanarRegionsList planarRegionsList = regionFeaturesProvider.getPlanarRegionsList();
        if (planarRegionsList != null && planarRegionsList.getNumberOfPlanarRegions() > 0 && this.arePlanarRegionsRequested.getAndSet(false).booleanValue()) {
            this.reaMessager.submitMessage(SegmentationModuleAPI.PlanarRegionsState, (Object)PlanarRegionMessageConverter.convertToPlanarRegionsListMessage((PlanarRegionsList)planarRegionsList));
        }
        if (this.isPlanarRegionSegmentationRequested.getAndSet(false).booleanValue()) {
            this.reaMessager.submitMessage(SegmentationModuleAPI.PlanarRegionsSegmentationState, (Object)REAPlanarRegionsConverter.createPlanarRegionSegmentationMessages(regionFeaturesProvider));
        }
        if (this.arePlanarRegionsIntersectionsRequested.getAndSet(false).booleanValue()) {
            this.reaMessager.submitMessage(SegmentationModuleAPI.PlanarRegionsIntersectionState, (Object)REAPlanarRegionsConverter.createLineSegment3dMessages(regionFeaturesProvider));
        }
    }
}

