/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotEnvironmentAwareness.updaters;

import controller_msgs.msg.dds.StereoVisionPointCloudMessage;
import ihmc_common_msgs.msg.dds.StampedPosePacket;
import java.util.concurrent.atomic.AtomicReference;
import perception_msgs.msg.dds.LidarScanMessage;
import perception_msgs.msg.dds.NormalEstimationParametersMessage;
import perception_msgs.msg.dds.OcTreeKeyListMessage;
import perception_msgs.msg.dds.PlanarRegionSegmentationParametersMessage;
import perception_msgs.msg.dds.PlanarRegionsListMessage;
import perception_msgs.msg.dds.PolygonizerParametersMessage;
import perception_msgs.msg.dds.REASensorDataFilterParametersMessage;
import perception_msgs.msg.dds.REAStateRequestMessage;
import perception_msgs.msg.dds.RequestPlanarRegionsListMessage;
import us.ihmc.communication.ROS2Tools;
import us.ihmc.communication.packets.PlanarRegionMessageConverter;
import us.ihmc.jOctoMap.ocTree.NormalOcTree;
import us.ihmc.messager.Messager;
import us.ihmc.pubsub.DomainFactory;
import us.ihmc.robotEnvironmentAwareness.communication.REACommunicationProperties;
import us.ihmc.robotEnvironmentAwareness.communication.REAModuleAPI;
import us.ihmc.robotEnvironmentAwareness.communication.converters.REAParametersMessageHelper;
import us.ihmc.robotEnvironmentAwareness.ros.REAModuleROS2Subscription;
import us.ihmc.robotEnvironmentAwareness.ros.REASourceType;
import us.ihmc.robotEnvironmentAwareness.updaters.REACurrentStateProvider;
import us.ihmc.robotEnvironmentAwareness.updaters.REANetworkProvider;
import us.ihmc.robotEnvironmentAwareness.updaters.RegionFeaturesProvider;
import us.ihmc.robotics.geometry.PlanarRegionsList;
import us.ihmc.ros2.NewMessageListener;
import us.ihmc.ros2.ROS2Node;
import us.ihmc.ros2.ROS2NodeInterface;
import us.ihmc.ros2.ROS2PublisherBasics;
import us.ihmc.ros2.ROS2QosProfile;
import us.ihmc.ros2.ROS2Topic;

public class REAPlanarRegionPublicNetworkProvider
implements REANetworkProvider {
    private static final boolean publishOctree = false;
    private final ROS2PublisherBasics<PlanarRegionsListMessage> planarRegionPublisher;
    private final ROS2PublisherBasics<PlanarRegionsListMessage> lidarRegionPublisher;
    private final ROS2PublisherBasics<PlanarRegionsListMessage> stereoRegionPublisher;
    private final ROS2PublisherBasics<PlanarRegionsListMessage> depthRegionPublisher;
    private final ROS2PublisherBasics<OcTreeKeyListMessage> ocTreePublisher;
    private REACurrentStateProvider currentStateProvider = null;
    private AtomicReference<Boolean> isUsingLidar;
    private AtomicReference<Boolean> isUsingStereoVision;
    private AtomicReference<Boolean> isUsingDepthCloud;
    private final ROS2NodeInterface ros2Node;
    private final ROS2Topic<PlanarRegionsListMessage> outputTopic;
    private PlanarRegionsListMessage lastPlanarRegionsListMessage;

    public REAPlanarRegionPublicNetworkProvider(ROS2Topic outputTopic, ROS2Topic lidarOutputTopic, ROS2Topic stereoOutputTopic, ROS2Topic depthOutputTopic) {
        this((ROS2NodeInterface)ROS2Tools.createROS2Node((DomainFactory.PubSubImplementation)DomainFactory.PubSubImplementation.FAST_RTPS, (String)"REA_module"), outputTopic, lidarOutputTopic, stereoOutputTopic, depthOutputTopic);
    }

    public REAPlanarRegionPublicNetworkProvider(ROS2NodeInterface ros2Node, ROS2Topic outputTopic, ROS2Topic lidarOutputTopic, ROS2Topic stereoOutputTopic, ROS2Topic depthOutputTopic) {
        this.ros2Node = ros2Node;
        this.outputTopic = outputTopic;
        this.planarRegionPublisher = ros2Node.createPublisher(outputTopic.withTypeName(PlanarRegionsListMessage.class));
        this.lidarRegionPublisher = ros2Node.createPublisher(lidarOutputTopic.withTypeName(PlanarRegionsListMessage.class));
        this.stereoRegionPublisher = ros2Node.createPublisher(stereoOutputTopic.withTypeName(PlanarRegionsListMessage.class));
        this.depthRegionPublisher = ros2Node.createPublisher(depthOutputTopic.withTypeName(PlanarRegionsListMessage.class));
        this.ocTreePublisher = ros2Node.createPublisher(outputTopic.withTypeName(OcTreeKeyListMessage.class));
    }

    @Override
    public void registerMessager(Messager messager) {
        this.currentStateProvider = new REACurrentStateProvider(this.ros2Node, this.outputTopic, messager);
        this.isUsingLidar = messager.createInput(REAModuleAPI.LidarBufferEnable);
        this.isUsingStereoVision = messager.createInput(REAModuleAPI.StereoVisionBufferEnable);
        this.isUsingDepthCloud = messager.createInput(REAModuleAPI.DepthCloudBufferEnable);
        this.ros2Node.createSubscription(REACommunicationProperties.inputTopic.withTypeName(NormalEstimationParametersMessage.class), s -> messager.submitMessage(REAModuleAPI.NormalEstimationParameters, (Object)REAParametersMessageHelper.convertFromMessage((NormalEstimationParametersMessage)s.takeNextData())));
        this.ros2Node.createSubscription(REACommunicationProperties.inputTopic.withTypeName(PlanarRegionSegmentationParametersMessage.class), s -> messager.submitMessage(REAModuleAPI.PlanarRegionsSegmentationParameters, (Object)REAParametersMessageHelper.convertFromMessage((PlanarRegionSegmentationParametersMessage)s.takeNextData())));
        this.ros2Node.createSubscription(REACommunicationProperties.inputTopic.withTypeName(PolygonizerParametersMessage.class), s -> messager.submitMessage(REAModuleAPI.PlanarRegionsPolygonizerParameters, (Object)((PolygonizerParametersMessage)s.takeNextData())));
    }

    @Override
    public void update(RegionFeaturesProvider regionFeaturesProvider, boolean planarRegionsHaveBeenUpdated, NormalOcTree ocTree) {
        if (regionFeaturesProvider.getPlanarRegionsList() != null && !regionFeaturesProvider.getPlanarRegionsList().isEmpty()) {
            if (planarRegionsHaveBeenUpdated) {
                this.lastPlanarRegionsListMessage = PlanarRegionMessageConverter.convertToPlanarRegionsListMessage((PlanarRegionsList)regionFeaturesProvider.getPlanarRegionsList());
            }
            this.planarRegionPublisher.publish((Object)this.lastPlanarRegionsListMessage);
            if (this.isUsingLidar != null && this.isUsingLidar.get().booleanValue()) {
                this.lidarRegionPublisher.publish((Object)this.lastPlanarRegionsListMessage);
            }
            if (this.isUsingStereoVision != null && this.isUsingStereoVision.get().booleanValue()) {
                this.stereoRegionPublisher.publish((Object)this.lastPlanarRegionsListMessage);
            }
            if (this.isUsingDepthCloud != null && this.isUsingDepthCloud.get().booleanValue()) {
                this.depthRegionPublisher.publish((Object)this.lastPlanarRegionsListMessage);
            }
        }
    }

    @Override
    public void publishCurrentState() {
        if (this.currentStateProvider != null) {
            this.currentStateProvider.publishCurrentState();
        }
    }

    @Override
    public void registerLidarScanHandler(NewMessageListener<LidarScanMessage> lidarScanHandler) {
        String topicName = REASourceType.LIDAR_SCAN.getTopicName();
        this.ros2Node.createSubscription(LidarScanMessage.class, lidarScanHandler, topicName, ROS2QosProfile.BEST_EFFORT());
    }

    @Override
    public void registerStereoVisionPointCloudHandler(NewMessageListener<StereoVisionPointCloudMessage> stereoVisionPointCloudHandler) {
        String topicName = REASourceType.STEREO_POINT_CLOUD.getTopicName();
        this.ros2Node.createSubscription(StereoVisionPointCloudMessage.class, stereoVisionPointCloudHandler, topicName, ROS2QosProfile.BEST_EFFORT());
    }

    @Override
    public void registerLidarScanHandler(Messager messager, NewMessageListener<LidarScanMessage> lidarScanHandler) {
        new REAModuleROS2Subscription<LidarScanMessage>(this.ros2Node, messager, REASourceType.LIDAR_SCAN, LidarScanMessage.class, lidarScanHandler, ROS2QosProfile.BEST_EFFORT());
    }

    @Override
    public void registerStereoVisionPointCloudHandler(Messager messager, NewMessageListener<StereoVisionPointCloudMessage> stereoVisionPointCloudHandler) {
        new REAModuleROS2Subscription<StereoVisionPointCloudMessage>(this.ros2Node, messager, REASourceType.STEREO_POINT_CLOUD, StereoVisionPointCloudMessage.class, stereoVisionPointCloudHandler, ROS2QosProfile.BEST_EFFORT());
    }

    @Override
    public void registerDepthPointCloudHandler(Messager messager, NewMessageListener<StereoVisionPointCloudMessage> depthPointCloudHandler) {
        new REAModuleROS2Subscription<StereoVisionPointCloudMessage>(this.ros2Node, messager, REASourceType.DEPTH_POINT_CLOUD, StereoVisionPointCloudMessage.class, depthPointCloudHandler, ROS2QosProfile.BEST_EFFORT());
    }

    @Override
    public void registerStampedPosePacketHandler(Messager messager, NewMessageListener<StampedPosePacket> stampedPosePacketHandler) {
        new REAModuleROS2Subscription<StampedPosePacket>(this.ros2Node, messager, "/ihmc/stamped_pose_T265", StampedPosePacket.class, stampedPosePacketHandler, ROS2QosProfile.BEST_EFFORT(), REAModuleAPI.DepthCloudBufferEnable);
    }

    @Override
    public void registerCustomRegionsHandler(NewMessageListener<PlanarRegionsListMessage> customRegionsHandler) {
        this.ros2Node.createSubscription(REACommunicationProperties.subscriberCustomRegionsTopicName.withTypeName(PlanarRegionsListMessage.class), customRegionsHandler);
    }

    @Override
    public void registerPlanarRegionsListRequestHandler(NewMessageListener<RequestPlanarRegionsListMessage> requestHandler) {
        this.ros2Node.createSubscription(REACommunicationProperties.inputTopic.withTypeName(RequestPlanarRegionsListMessage.class), requestHandler);
    }

    @Override
    public void registerREAStateRequestHandler(NewMessageListener<REAStateRequestMessage> requestHandler) {
        this.ros2Node.createSubscription(REACommunicationProperties.inputTopic.withTypeName(REAStateRequestMessage.class), requestHandler);
    }

    @Override
    public void registerREASensorDataFilterParametersHandler(NewMessageListener<REASensorDataFilterParametersMessage> parametersHandler) {
        this.ros2Node.createSubscription(REACommunicationProperties.inputTopic.withTypeName(REASensorDataFilterParametersMessage.class), parametersHandler);
    }

    @Override
    public void stop() {
        if (this.ros2Node.getName().equals("REA_module")) {
            ((ROS2Node)this.ros2Node).destroy();
        }
    }
}

