/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotEnvironmentAwareness.updaters;

import controller_msgs.msg.dds.StereoVisionPointCloudMessage;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import perception_msgs.msg.dds.LidarScanMessage;
import us.ihmc.communication.packets.LidarPointCloudCompression;
import us.ihmc.communication.packets.StereoPointCloudCompression;
import us.ihmc.euclid.geometry.Pose3D;
import us.ihmc.euclid.geometry.interfaces.Pose3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.idl.IDLSequence;
import us.ihmc.jOctoMap.ocTree.NormalOcTree;
import us.ihmc.jOctoMap.pointCloud.PointCloud;
import us.ihmc.jOctoMap.pointCloud.Scan;
import us.ihmc.jOctoMap.pointCloud.ScanCollection;
import us.ihmc.messager.Messager;
import us.ihmc.messager.MessagerAPIFactory;
import us.ihmc.robotEnvironmentAwareness.communication.REAModuleAPI;
import us.ihmc.robotEnvironmentAwareness.communication.converters.OcTreeMessageConverter;
import us.ihmc.robotEnvironmentAwareness.communication.packets.NormalOcTreeMessage;
import us.ihmc.robotEnvironmentAwareness.io.FilePropertyHelper;

public class REAOcTreeBuffer {
    private static final int NUMBER_OF_SAMPLES = 100000;
    private final AtomicReference<LidarScanMessage> latestLidarScanMessage = new AtomicReference<Object>(null);
    private final AtomicReference<StereoVisionPointCloudMessage> latestStereoVisionPointCloudMessage = new AtomicReference<Object>(null);
    private final AtomicReference<StereoVisionPointCloudMessage> latestDepthCloudPointCloudMessage = new AtomicReference<Object>(null);
    private final AtomicReference<ScanCollection> newFullScanReference = new AtomicReference<Object>(null);
    private final AtomicReference<Pose3DReadOnly> newSensorPoseReference = new AtomicReference<Object>(null);
    private final AtomicReference<Boolean> enable;
    private final AtomicReference<Boolean> enableBuffer;
    private final AtomicReference<Integer> ocTreeCapacity;
    private final AtomicReference<Integer> messageCapacity;
    private final AtomicBoolean clearBuffer = new AtomicBoolean(false);
    private final AtomicBoolean isBufferFull = new AtomicBoolean(false);
    private final AtomicBoolean isBufferRequested = new AtomicBoolean(false);
    private final AtomicReference<NormalOcTree> newBuffer = new AtomicReference<Object>(null);
    private final AtomicReference<Pose3DReadOnly> newSensorPoseBuffer = new AtomicReference<Object>(null);
    private final AtomicReference<Boolean> isBufferStateRequested;
    private final AtomicReference<Double> octreeResolution;
    private int messageCounter = 0;
    private final Messager reaMessager;
    private final MessagerAPIFactory.Topic<Boolean> enableBufferTopic;
    private final MessagerAPIFactory.Topic<Integer> ocTreeCapacityTopic;
    private final MessagerAPIFactory.Topic<Integer> messageCapacityTopic;
    private final MessagerAPIFactory.Topic<NormalOcTreeMessage> stateTopic;
    private final AtomicReference<Integer> stereoVisionBufferSize;
    private final AtomicReference<Integer> depthCloudBufferSize;

    public REAOcTreeBuffer(double octreeResolution, Messager reaMessager, MessagerAPIFactory.Topic<Boolean> enableBufferTopic, boolean enableBufferInitialValue, MessagerAPIFactory.Topic<Integer> ocTreeCapacityTopic, int ocTreeCapacityValue, MessagerAPIFactory.Topic<Integer> messageCapacityTopic, int messageCapacityInitialValue, MessagerAPIFactory.Topic<Boolean> requestStateTopic, MessagerAPIFactory.Topic<NormalOcTreeMessage> stateTopic) {
        this.octreeResolution = new AtomicReference<Double>(octreeResolution);
        this.reaMessager = reaMessager;
        this.enableBufferTopic = enableBufferTopic;
        this.ocTreeCapacityTopic = ocTreeCapacityTopic;
        this.messageCapacityTopic = messageCapacityTopic;
        this.stateTopic = stateTopic;
        this.enable = reaMessager.createInput(REAModuleAPI.OcTreeEnable, (Object)true);
        this.enableBuffer = reaMessager.createInput(enableBufferTopic, (Object)enableBufferInitialValue);
        this.ocTreeCapacity = reaMessager.createInput(ocTreeCapacityTopic, (Object)ocTreeCapacityValue);
        this.messageCapacity = reaMessager.createInput(messageCapacityTopic, (Object)messageCapacityInitialValue);
        this.isBufferStateRequested = reaMessager.createInput(requestStateTopic, (Object)false);
        reaMessager.addTopicListener(REAModuleAPI.RequestEntireModuleState, messageContent -> this.sendCurrentState());
        this.stereoVisionBufferSize = reaMessager.createInput(REAModuleAPI.StereoVisionBufferSize, (Object)100000);
        this.depthCloudBufferSize = reaMessager.createInput(REAModuleAPI.DepthCloudBufferSize, (Object)100000);
    }

    private void sendCurrentState() {
        this.reaMessager.submitMessage(this.enableBufferTopic, (Object)this.enableBuffer.get());
        this.reaMessager.submitMessage(this.ocTreeCapacityTopic, (Object)this.ocTreeCapacity.get());
        this.reaMessager.submitMessage(this.messageCapacityTopic, (Object)this.messageCapacity.get());
    }

    public void loadConfiguration(FilePropertyHelper filePropertyHelper) {
        Integer messageCapacityFile;
        Integer ocTreeCapacityFile;
        Boolean enableBufferFile;
        Boolean enableFile = filePropertyHelper.loadBooleanProperty(REAModuleAPI.OcTreeEnable.getName());
        if (enableFile != null) {
            this.enable.set(enableFile);
        }
        if ((enableBufferFile = filePropertyHelper.loadBooleanProperty(this.enableBufferTopic.getName())) != null) {
            this.enableBuffer.set(enableBufferFile);
        }
        if ((ocTreeCapacityFile = filePropertyHelper.loadIntegerProperty(this.ocTreeCapacityTopic.getName())) != null) {
            this.ocTreeCapacity.set(ocTreeCapacityFile);
        }
        if ((messageCapacityFile = filePropertyHelper.loadIntegerProperty(this.messageCapacityTopic.getName())) != null) {
            this.messageCapacity.set(messageCapacityFile);
        }
    }

    public void saveConfiguration(FilePropertyHelper filePropertyHelper) {
        filePropertyHelper.saveProperty(this.enableBufferTopic.getName(), this.enableBuffer.get());
        filePropertyHelper.saveProperty(this.ocTreeCapacityTopic.getName(), this.ocTreeCapacity.get());
        filePropertyHelper.saveProperty(this.messageCapacityTopic.getName(), this.messageCapacity.get());
    }

    public Runnable createBufferThread() {
        return new Runnable(){
            private NormalOcTree bufferOctree;
            {
                this.bufferOctree = new NormalOcTree(REAOcTreeBuffer.this.octreeResolution.get().doubleValue());
            }

            @Override
            public void run() {
                REAOcTreeBuffer.this.updateScanCollection();
                ScanCollection newScan = REAOcTreeBuffer.this.newFullScanReference.getAndSet(null);
                Pose3DReadOnly newSensorPose = REAOcTreeBuffer.this.newSensorPoseReference.getAndSet(null);
                if (!REAOcTreeBuffer.this.enable.get().booleanValue() || !REAOcTreeBuffer.this.enableBuffer.get().booleanValue() || REAOcTreeBuffer.this.clearBuffer.getAndSet(false)) {
                    this.bufferOctree.clear();
                    REAOcTreeBuffer.this.messageCounter = 0;
                    REAOcTreeBuffer.this.isBufferFull.set(false);
                    REAOcTreeBuffer.this.isBufferRequested.set(false);
                    return;
                }
                if (newScan == null || newSensorPose == null) {
                    return;
                }
                this.bufferOctree.insertScanCollection(newScan, false);
                ++REAOcTreeBuffer.this.messageCounter;
                if (REAOcTreeBuffer.this.messageCounter >= REAOcTreeBuffer.this.messageCapacity.get()) {
                    REAOcTreeBuffer.this.isBufferFull.set(true);
                } else {
                    int numberOfLeafNodesInBuffer = this.bufferOctree.getNumberOfLeafNodes();
                    if (numberOfLeafNodesInBuffer >= REAOcTreeBuffer.this.ocTreeCapacity.get()) {
                        REAOcTreeBuffer.this.isBufferFull.set(true);
                    } else {
                        REAOcTreeBuffer.this.isBufferFull.set(false);
                        return;
                    }
                }
                if (REAOcTreeBuffer.this.isBufferRequested.get()) {
                    REAOcTreeBuffer.this.newBuffer.set(this.bufferOctree);
                    REAOcTreeBuffer.this.newSensorPoseBuffer.set(newSensorPose);
                    this.bufferOctree = new NormalOcTree(REAOcTreeBuffer.this.octreeResolution.get().doubleValue());
                    REAOcTreeBuffer.this.isBufferRequested.set(false);
                    REAOcTreeBuffer.this.messageCounter = 0;
                }
                if (REAOcTreeBuffer.this.isBufferStateRequested.getAndSet(false).booleanValue()) {
                    REAOcTreeBuffer.this.reaMessager.submitMessage(REAOcTreeBuffer.this.stateTopic, (Object)OcTreeMessageConverter.convertToMessage(this.bufferOctree));
                }
            }
        };
    }

    public void clearBuffer() {
        this.clearBuffer.set(true);
    }

    public void submitBufferRequest() {
        this.isBufferRequested.set(true);
    }

    public boolean isBufferFull() {
        return this.isBufferFull.get();
    }

    public NormalOcTree pollNewBuffer() {
        return this.newBuffer.getAndSet(null);
    }

    public Pose3DReadOnly pollNewSensorPoseBuffer() {
        return this.newSensorPoseBuffer.getAndSet(null);
    }

    public void setOctreeResolution(double resolution) {
        this.octreeResolution.set(resolution);
    }

    public void handleStereoVisionPointCloudMessage(StereoVisionPointCloudMessage message) {
        this.latestStereoVisionPointCloudMessage.set(message);
    }

    public void handleDepthCloudPointCloudMessage(StereoVisionPointCloudMessage message) {
        this.latestDepthCloudPointCloudMessage.set(message);
    }

    public void handleLidarScanMessage(LidarScanMessage message) {
        this.latestLidarScanMessage.set(message);
    }

    private void updateScanCollection() {
        Pose3D sensorPose;
        ScanCollection scanCollection;
        LidarScanMessage lidarMessage = this.latestLidarScanMessage.getAndSet(null);
        StereoVisionPointCloudMessage stereoMessage = this.latestStereoVisionPointCloudMessage.getAndSet(null);
        StereoVisionPointCloudMessage depthCloudMessage = this.latestDepthCloudPointCloudMessage.getAndSet(null);
        if (!this.enable.get().booleanValue() || !this.enableBuffer.get().booleanValue()) {
            return;
        }
        if (lidarMessage != null) {
            scanCollection = new ScanCollection();
            this.newFullScanReference.set(scanCollection);
            scanCollection.setSubSampleSize(100000);
            scanCollection.addScan(REAOcTreeBuffer.toScan(lidarMessage.getScan(), lidarMessage.getNumberOfPoints(), (Point3DReadOnly)lidarMessage.getLidarPosition()));
            sensorPose = new Pose3D();
            sensorPose.getPosition().set(lidarMessage.getLidarPosition());
            sensorPose.getOrientation().set(lidarMessage.getLidarOrientation());
            this.newSensorPoseReference.set((Pose3DReadOnly)sensorPose);
        }
        if (stereoMessage != null) {
            scanCollection = new ScanCollection();
            this.newFullScanReference.set(scanCollection);
            scanCollection.setSubSampleSize(this.stereoVisionBufferSize.get().intValue());
            scanCollection.addScan(REAOcTreeBuffer.toScan(stereoMessage));
            sensorPose = new Pose3D();
            sensorPose.getPosition().set(stereoMessage.getSensorPosition());
            sensorPose.getOrientation().set(stereoMessage.getSensorOrientation());
            this.newSensorPoseReference.set((Pose3DReadOnly)sensorPose);
        }
        if (depthCloudMessage != null) {
            scanCollection = new ScanCollection();
            this.newFullScanReference.set(scanCollection);
            scanCollection.setSubSampleSize(this.depthCloudBufferSize.get().intValue());
            scanCollection.addScan(REAOcTreeBuffer.toScan(stereoMessage));
            sensorPose = new Pose3D();
            sensorPose.getPosition().set(depthCloudMessage.getSensorPosition());
            sensorPose.getOrientation().set(depthCloudMessage.getSensorOrientation());
            this.newSensorPoseReference.set((Pose3DReadOnly)sensorPose);
        }
    }

    private static Scan toScan(StereoVisionPointCloudMessage stereoMessage) {
        PointCloud pointCloud = new PointCloud();
        StereoPointCloudCompression.decompressPointCloud((StereoVisionPointCloudMessage)stereoMessage, (arg_0, arg_1, arg_2) -> ((PointCloud)pointCloud).add(arg_0, arg_1, arg_2));
        return new Scan((Point3DReadOnly)stereoMessage.getSensorPosition(), pointCloud);
    }

    private static Scan toScan(IDLSequence.Byte data, int numberOfPoints, Point3DReadOnly sensorPosition) {
        PointCloud pointCloud = new PointCloud();
        LidarPointCloudCompression.decompressPointCloud((IDLSequence.Byte)data, (int)numberOfPoints, (i, x, y, z) -> pointCloud.add(x, y, z));
        return new Scan(sensorPosition, pointCloud);
    }
}

