/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotEnvironmentAwareness.updaters;

import controller_msgs.msg.dds.StereoVisionPointCloudMessage;
import java.util.concurrent.atomic.AtomicReference;
import perception_msgs.msg.dds.LidarScanMessage;
import us.ihmc.communication.packets.PlanarRegionMessageConverter;
import us.ihmc.euclid.geometry.Pose3D;
import us.ihmc.euclid.geometry.interfaces.Pose3DReadOnly;
import us.ihmc.jOctoMap.ocTree.NormalOcTree;
import us.ihmc.messager.Messager;
import us.ihmc.robotEnvironmentAwareness.communication.REAModuleAPI;
import us.ihmc.robotEnvironmentAwareness.communication.converters.BoundingBoxMessageConverter;
import us.ihmc.robotEnvironmentAwareness.communication.converters.OcTreeMessageConverter;
import us.ihmc.robotEnvironmentAwareness.communication.converters.REAPlanarRegionsConverter;
import us.ihmc.robotEnvironmentAwareness.updaters.RegionFeaturesProvider;
import us.ihmc.robotics.geometry.PlanarRegionsList;

public class REAModuleStateReporter {
    private final Messager reaMessager;
    private final AtomicReference<Boolean> isOcTreeRequested;
    private final AtomicReference<Boolean> isOcTreeBoundingBoxRequested;
    private final AtomicReference<Boolean> arePlanarRegionsRequested;
    private final AtomicReference<Boolean> isPlanarRegionSegmentationRequested;
    private final AtomicReference<Boolean> arePlanarRegionsIntersectionsRequested;

    public REAModuleStateReporter(Messager reaMessager) {
        this.reaMessager = reaMessager;
        this.isOcTreeRequested = reaMessager.createInput(REAModuleAPI.RequestOctree, (Object)false);
        this.isOcTreeBoundingBoxRequested = reaMessager.createInput(REAModuleAPI.RequestBoundingBox, (Object)false);
        this.arePlanarRegionsRequested = reaMessager.createInput(REAModuleAPI.RequestPlanarRegions, (Object)false);
        this.isPlanarRegionSegmentationRequested = reaMessager.createInput(REAModuleAPI.RequestPlanarRegionSegmentation, (Object)false);
        this.arePlanarRegionsIntersectionsRequested = reaMessager.createInput(REAModuleAPI.RequestPlanarRegionsIntersections, (Object)false);
    }

    public void reportOcTreeState(NormalOcTree ocTree) {
        if (this.isOcTreeRequested.getAndSet(false).booleanValue()) {
            this.reaMessager.submitMessage(REAModuleAPI.OcTreeState, (Object)OcTreeMessageConverter.convertToMessage(ocTree));
        }
        if (this.isOcTreeBoundingBoxRequested.getAndSet(false).booleanValue()) {
            this.reaMessager.submitMessage(REAModuleAPI.OcTreeBoundingBoxState, (Object)BoundingBoxMessageConverter.convertToMessage(ocTree.getBoundingBox()));
        }
    }

    public void reportSensorPose(Pose3DReadOnly sensorPose) {
        this.reaMessager.submitMessage(REAModuleAPI.SensorPose, (Object)new Pose3D(sensorPose));
    }

    public void reportPlanarRegionsState(RegionFeaturesProvider regionFeaturesProvider) {
        PlanarRegionsList planarRegionsList = regionFeaturesProvider.getPlanarRegionsList();
        if (planarRegionsList != null && planarRegionsList.getNumberOfPlanarRegions() > 0 && this.arePlanarRegionsRequested.getAndSet(false).booleanValue()) {
            this.reaMessager.submitMessage(REAModuleAPI.PlanarRegionsState, (Object)PlanarRegionMessageConverter.convertToPlanarRegionsListMessage((PlanarRegionsList)planarRegionsList));
        }
        if (this.isPlanarRegionSegmentationRequested.getAndSet(false).booleanValue()) {
            this.reaMessager.submitMessage(REAModuleAPI.PlanarRegionsSegmentationState, (Object)REAPlanarRegionsConverter.createPlanarRegionSegmentationMessages(regionFeaturesProvider));
        }
        if (this.arePlanarRegionsIntersectionsRequested.getAndSet(false).booleanValue()) {
            this.reaMessager.submitMessage(REAModuleAPI.PlanarRegionsIntersectionState, (Object)REAPlanarRegionsConverter.createLineSegment3dMessages(regionFeaturesProvider));
        }
    }

    public void registerLidarScanMessage(LidarScanMessage message) {
        if (this.reaMessager.isMessagerOpen()) {
            this.reaMessager.submitMessage(REAModuleAPI.LidarScanState, (Object)new LidarScanMessage(message));
        }
    }

    public void registerStereoVisionPointCloudMessage(StereoVisionPointCloudMessage message) {
        if (this.reaMessager.isMessagerOpen()) {
            this.reaMessager.submitMessage(REAModuleAPI.StereoVisionPointCloudState, (Object)new StereoVisionPointCloudMessage(message));
        }
    }

    public void registerDepthCloudMessage(StereoVisionPointCloudMessage message) {
        if (this.reaMessager.isMessagerOpen()) {
            this.reaMessager.submitMessage(REAModuleAPI.DepthPointCloudState, (Object)new StereoVisionPointCloudMessage(message));
        }
    }
}

