/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotEnvironmentAwareness.updaters;

import geometry_msgs.Point;
import java.io.File;
import java.util.List;
import java.util.stream.Collectors;
import map_sense.RawGPUPlanarRegion;
import map_sense.RawGPUPlanarRegionList;
import us.ihmc.communication.PerceptionAPI;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.log.LogTools;
import us.ihmc.robotEnvironmentAwareness.communication.converters.ScanRegionFilter;
import us.ihmc.robotEnvironmentAwareness.geometry.ConcaveHullFactoryParameters;
import us.ihmc.robotEnvironmentAwareness.planarRegion.PlanarRegionPolygonizer;
import us.ihmc.robotEnvironmentAwareness.planarRegion.PlanarRegionSegmentationRawData;
import us.ihmc.robotEnvironmentAwareness.planarRegion.PolygonizerParameters;
import us.ihmc.robotEnvironmentAwareness.ui.io.PlanarRegionSegmentationDataExporter;
import us.ihmc.robotics.geometry.PlanarRegion;
import us.ihmc.robotics.geometry.PlanarRegionsList;
import us.ihmc.ros2.ROS2Callback;
import us.ihmc.ros2.ROS2NodeInterface;

public class GPUPlanarRegionUpdater {
    private static final boolean EXPORT_SEGMENTATION_ON_EXCEPTION = true;
    private ConcaveHullFactoryParameters concaveHullFactoryParameters;
    private PolygonizerParameters polygonizerParameters;
    private final PlanarRegionSegmentationDataExporter dataExporter = new PlanarRegionSegmentationDataExporter(new File("DataThrowingException/Segmentation"));

    public ConcaveHullFactoryParameters getConcaveHullFactoryParameters() {
        return this.concaveHullFactoryParameters;
    }

    public PolygonizerParameters getPolygonizerParameters() {
        return this.polygonizerParameters;
    }

    public GPUPlanarRegionUpdater() {
        this.concaveHullFactoryParameters = new ConcaveHullFactoryParameters();
        this.concaveHullFactoryParameters.setEdgeLengthThreshold(0.224);
        this.concaveHullFactoryParameters.setRemoveAllTrianglesWithTwoBorderEdges(false);
        this.concaveHullFactoryParameters.setAllowSplittingConcaveHull(false);
        this.concaveHullFactoryParameters.setMaxNumberOfIterations(5000);
        this.concaveHullFactoryParameters.setTriangulationTolerance(0.0);
        this.polygonizerParameters = new PolygonizerParameters();
    }

    public void attachROS2Tuner(ROS2NodeInterface ros2Node) {
        new ROS2Callback(ros2Node, PerceptionAPI.CONCAVE_HULL_FACTORY_PARAMETERS, parameters -> this.concaveHullFactoryParameters.setFromColonCommaString(parameters.getParameters().toString()));
        new ROS2Callback(ros2Node, PerceptionAPI.POLYGONIZER_PARAMETERS, parameters -> this.polygonizerParameters.setFromColonCommaString(parameters.getParameters().toString()));
    }

    public void logRawGPURegions(RawGPUPlanarRegionList rawGPUPlanarRegionList) {
        for (int i = 0; i < rawGPUPlanarRegionList.getNumOfRegions(); ++i) {
            RawGPUPlanarRegion rawRegion = (RawGPUPlanarRegion)rawGPUPlanarRegionList.getRegions().get(i);
            LogTools.info((String)"\tRegion: {}, Size:{}", (Object)rawRegion.getId(), (Object)rawRegion.getVertices().size());
            LogTools.info((String)"\tNormal: ({},{},{})", (Object)rawRegion.getNormal().getX(), (Object)rawRegion.getNormal().getY(), (Object)rawRegion.getNormal().getZ());
            LogTools.info((String)"\tCentroid: ({},{},{})", (Object)rawRegion.getNormal().getX(), (Object)rawRegion.getNormal().getY(), (Object)rawRegion.getNormal().getZ());
            for (int j = 0; j < rawRegion.getVertices().size(); ++j) {
                Point point = (Point)rawRegion.getVertices().get(j);
                System.out.println(point.getX() + "," + point.getY());
            }
        }
    }

    public void logSegmentationRawData(List<PlanarRegionSegmentationRawData> rawData) {
        LogTools.info((String)"Raw Data Regions: {}", (Object)rawData.size());
        for (int i = 0; i < rawData.size(); ++i) {
            PlanarRegionSegmentationRawData rawRegion = rawData.get(i);
            LogTools.info((String)"\tRegion: {}, Size:{}", (Object)rawRegion.getRegionId(), (Object)rawRegion.getPointCloudInWorld().size());
            LogTools.info((String)"\tOrigin: ({},{},{})", (Object)rawRegion.getOrigin().getX(), (Object)rawRegion.getOrigin().getY(), (Object)rawRegion.getOrigin().getZ());
        }
    }

    public void logFinalGPUPlanarRegions(PlanarRegionsList planarRegionsList) {
        LogTools.info((String)"Final GPU Regions: {}", (Object)planarRegionsList.getNumberOfPlanarRegions());
        for (PlanarRegion region : planarRegionsList.getPlanarRegionsAsList()) {
            LogTools.info((String)"\tFinal Region: ID:{} CONVEX:{} HULL:{}", (Object)region.getRegionId(), (Object)region.getNumberOfConvexPolygons(), (Object)region.getConcaveHullSize());
            Point3D origin = new Point3D();
            region.getOrigin((Point3DBasics)origin);
            LogTools.info((String)"\tRegion Origin: ({},{},{})", (Object)origin.getX(), (Object)origin.getY(), (Object)origin.getZ());
        }
    }

    public PlanarRegionsList generatePlanarRegions(RawGPUPlanarRegionList rawGPUPlanarRegionList) {
        List<PlanarRegionSegmentationRawData> rawData = this.getSegmentationRawDataAsList(rawGPUPlanarRegionList);
        PlanarRegionsList planarRegionsList = this.updatePolygons(rawData);
        return planarRegionsList;
    }

    private Point3D toPoint3D(Point point) {
        return new Point3D(point.getX(), point.getY(), point.getZ());
    }

    public void getSegmentationRawData(RawGPUPlanarRegionList rawGPUPlanarRegionList, List<PlanarRegionSegmentationRawData> rawDataToPack) {
        for (int i = 0; i < rawGPUPlanarRegionList.getNumOfRegions(); ++i) {
            RawGPUPlanarRegion region = (RawGPUPlanarRegion)rawGPUPlanarRegionList.getRegions().get(i);
            List pointCloud = region.getVertices().stream().map(this::toPoint3D).collect(Collectors.toList());
            rawDataToPack.add(new PlanarRegionSegmentationRawData(region.getId().shortValue(), (Vector3DReadOnly)new Vector3D(region.getNormal().getX(), region.getNormal().getY(), region.getNormal().getZ()), (Point3DReadOnly)new Point3D(region.getCentroid().getX(), region.getCentroid().getY(), region.getCentroid().getZ()), pointCloud));
        }
    }

    public List<PlanarRegionSegmentationRawData> getSegmentationRawDataAsList(RawGPUPlanarRegionList rawGPUPlanarRegionList) {
        return rawGPUPlanarRegionList.getRegions().parallelStream().map(this::convertToSegmentationRawData).collect(Collectors.toList());
    }

    public PlanarRegionSegmentationRawData convertToSegmentationRawData(RawGPUPlanarRegion rawGPUPlanarRegion) {
        List pointCloud = rawGPUPlanarRegion.getVertices().stream().map(this::toPoint3D).collect(Collectors.toList());
        PlanarRegionSegmentationRawData rawData = new PlanarRegionSegmentationRawData(rawGPUPlanarRegion.getId().shortValue(), (Vector3DReadOnly)new Vector3D(rawGPUPlanarRegion.getNormal().getX(), rawGPUPlanarRegion.getNormal().getY(), rawGPUPlanarRegion.getNormal().getZ()), (Point3DReadOnly)new Point3D(rawGPUPlanarRegion.getCentroid().getX(), rawGPUPlanarRegion.getCentroid().getY(), rawGPUPlanarRegion.getCentroid().getZ()), pointCloud);
        return rawData;
    }

    private PlanarRegionsList updatePolygons(List<PlanarRegionSegmentationRawData> rawData) {
        return PlanarRegionPolygonizer.createPlanarRegionsList(rawData, this.concaveHullFactoryParameters, this.polygonizerParameters, this.dataExporter);
    }

    public PlanarRegionsList filterCollidingPlanarRegions(PlanarRegionsList regions, ScanRegionFilter filter) {
        int i = 0;
        while (i < regions.getNumberOfPlanarRegions()) {
            if (!filter.test(i, regions.getPlanarRegion(i))) {
                regions.pollPlanarRegion(i);
                continue;
            }
            ++i;
        }
        return regions;
    }
}

