/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotEnvironmentAwareness.ui.io;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.prefs.Preferences;
import javafx.stage.DirectoryChooser;
import javafx.stage.Window;
import us.ihmc.robotics.PlanarRegionFileTools;
import us.ihmc.robotics.geometry.PlanarRegionsList;

public class PlanarRegionDataImporter {
    public static PlanarRegionsList importUsingFileChooser(Window ownerWindow) {
        File dataFolder = PlanarRegionDataImporter.chooseFile(ownerWindow);
        if (dataFolder == null) {
            return null;
        }
        return PlanarRegionFileTools.importPlanarRegionData((File)dataFolder);
    }

    public static File chooseFile(Window ownerWindow) {
        DirectoryChooser directoryChooser = new DirectoryChooser();
        File initialDirectory = PlanarRegionDataImporter.getDefaultFilePath();
        if (initialDirectory == null) {
            initialDirectory = new File("../../Data/PlanarRegion");
        }
        if (initialDirectory == null || !initialDirectory.exists() || !initialDirectory.isDirectory()) {
            initialDirectory = new File(".");
        }
        directoryChooser.setInitialDirectory(initialDirectory);
        File result = directoryChooser.showDialog(ownerWindow);
        if (result == null) {
            return null;
        }
        PlanarRegionDataImporter.setDefaultFilePath(result);
        return result;
    }

    public static PlanarRegionsList importPlanarRegionData(File dataFolder) {
        return PlanarRegionFileTools.importPlanarRegionData((File)dataFolder);
    }

    private static File getDefaultFilePath() {
        Preferences prefs = Preferences.userNodeForPackage(PlanarRegionsList.class);
        String filePath = prefs.get("filePath", null);
        if (filePath != null && Files.isDirectory(Paths.get(filePath, new String[0]), new LinkOption[0])) {
            return new File(filePath);
        }
        return null;
    }

    private static void setDefaultFilePath(File file) {
        Preferences prefs = Preferences.userNodeForPackage(PlanarRegionsList.class);
        if (file != null) {
            if (!file.isDirectory()) {
                file = file.getParentFile();
            }
            prefs.put("filePath", file.getAbsolutePath());
        }
    }
}

