/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotEnvironmentAwareness.ui.controller;

import javafx.beans.property.Property;
import javafx.fxml.FXML;
import javafx.scene.control.Spinner;
import javafx.scene.control.SpinnerValueFactory;
import javafx.scene.control.ToggleButton;
import us.ihmc.messager.MessagerAPIFactory;
import us.ihmc.robotEnvironmentAwareness.communication.SegmentationModuleAPI;
import us.ihmc.robotEnvironmentAwareness.communication.packets.BoundingBoxParametersMessage;
import us.ihmc.robotEnvironmentAwareness.ui.controller.REABasicUIController;
import us.ihmc.robotEnvironmentAwareness.ui.properties.BoundingBoxParametersProperty;

public class BoundingBoxAnchorPaneController
extends REABasicUIController {
    @FXML
    private ToggleButton enableBoundingBoxButton;
    @FXML
    private ToggleButton showBoundingBoxButton;
    @FXML
    private Spinner<Double> boundingBoxMinXSpinner;
    @FXML
    private Spinner<Double> boundingBoxMaxXSpinner;
    @FXML
    private Spinner<Double> boundingBoxMinYSpinner;
    @FXML
    private Spinner<Double> boundingBoxMaxYSpinner;
    @FXML
    private Spinner<Double> boundingBoxMinZSpinner;
    @FXML
    private Spinner<Double> boundingBoxMaxZSpinner;
    private final BoundingBoxParametersProperty boundingBoxParametersProperty = new BoundingBoxParametersProperty(this, "boundingBoxParameters");
    private MessagerAPIFactory.Topic<Boolean> boundingBoxEnableTopic = SegmentationModuleAPI.OcTreeBoundingBoxEnable;
    private MessagerAPIFactory.Topic<Boolean> boundingBoxShowTopic = SegmentationModuleAPI.UIOcTreeBoundingBoxShow;
    private MessagerAPIFactory.Topic<Boolean> saveParameterConfigurationTopic = SegmentationModuleAPI.SaveUpdaterConfiguration;
    private MessagerAPIFactory.Topic<BoundingBoxParametersMessage> boundingBoxParametersTopic = SegmentationModuleAPI.OcTreeBoundingBoxParameters;

    private void setupControls() {
        this.boundingBoxMinXSpinner.setValueFactory((SpinnerValueFactory)this.createBoundingBoxValueFactory(0.0));
        this.boundingBoxMaxXSpinner.setValueFactory((SpinnerValueFactory)this.createBoundingBoxValueFactory(5.0));
        this.boundingBoxMinYSpinner.setValueFactory((SpinnerValueFactory)this.createBoundingBoxValueFactory(-2.0));
        this.boundingBoxMaxYSpinner.setValueFactory((SpinnerValueFactory)this.createBoundingBoxValueFactory(2.0));
        this.boundingBoxMinZSpinner.setValueFactory((SpinnerValueFactory)this.createBoundingBoxValueFactory(-1.0));
        this.boundingBoxMaxZSpinner.setValueFactory((SpinnerValueFactory)this.createBoundingBoxValueFactory(1.0));
    }

    public void setBoundingBoxEnableTopic(MessagerAPIFactory.Topic<Boolean> boundingBoxEnableTopic) {
        this.boundingBoxEnableTopic = boundingBoxEnableTopic;
    }

    public void setBoundingBoxShowTopic(MessagerAPIFactory.Topic<Boolean> boundingBoxShowTopic) {
        this.boundingBoxShowTopic = boundingBoxShowTopic;
    }

    public void setSaveParameterConfigurationTopic(MessagerAPIFactory.Topic<Boolean> saveParameterConfigurationTopic) {
        this.saveParameterConfigurationTopic = saveParameterConfigurationTopic;
    }

    public void setBoundingBoxParametersTopic(MessagerAPIFactory.Topic<BoundingBoxParametersMessage> boundingBoxParametersTopic) {
        this.boundingBoxParametersTopic = boundingBoxParametersTopic;
    }

    @Override
    public void bindControls() {
        this.setupControls();
        this.uiMessager.bindBidirectionalGlobal(this.boundingBoxEnableTopic, this.enableBoundingBoxButton.selectedProperty());
        this.boundingBoxParametersProperty.binBidirectionalMinX((Property<? extends Number>)this.boundingBoxMinXSpinner.getValueFactory().valueProperty());
        this.boundingBoxParametersProperty.binBidirectionalMinY((Property<? extends Number>)this.boundingBoxMinYSpinner.getValueFactory().valueProperty());
        this.boundingBoxParametersProperty.binBidirectionalMinZ((Property<? extends Number>)this.boundingBoxMinZSpinner.getValueFactory().valueProperty());
        this.boundingBoxParametersProperty.binBidirectionalMaxX((Property<? extends Number>)this.boundingBoxMaxXSpinner.getValueFactory().valueProperty());
        this.boundingBoxParametersProperty.binBidirectionalMaxY((Property<? extends Number>)this.boundingBoxMaxYSpinner.getValueFactory().valueProperty());
        this.boundingBoxParametersProperty.binBidirectionalMaxZ((Property<? extends Number>)this.boundingBoxMaxZSpinner.getValueFactory().valueProperty());
        this.uiMessager.bindBidirectionalGlobal(this.boundingBoxParametersTopic, this.boundingBoxParametersProperty);
        this.load();
        this.uiMessager.bindBidirectionalInternal(this.boundingBoxShowTopic, this.showBoundingBoxButton.selectedProperty(), true);
    }

    @FXML
    public void save() {
        this.uiMessager.submitStateRequestToModule(this.saveParameterConfigurationTopic);
        this.saveUIControlProperty(this.boundingBoxShowTopic, this.showBoundingBoxButton);
    }

    public void load() {
        this.loadUIControlProperty(this.boundingBoxShowTopic, this.showBoundingBoxButton);
    }

    private SpinnerValueFactory.DoubleSpinnerValueFactory createBoundingBoxValueFactory(double initialValue) {
        double min = -100.0;
        double max = 100.0;
        double amountToStepBy = 0.1;
        return new SpinnerValueFactory.DoubleSpinnerValueFactory(min, max, initialValue, amountToStepBy);
    }
}

