/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotEnvironmentAwareness.ui;

import controller_msgs.msg.dds.StereoVisionPointCloudMessage;
import ihmc_common_msgs.msg.dds.StampedPosePacket;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.function.Function;
import javafx.application.Platform;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.layout.BorderPane;
import javafx.scene.paint.Color;
import javafx.stage.Stage;
import javafx.stage.Window;
import std_msgs.msg.dds.Empty;
import us.ihmc.commons.thread.ThreadTools;
import us.ihmc.communication.ROS2Tools;
import us.ihmc.euclid.geometry.ConvexPolygon2D;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.javaFXToolkit.scenes.View3DFactory;
import us.ihmc.log.LogTools;
import us.ihmc.messager.Messager;
import us.ihmc.pubsub.DomainFactory;
import us.ihmc.robotEnvironmentAwareness.communication.REAUIMessager;
import us.ihmc.robotEnvironmentAwareness.communication.SLAMModuleAPI;
import us.ihmc.robotEnvironmentAwareness.perceptionSuite.PerceptionUI;
import us.ihmc.robotEnvironmentAwareness.slam.viewer.FootstepMeshViewer;
import us.ihmc.robotEnvironmentAwareness.slam.viewer.SLAMMeshViewer;
import us.ihmc.robotEnvironmentAwareness.ui.UIConnectionHandler;
import us.ihmc.robotEnvironmentAwareness.ui.controller.BoundingBoxAnchorPaneController;
import us.ihmc.robotEnvironmentAwareness.ui.controller.FrameNormalEstimationAnchorPaneController;
import us.ihmc.robotEnvironmentAwareness.ui.controller.NormalEstimationAnchorPaneController;
import us.ihmc.robotEnvironmentAwareness.ui.controller.SLAMAnchorPaneController;
import us.ihmc.robotEnvironmentAwareness.ui.controller.SLAMDataManagerAnchorPaneController;
import us.ihmc.robotEnvironmentAwareness.ui.controller.SurfaceElementICPPaneController;
import us.ihmc.robotEnvironmentAwareness.ui.io.StereoVisionPointCloudDataExporter;
import us.ihmc.robotEnvironmentAwareness.ui.viewer.SensorFrameViewer;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.robotics.robotSide.SideDependentList;
import us.ihmc.ros2.ROS2Callback;
import us.ihmc.ros2.ROS2Node;
import us.ihmc.ros2.ROS2NodeInterface;
import us.ihmc.ros2.ROS2PublisherBasics;

public class SLAMBasedEnvironmentAwarenessUI
implements PerceptionUI {
    private static final String UI_CONFIGURATION_FILE_NAME = "./Configurations/defaultSLAMUIConfiguration.txt";
    private final BorderPane mainPane;
    private final SLAMMeshViewer ihmcSLAMViewer;
    private final REAUIMessager uiMessager;
    private final SensorFrameViewer<StereoVisionPointCloudMessage> depthFrameViewer;
    private final SensorFrameViewer<StampedPosePacket> pelvisFrameViewer;
    private final FootstepMeshViewer footstepViewer;
    private boolean shuttingDown = false;
    private boolean closedExternally = false;
    @FXML
    private SLAMAnchorPaneController slamAnchorPaneController;
    @FXML
    private SurfaceElementICPPaneController surfaceElementICPPaneController;
    @FXML
    private SLAMDataManagerAnchorPaneController slamDataManagerAnchorPaneController;
    @FXML
    private BoundingBoxAnchorPaneController boundingBoxAnchorPaneController;
    @FXML
    private NormalEstimationAnchorPaneController normalEstimationAnchorPaneController;
    @FXML
    private FrameNormalEstimationAnchorPaneController frameNormalEstimationAnchorPaneController;
    private final Stage primaryStage;
    private final UIConnectionHandler uiConnectionHandler;
    private final StereoVisionPointCloudDataExporter stereoVisionPointCloudDataExporter;
    private final ROS2Node ros2Node;

    public SLAMBasedEnvironmentAwarenessUI(REAUIMessager uiMessager, Stage primaryStage, SideDependentList<List<Point2D>> defaultContactPoints) throws Exception {
        this(uiMessager, primaryStage, defaultContactPoints, true);
    }

    public SLAMBasedEnvironmentAwarenessUI(REAUIMessager uiMessager, Stage primaryStage, final SideDependentList<List<Point2D>> defaultContactPoints, boolean startMessager) throws Exception {
        this.primaryStage = primaryStage;
        FXMLLoader loader = new FXMLLoader();
        loader.setController((Object)this);
        loader.setLocation(this.getClass().getResource(this.getClass().getSimpleName() + ".fxml"));
        this.mainPane = (BorderPane)loader.load();
        View3DFactory view3dFactory = View3DFactory.createSubscene();
        view3dFactory.addCameraController(true);
        view3dFactory.addWorldCoordinateSystem(0.3);
        view3dFactory.setBackgroundColor(Color.WHITE);
        this.mainPane.setCenter((Node)view3dFactory.getSubSceneWrappedInsidePane());
        this.uiMessager = uiMessager;
        if (startMessager) {
            uiMessager.startMessager();
        }
        this.ihmcSLAMViewer = new SLAMMeshViewer(uiMessager);
        this.depthFrameViewer = new SensorFrameViewer<StereoVisionPointCloudMessage>(uiMessager, SLAMModuleAPI.DepthPointCloudState, SLAMModuleAPI.UISensorPoseHistoryFrames, SensorFrameViewer.createStereoVisionSensorFrameExtractor(), SLAMModuleAPI.SensorPoseHistoryClear);
        view3dFactory.addNodeToView(this.ihmcSLAMViewer.getRoot());
        view3dFactory.addNodeToView(this.depthFrameViewer.getRoot());
        this.stereoVisionPointCloudDataExporter = new StereoVisionPointCloudDataExporter(uiMessager, SLAMModuleAPI.DepthPointCloudState, SLAMModuleAPI.UIRawDataExportDirectory, SLAMModuleAPI.UIRawDataExportRequest);
        if (defaultContactPoints == null) {
            this.pelvisFrameViewer = null;
            this.footstepViewer = null;
        } else {
            this.pelvisFrameViewer = new SensorFrameViewer<StampedPosePacket>(uiMessager, SLAMModuleAPI.CustomizedFrameState, SLAMModuleAPI.UISensorPoseHistoryFrames, SensorFrameViewer.createStampedPosePacketSensorFrameExtractor(), SLAMModuleAPI.SensorPoseHistoryClear);
            Function<RobotSide, ConvexPolygon2D> contactPointsProvider = new Function<RobotSide, ConvexPolygon2D>(){

                @Override
                public ConvexPolygon2D apply(RobotSide robotSide) {
                    ConvexPolygon2D defaultFoothold = new ConvexPolygon2D();
                    for (int i = 0; i < ((List)defaultContactPoints.get((Enum)robotSide)).size(); ++i) {
                        defaultFoothold.addVertex((Point2DReadOnly)((List)defaultContactPoints.get((Enum)robotSide)).get(i));
                    }
                    defaultFoothold.update();
                    return defaultFoothold;
                }
            };
            this.footstepViewer = new FootstepMeshViewer(uiMessager, contactPointsProvider);
            view3dFactory.addNodeToView(this.pelvisFrameViewer.getRoot());
            view3dFactory.addNodeToView(this.footstepViewer.getRoot());
        }
        this.initializeControllers(uiMessager);
        this.uiConnectionHandler = new UIConnectionHandler((Window)primaryStage, uiMessager, SLAMModuleAPI.RequestEntireModuleState);
        this.uiConnectionHandler.start();
        uiMessager.notifyModuleMessagerStateListeners();
        primaryStage.setTitle(this.getClass().getSimpleName());
        primaryStage.setMaximized(true);
        Scene mainScene = new Scene((Parent)this.mainPane, 600.0, 400.0);
        primaryStage.setScene(mainScene);
        this.ros2Node = ROS2Tools.createROS2Node((DomainFactory.PubSubImplementation)DomainFactory.PubSubImplementation.FAST_RTPS, (String)"slam_ui");
        ROS2PublisherBasics shutdownPublisher = this.ros2Node.createPublisher(SLAMModuleAPI.SHUTDOWN);
        new ROS2Callback((ROS2NodeInterface)this.ros2Node, SLAMModuleAPI.SHUTDOWN, message -> {
            if (!this.shuttingDown) {
                LogTools.info((String)"Received SHUTDOWN. Shutting down...");
                this.closeAndStop();
            } else {
                LogTools.info((String)"Received SHUTDOWN. Already shutting down...");
            }
        });
        primaryStage.setOnCloseRequest(event -> {
            this.shuttingDown = true;
            if (!this.closedExternally) {
                ThreadTools.startAThread(() -> {
                    shutdownPublisher.publish((Object)new Empty());
                    this.stop();
                }, (String)"SLAMModuleUIShutdown");
            }
        });
    }

    private void refreshModuleState() {
        this.uiMessager.submitStateRequestToModule(SLAMModuleAPI.RequestEntireModuleState);
    }

    private void initializeControllers(REAUIMessager uiMessager) {
        File configurationFile = new File(UI_CONFIGURATION_FILE_NAME);
        try {
            configurationFile.getParentFile().mkdirs();
            configurationFile.createNewFile();
        }
        catch (IOException e) {
            System.out.println(configurationFile.getAbsolutePath());
            e.printStackTrace();
        }
        this.slamAnchorPaneController.attachREAMessager(uiMessager);
        this.slamAnchorPaneController.bindControls();
        this.slamDataManagerAnchorPaneController.attachREAMessager(uiMessager);
        this.slamDataManagerAnchorPaneController.setMainWindow((Window)this.primaryStage);
        this.slamDataManagerAnchorPaneController.setConfigurationFile(configurationFile);
        this.slamDataManagerAnchorPaneController.bindControls();
        this.surfaceElementICPPaneController.attachREAMessager(uiMessager);
        this.surfaceElementICPPaneController.bindControls();
        this.boundingBoxAnchorPaneController.setBoundingBoxEnableTopic(SLAMModuleAPI.OcTreeBoundingBoxEnable);
        this.boundingBoxAnchorPaneController.setBoundingBoxShowTopic(SLAMModuleAPI.UIOcTreeBoundingBoxShow);
        this.boundingBoxAnchorPaneController.setSaveParameterConfigurationTopic(SLAMModuleAPI.SaveConfiguration);
        this.boundingBoxAnchorPaneController.setBoundingBoxParametersTopic(SLAMModuleAPI.OcTreeBoundingBoxParameters);
        this.boundingBoxAnchorPaneController.setConfigurationFile(configurationFile);
        this.boundingBoxAnchorPaneController.attachREAMessager(uiMessager);
        this.boundingBoxAnchorPaneController.bindControls();
        this.normalEstimationAnchorPaneController.setNormalEstimationEnableTopic(SLAMModuleAPI.NormalEstimationEnable);
        this.normalEstimationAnchorPaneController.setNormalEstimationClearTopic(SLAMModuleAPI.NormalEstimationClear);
        this.normalEstimationAnchorPaneController.setSaveMainUpdaterConfigurationTopic(SLAMModuleAPI.SaveConfiguration);
        this.normalEstimationAnchorPaneController.setNormalEstimationParametersTopic(SLAMModuleAPI.NormalEstimationParameters);
        this.normalEstimationAnchorPaneController.setConfigurationFile(configurationFile);
        this.normalEstimationAnchorPaneController.attachREAMessager(uiMessager);
        this.normalEstimationAnchorPaneController.bindControls();
        this.frameNormalEstimationAnchorPaneController.setConfigurationFile(configurationFile);
        this.frameNormalEstimationAnchorPaneController.attachREAMessager(uiMessager);
        this.frameNormalEstimationAnchorPaneController.bindControls();
    }

    @Override
    public void show() {
        this.refreshModuleState();
        this.primaryStage.show();
    }

    public void closeAndStop() {
        this.closedExternally = true;
        Platform.runLater(() -> {
            this.uiConnectionHandler.stop();
            this.primaryStage.close();
        });
        this.stop();
    }

    @Override
    public void stop() {
        try {
            this.uiConnectionHandler.stop();
            this.uiMessager.closeMessager();
            this.ihmcSLAMViewer.stop();
            this.depthFrameViewer.stop();
            if (this.pelvisFrameViewer != null) {
                this.pelvisFrameViewer.stop();
            }
            if (this.footstepViewer != null) {
                this.footstepViewer.stop();
            }
            this.slamDataManagerAnchorPaneController.destroy();
            this.stereoVisionPointCloudDataExporter.shutdown();
            this.ros2Node.destroy();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static SLAMBasedEnvironmentAwarenessUI creatIntraprocessUI(Messager messager, Stage primaryStage) throws Exception {
        REAUIMessager uiMessager = new REAUIMessager(messager);
        return new SLAMBasedEnvironmentAwarenessUI(uiMessager, primaryStage, null);
    }

    public static SLAMBasedEnvironmentAwarenessUI creatIntraprocessUI(Messager messager, Stage primaryStage, SideDependentList<List<Point2D>> defaultContactPoints) throws Exception {
        REAUIMessager uiMessager = new REAUIMessager(messager);
        return new SLAMBasedEnvironmentAwarenessUI(uiMessager, primaryStage, defaultContactPoints);
    }
}

