/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotEnvironmentAwareness.ui;

import java.io.File;
import java.io.IOException;
import javafx.application.Platform;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.input.KeyCode;
import javafx.scene.layout.BorderPane;
import javafx.stage.Stage;
import javafx.stage.Window;
import std_msgs.msg.dds.Empty;
import us.ihmc.commons.thread.ThreadTools;
import us.ihmc.communication.ROS2Tools;
import us.ihmc.javaFXToolkit.scenes.View3DFactory;
import us.ihmc.log.LogTools;
import us.ihmc.messager.Messager;
import us.ihmc.pubsub.DomainFactory;
import us.ihmc.robotEnvironmentAwareness.communication.REAUIMessager;
import us.ihmc.robotEnvironmentAwareness.communication.SLAMModuleAPI;
import us.ihmc.robotEnvironmentAwareness.communication.SegmentationModuleAPI;
import us.ihmc.robotEnvironmentAwareness.perceptionSuite.PerceptionUI;
import us.ihmc.robotEnvironmentAwareness.ui.UIConnectionHandler;
import us.ihmc.robotEnvironmentAwareness.ui.controller.BoundingBoxAnchorPaneController;
import us.ihmc.robotEnvironmentAwareness.ui.controller.CustomRegionMergeAnchorPaneController;
import us.ihmc.robotEnvironmentAwareness.ui.controller.OcTreeEssentialsAnchorPaneController;
import us.ihmc.robotEnvironmentAwareness.ui.controller.PolygonizerAnchorPaneController;
import us.ihmc.robotEnvironmentAwareness.ui.controller.RegionSegmentationAnchorPaneController;
import us.ihmc.robotEnvironmentAwareness.ui.controller.SegmentationDataExporterAnchorPaneController;
import us.ihmc.robotEnvironmentAwareness.ui.io.PlanarRegionDataExporter;
import us.ihmc.robotEnvironmentAwareness.ui.io.PlanarRegionSegmentationDataExporter;
import us.ihmc.robotEnvironmentAwareness.ui.viewer.SegmentationMeshViewer;
import us.ihmc.ros2.ROS2Callback;
import us.ihmc.ros2.ROS2Node;
import us.ihmc.ros2.ROS2NodeInterface;
import us.ihmc.ros2.ROS2PublisherBasics;

public class PlanarSegmentationUI
implements PerceptionUI {
    private static final String UI_CONFIGURATION_FILE_NAME = "./Configurations/defaultPlanarSegmentationUIConfiguration.txt";
    private final BorderPane mainPane;
    private final REAUIMessager uiMessager;
    private final SegmentationMeshViewer meshViewer;
    private boolean shuttingDown = false;
    private boolean closedExternally = false;
    @FXML
    private OcTreeEssentialsAnchorPaneController ocTreeEssentialsAnchorPaneController;
    @FXML
    private RegionSegmentationAnchorPaneController regionSegmentationAnchorPaneController;
    @FXML
    private BoundingBoxAnchorPaneController boundingBoxAnchorPaneController;
    @FXML
    private CustomRegionMergeAnchorPaneController customRegionMergeAnchorPaneController;
    @FXML
    private PolygonizerAnchorPaneController polygonizerAnchorPaneController;
    @FXML
    private SegmentationDataExporterAnchorPaneController segmentationDataExporterAnchorPaneController;
    private final Stage primaryStage;
    private final UIConnectionHandler uiConnectionHandler;
    private final ROS2Node ros2Node;

    private PlanarSegmentationUI(REAUIMessager uiMessager, Stage primaryStage) throws Exception {
        this.primaryStage = primaryStage;
        FXMLLoader loader = new FXMLLoader();
        loader.setController((Object)this);
        loader.setLocation(this.getClass().getResource(this.getClass().getSimpleName() + ".fxml"));
        this.mainPane = (BorderPane)loader.load();
        this.uiMessager = uiMessager;
        if (!uiMessager.isInternalMessagerOpen()) {
            uiMessager.startMessager();
        }
        this.meshViewer = new SegmentationMeshViewer(uiMessager);
        new PlanarRegionSegmentationDataExporter(uiMessager, SegmentationModuleAPI.PlanarRegionsSegmentationState, SegmentationModuleAPI.UISegmentationDataExporterDirectory, SegmentationModuleAPI.UISegmentationDataExportRequest);
        new PlanarRegionDataExporter(uiMessager, SegmentationModuleAPI.PlanarRegionsState, SegmentationModuleAPI.UIPlanarRegionDataExporterDirectory, SegmentationModuleAPI.UIPlanarRegionDataExportRequest);
        this.initializeControllers(uiMessager);
        View3DFactory view3dFactory = View3DFactory.createSubscene();
        view3dFactory.addCameraController(true);
        view3dFactory.addWorldCoordinateSystem(0.3);
        this.mainPane.setCenter((Node)view3dFactory.getSubSceneWrappedInsidePane());
        view3dFactory.addNodeToView(this.meshViewer.getRoot());
        this.uiConnectionHandler = new UIConnectionHandler((Window)primaryStage, uiMessager, SegmentationModuleAPI.RequestEntireModuleState);
        this.uiConnectionHandler.start();
        uiMessager.notifyModuleMessagerStateListeners();
        primaryStage.setTitle(this.getClass().getSimpleName());
        primaryStage.setMaximized(true);
        Scene mainScene = new Scene((Parent)this.mainPane, 600.0, 400.0);
        mainScene.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.F5) {
                this.refreshModuleState();
            }
        });
        primaryStage.setScene(mainScene);
        this.ros2Node = ROS2Tools.createROS2Node((DomainFactory.PubSubImplementation)DomainFactory.PubSubImplementation.FAST_RTPS, (String)"planar_segmentation_ui");
        ROS2PublisherBasics shutdownPublisher = this.ros2Node.createPublisher(SLAMModuleAPI.SHUTDOWN);
        new ROS2Callback((ROS2NodeInterface)this.ros2Node, SLAMModuleAPI.SHUTDOWN, message -> {
            if (!this.shuttingDown) {
                LogTools.info((String)"Received SHUTDOWN. Shutting down...");
                this.closeAndStop();
            } else {
                LogTools.info((String)"Received SHUTDOWN. Already shutting down...");
            }
        });
        primaryStage.setOnCloseRequest(event -> {
            this.shuttingDown = true;
            if (!this.closedExternally) {
                ThreadTools.startAThread(() -> {
                    shutdownPublisher.publish((Object)new Empty());
                    this.stop();
                }, (String)"PlanarSegmentationShutdown");
            }
        });
    }

    private void refreshModuleState() {
        this.uiMessager.submitMessageInternal(SegmentationModuleAPI.RequestEntireModuleState, true);
    }

    private void initializeControllers(REAUIMessager uiMessager) {
        File configurationFile = new File(UI_CONFIGURATION_FILE_NAME);
        try {
            configurationFile.getParentFile().mkdirs();
            configurationFile.createNewFile();
        }
        catch (IOException e) {
            System.out.println(configurationFile.getAbsolutePath());
            e.printStackTrace();
        }
        this.segmentationDataExporterAnchorPaneController.setUiPlanarRegionDataExporterDirectoryTopic(SegmentationModuleAPI.UIPlanarRegionDataExporterDirectory);
        this.segmentationDataExporterAnchorPaneController.setUiSegmentationDataExporterDirectoryTopic(SegmentationModuleAPI.UISegmentationDataExporterDirectory);
        this.segmentationDataExporterAnchorPaneController.setUiSegmentationDataExportRequestTopic(SegmentationModuleAPI.UISegmentationDataExportRequest);
        this.segmentationDataExporterAnchorPaneController.setUiPlanarRegionDataExportRequestTopic(SegmentationModuleAPI.UIPlanarRegionDataExportRequest);
        this.segmentationDataExporterAnchorPaneController.setConfigurationFile(configurationFile);
        this.segmentationDataExporterAnchorPaneController.setMainWindow((Window)this.primaryStage);
        this.segmentationDataExporterAnchorPaneController.attachREAMessager(uiMessager);
        this.segmentationDataExporterAnchorPaneController.bindControls();
        this.ocTreeEssentialsAnchorPaneController.setConfigurationFile(configurationFile);
        this.ocTreeEssentialsAnchorPaneController.attachREAMessager(uiMessager);
        this.ocTreeEssentialsAnchorPaneController.bindControls();
        this.boundingBoxAnchorPaneController.setConfigurationFile(configurationFile);
        this.boundingBoxAnchorPaneController.attachREAMessager(uiMessager);
        this.boundingBoxAnchorPaneController.bindControls();
        this.regionSegmentationAnchorPaneController.setPlanarRegionsSegmentationEnableTopic(SegmentationModuleAPI.PlanarRegionsSegmentationEnable);
        this.regionSegmentationAnchorPaneController.setPlanarRegionsSegmentationClearTopic(SegmentationModuleAPI.PlanarRegionsSegmentationClear);
        this.regionSegmentationAnchorPaneController.setSaveRegionUpdaterConfigurationTopic(SegmentationModuleAPI.SaveUpdaterConfiguration);
        this.regionSegmentationAnchorPaneController.setPlanarRegionsSegmentationParametersTopic(SegmentationModuleAPI.PlanarRegionsSegmentationParameters);
        this.regionSegmentationAnchorPaneController.setConfigurationFile(configurationFile);
        this.regionSegmentationAnchorPaneController.attachREAMessager(uiMessager);
        this.regionSegmentationAnchorPaneController.bindControls();
        this.customRegionMergeAnchorPaneController.setCustomRegionsMergingEnableTopic(SegmentationModuleAPI.CustomRegionsMergingEnable);
        this.customRegionMergeAnchorPaneController.setCustomRegionsClearTopic(SegmentationModuleAPI.CustomRegionsClear);
        this.customRegionMergeAnchorPaneController.setSaveRegionUpdaterConfigurationTopic(SegmentationModuleAPI.SaveUpdaterConfiguration);
        this.customRegionMergeAnchorPaneController.setCustomRegionsMergingParametersTopic(SegmentationModuleAPI.CustomRegionsMergingParameters);
        this.customRegionMergeAnchorPaneController.setConfigurationFile(configurationFile);
        this.customRegionMergeAnchorPaneController.attachREAMessager(uiMessager);
        this.customRegionMergeAnchorPaneController.bindControls();
        this.polygonizerAnchorPaneController.setPlanarRegionsPolygonizerEnableTopic(SegmentationModuleAPI.PlanarRegionsPolygonizerEnable);
        this.polygonizerAnchorPaneController.setPlanarRegionsPolygonizerClearTopic(SegmentationModuleAPI.PlanarRegionsPolygonizerClear);
        this.polygonizerAnchorPaneController.setPlanarRegionsIntersectionEnableTopic(SegmentationModuleAPI.PlanarRegionsIntersectionEnable);
        this.polygonizerAnchorPaneController.setUiPlanarRegionHideNodesTopic(SegmentationModuleAPI.UIPlanarRegionHideNodes);
        this.polygonizerAnchorPaneController.setSaveRegionUpdaterConfigurationTopic(SegmentationModuleAPI.SaveUpdaterConfiguration);
        this.polygonizerAnchorPaneController.setPlanarRegionsConcaveHullParametersTopic(SegmentationModuleAPI.PlanarRegionsConcaveHullParameters);
        this.polygonizerAnchorPaneController.setPlanarRegionsPolygonizerParametersTopic(SegmentationModuleAPI.PlanarRegionsPolygonizerParameters);
        this.polygonizerAnchorPaneController.setPlanarRegionsIntersectionParametersTopic(SegmentationModuleAPI.PlanarRegionsIntersectionParameters);
        this.polygonizerAnchorPaneController.setConfigurationFile(configurationFile);
        this.polygonizerAnchorPaneController.attachREAMessager(uiMessager);
        this.polygonizerAnchorPaneController.bindControls();
    }

    @Override
    public void show() {
        this.refreshModuleState();
        this.primaryStage.show();
    }

    public void hide() {
        this.primaryStage.hide();
    }

    public void closeAndStop() {
        this.closedExternally = true;
        Platform.runLater(() -> {
            this.uiConnectionHandler.stop();
            this.primaryStage.close();
        });
        this.stop();
    }

    @Override
    public void stop() {
        try {
            this.uiConnectionHandler.stop();
            this.uiMessager.closeMessager();
            this.meshViewer.stop();
            this.ros2Node.destroy();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static PlanarSegmentationUI createIntraprocessUI(Messager messager, Stage primaryStage) throws Exception {
        REAUIMessager uiMessager = new REAUIMessager(messager);
        uiMessager.startMessager();
        return new PlanarSegmentationUI(uiMessager, primaryStage);
    }
}

