/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotEnvironmentAwareness.ui;

import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.layout.BorderPane;
import javafx.stage.Stage;
import javafx.stage.Window;
import us.ihmc.javaFXToolkit.scenes.View3DFactory;
import us.ihmc.messager.Messager;
import us.ihmc.robotEnvironmentAwareness.communication.GPUPerceptionModuleAPI;
import us.ihmc.robotEnvironmentAwareness.communication.REAUIMessager;
import us.ihmc.robotEnvironmentAwareness.perceptionSuite.PerceptionUI;
import us.ihmc.robotEnvironmentAwareness.ui.UIConnectionHandler;
import us.ihmc.robotEnvironmentAwareness.ui.viewer.PlanarRegionViewer;

public class GPUBasedEnvironmentAwarenessUI
implements PerceptionUI {
    private final BorderPane mainPane;
    private final Stage primaryStage;
    private final REAUIMessager uiMessager;
    private final UIConnectionHandler uiConnectionHandler;
    private final PlanarRegionViewer planarRegionViewer;

    public GPUBasedEnvironmentAwarenessUI(Messager messager, Stage primaryStage) throws Exception {
        this.uiMessager = new REAUIMessager(messager);
        this.uiMessager.startMessager();
        this.primaryStage = primaryStage;
        FXMLLoader loader = new FXMLLoader();
        loader.setController((Object)this);
        loader.setLocation(this.getClass().getResource(this.getClass().getSimpleName() + ".fxml"));
        this.mainPane = (BorderPane)loader.load();
        if (!this.uiMessager.isInternalMessagerOpen()) {
            this.uiMessager.startMessager();
        }
        this.planarRegionViewer = new PlanarRegionViewer(messager, GPUPerceptionModuleAPI.PlanarRegionData, GPUPerceptionModuleAPI.ShowPlanarRegions);
        this.planarRegionViewer.start();
        View3DFactory view3dFactory = View3DFactory.createSubscene();
        view3dFactory.addCameraController(true);
        view3dFactory.addWorldCoordinateSystem(0.3);
        view3dFactory.addNodeToView(this.planarRegionViewer.getRoot());
        this.mainPane.setCenter((Node)view3dFactory.getSubSceneWrappedInsidePane());
        this.uiConnectionHandler = new UIConnectionHandler((Window)primaryStage, this.uiMessager, GPUPerceptionModuleAPI.RequestEntireModuleState);
        this.uiConnectionHandler.start();
        this.uiMessager.notifyModuleMessagerStateListeners();
        primaryStage.setTitle(this.getClass().getSimpleName());
        Scene mainScene = new Scene((Parent)this.mainPane, 600.0, 400.0);
        primaryStage.setScene(mainScene);
        primaryStage.setOnCloseRequest(event -> this.stop());
    }

    public static GPUBasedEnvironmentAwarenessUI createIntraprocessUI(Messager messager, Stage primaryStage) throws Exception {
        return new GPUBasedEnvironmentAwarenessUI(messager, primaryStage);
    }

    @Override
    public void show() {
        this.primaryStage.show();
    }

    @Override
    public void stop() {
    }
}

