/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotEnvironmentAwareness.slam.tools;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.mutable.MutableDouble;
import us.ihmc.euclid.geometry.ConvexPolygon2D;
import us.ihmc.euclid.geometry.Plane3D;
import us.ihmc.euclid.geometry.interfaces.ConvexPolygon2DReadOnly;
import us.ihmc.euclid.geometry.interfaces.Plane3DReadOnly;
import us.ihmc.euclid.geometry.interfaces.Vertex3DSupplier;
import us.ihmc.euclid.geometry.tools.EuclidGeometryTools;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.jOctoMap.iterators.OcTreeIterable;
import us.ihmc.jOctoMap.iterators.OcTreeIteratorFactory;
import us.ihmc.jOctoMap.key.OcTreeKey;
import us.ihmc.jOctoMap.key.OcTreeKeyReadOnly;
import us.ihmc.jOctoMap.node.NormalOcTreeNode;
import us.ihmc.jOctoMap.node.baseImplementation.AbstractOcTreeNode;
import us.ihmc.jOctoMap.normalEstimation.NormalEstimationParameters;
import us.ihmc.jOctoMap.ocTree.NormalOcTree;
import us.ihmc.jOctoMap.pointCloud.PointCloud;
import us.ihmc.jOctoMap.pointCloud.Scan;
import us.ihmc.jOctoMap.pointCloud.ScanCollection;
import us.ihmc.jOctoMap.tools.OcTreeNearestNeighborTools;

public class SLAMTools {
    public static Scan toScan(List<? extends Point3DReadOnly> points, Tuple3DReadOnly sensorPosition) {
        PointCloud pointCloud = new PointCloud();
        points.forEach(arg_0 -> ((PointCloud)pointCloud).add(arg_0));
        return new Scan((Point3DReadOnly)new Point3D(sensorPosition), pointCloud);
    }

    public static Scan toScan(Point3DReadOnly[] points, Tuple3DReadOnly sensorPosition, ConvexPolygon2DReadOnly mapHull, double windowMargin, boolean filterInParallel) {
        PointCloud pointCloud = new PointCloud();
        Stream pointStream = filterInParallel ? (Stream)Arrays.stream(points).parallel() : Arrays.stream(points);
        List<Point3DReadOnly> filteredPoints = pointStream.filter(point -> {
            if (!mapHull.getBoundingBox().isInsideEpsilon(point.getX(), point.getY(), -windowMargin)) {
                return false;
            }
            return mapHull.isPointInside(point.getX(), point.getY(), -windowMargin);
        }).collect(Collectors.toList());
        filteredPoints.forEach(arg_0 -> ((PointCloud)pointCloud).add(arg_0));
        return new Scan((Point3DReadOnly)new Point3D(sensorPosition), pointCloud);
    }

    public static List<Point3DReadOnly> createConvertedPointsToSensorPose(RigidBodyTransformReadOnly sensorPose, Point3DReadOnly[] pointCloud, boolean calculateInParallel) {
        Stream pointCloudStream = calculateInParallel ? (Stream)Arrays.stream(pointCloud).parallel() : Arrays.stream(pointCloud);
        return pointCloudStream.map(point -> SLAMTools.createConvertedPointToSensorPose(sensorPose, point)).collect(Collectors.toList());
    }

    public static Plane3D createConvertedSurfaceElementToSensorPose(RigidBodyTransformReadOnly sensorPose, Plane3DReadOnly surfaceElement) {
        Plane3D convertedSurfel = new Plane3D();
        sensorPose.inverseTransform(surfaceElement.getPoint(), convertedSurfel.getPoint());
        sensorPose.inverseTransform((Vector3DReadOnly)surfaceElement.getNormal(), (Vector3DBasics)convertedSurfel.getNormal());
        return convertedSurfel;
    }

    public static Point3D createConvertedPointToSensorPose(RigidBodyTransformReadOnly sensorPose, Point3DReadOnly point) {
        Point3D convertedPoint = new Point3D();
        sensorPose.inverseTransform(point, (Point3DBasics)convertedPoint);
        return convertedPoint;
    }

    public static NormalOcTree computeOctreeData(List<? extends Point3DReadOnly> pointCloud, Tuple3DReadOnly sensorPosition, double octreeResolution) {
        ScanCollection scanCollection = new ScanCollection();
        int numberOfPoints = pointCloud.size();
        scanCollection.setSubSampleSize(numberOfPoints);
        scanCollection.addScan(SLAMTools.toScan(pointCloud, sensorPosition));
        NormalOcTree octree = new NormalOcTree(octreeResolution);
        octree.insertScanCollection(scanCollection, false);
        octree.enableParallelComputationForNormals(true);
        NormalEstimationParameters normalEstimationParameters = new NormalEstimationParameters();
        normalEstimationParameters.setNumberOfIterations(7);
        octree.setNormalEstimationParameters(normalEstimationParameters);
        octree.updateNormals();
        return octree;
    }

    public static double computeDistancePointToNormalOctree(NormalOcTree octree, Point3DReadOnly point) {
        OcTreeKey occupiedKey = octree.coordinateToKey(point);
        OcTreeKey nearestKey = new OcTreeKey();
        OcTreeNearestNeighborTools.findNearestNeighbor((AbstractOcTreeNode)((NormalOcTreeNode)octree.getRoot()), (Point3DReadOnly)octree.keyToCoordinate((OcTreeKeyReadOnly)occupiedKey), (OcTreeKey)nearestKey);
        MutableDouble nearestHitDistanceSquared = new MutableDouble(Double.POSITIVE_INFINITY);
        double resolution = octree.getResolution();
        OcTreeNearestNeighborTools.findRadiusNeighbors((AbstractOcTreeNode)((NormalOcTreeNode)octree.getRoot()), (Point3DReadOnly)octree.keyToCoordinate((OcTreeKeyReadOnly)nearestKey), (double)(resolution * 1.5), node -> nearestHitDistanceSquared.setValue(Math.min(nearestHitDistanceSquared.doubleValue(), node.getHitLocationCopy().distanceSquared(point))));
        return Math.sqrt(nearestHitDistanceSquared.getValue());
    }

    public static double computePerpendicularDistancePointToNormalOctree(NormalOcTree octree, Point3DReadOnly point) {
        OcTreeKey occupiedKey = octree.coordinateToKey(point);
        OcTreeKey nearestKey = new OcTreeKey();
        OcTreeNearestNeighborTools.findNearestNeighbor((AbstractOcTreeNode)((NormalOcTreeNode)octree.getRoot()), (Point3DReadOnly)octree.keyToCoordinate((OcTreeKeyReadOnly)occupiedKey), (OcTreeKey)nearestKey);
        MutableDouble nearestHitDistanceSquared = new MutableDouble(Double.POSITIVE_INFINITY);
        double resolution = octree.getResolution();
        OcTreeNearestNeighborTools.findRadiusNeighbors((AbstractOcTreeNode)((NormalOcTreeNode)octree.getRoot()), (Point3DReadOnly)octree.keyToCoordinate((OcTreeKeyReadOnly)nearestKey), (double)(resolution * 2.0), node -> nearestHitDistanceSquared.setValue(Math.min(nearestHitDistanceSquared.doubleValue(), EuclidGeometryTools.distanceFromPoint3DToPlane3D((Point3DReadOnly)point, (Point3DReadOnly)node.getHitLocationCopy(), (Vector3DReadOnly)node.getNormalCopy()))));
        return nearestHitDistanceSquared.getValue();
    }

    public static double computeBoundedPerpendicularDistancePointToNormalOctree(NormalOcTree octree, Point3DReadOnly point, double bound) {
        OcTreeKey occupiedKey = octree.coordinateToKey(point);
        OcTreeKey nearestKey = new OcTreeKey();
        OcTreeNearestNeighborTools.findNearestNeighbor((AbstractOcTreeNode)((NormalOcTreeNode)octree.getRoot()), (Point3DReadOnly)octree.keyToCoordinate((OcTreeKeyReadOnly)occupiedKey), (OcTreeKey)nearestKey);
        MutableDouble nearestHitDistanceSquared = new MutableDouble(Double.POSITIVE_INFINITY);
        double resolution = octree.getResolution();
        OcTreeNearestNeighborTools.findRadiusNeighbors((AbstractOcTreeNode)((NormalOcTreeNode)octree.getRoot()), (Point3DReadOnly)octree.keyToCoordinate((OcTreeKeyReadOnly)nearestKey), (double)(resolution * 2.0), node -> {
            double linearDistance;
            double distance = linearDistance = point.distance((Point3DReadOnly)node.getHitLocationCopy());
            if (linearDistance < bound) {
                double distanceToSurfel;
                distance = distanceToSurfel = EuclidGeometryTools.distanceFromPoint3DToPlane3D((Point3DReadOnly)point, (Point3DReadOnly)node.getHitLocationCopy(), (Vector3DReadOnly)node.getNormalCopy());
            }
            nearestHitDistanceSquared.setValue(Math.min(nearestHitDistanceSquared.doubleValue(), distance));
        });
        return nearestHitDistanceSquared.getValue();
    }

    public static ConvexPolygon2D computeMapConvexHullInSensorFrame(NormalOcTree mapOctree, RigidBodyTransformReadOnly sensorPose) {
        ArrayList<Point3D> vertex = new ArrayList<Point3D>();
        OcTreeIterable iterable = OcTreeIteratorFactory.createIterable((AbstractOcTreeNode)((NormalOcTreeNode)mapOctree.getRoot()));
        for (NormalOcTreeNode node : iterable) {
            Point3D hitLocation = node.getHitLocationCopy();
            sensorPose.inverseTransform((Point3DBasics)hitLocation);
            vertex.add(hitLocation);
        }
        Vertex3DSupplier supplier = Vertex3DSupplier.asVertex3DSupplier(vertex);
        return new ConvexPolygon2D(supplier);
    }
}

