/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotEnvironmentAwareness.planarRegion.slam;

import gnu.trove.list.array.TIntArrayList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import org.ejml.dense.row.linsol.svd.SolvePseudoInverseSvd_DDRM;
import org.ejml.interfaces.decomposition.SingularValueDecomposition_F64;
import us.ihmc.euclid.axisAngle.AxisAngle;
import us.ihmc.euclid.geometry.BoundingBox2D;
import us.ihmc.euclid.geometry.BoundingBox3D;
import us.ihmc.euclid.geometry.Plane3D;
import us.ihmc.euclid.geometry.interfaces.BoundingBox2DReadOnly;
import us.ihmc.euclid.geometry.interfaces.BoundingBox3DReadOnly;
import us.ihmc.euclid.matrix.RotationMatrix;
import us.ihmc.euclid.matrix.interfaces.RotationMatrixReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.shape.collision.EuclidShape3DCollisionResult;
import us.ihmc.euclid.shape.collision.gjk.GilbertJohnsonKeerthiCollisionDetector;
import us.ihmc.euclid.shape.primitives.Box3D;
import us.ihmc.euclid.shape.primitives.interfaces.Shape3DReadOnly;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.interfaces.Point2DBasics;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.UnitVector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.UnitVector3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.Vector4D;
import us.ihmc.log.LogTools;
import us.ihmc.robotEnvironmentAwareness.planarRegion.slam.PlanarRegionSLAMParameters;
import us.ihmc.robotEnvironmentAwareness.tools.ConcaveHullMerger;
import us.ihmc.robotics.EuclidGeometryMissingTools;
import us.ihmc.robotics.geometry.GeometryTools;
import us.ihmc.robotics.geometry.PlanarRegion;
import us.ihmc.robotics.geometry.PlanarRegionTools;
import us.ihmc.robotics.geometry.PlanarRegionsList;
import us.ihmc.tools.lists.PairList;

public class PlanarRegionSLAMTools {
    private static boolean verbose = false;

    public static RigidBodyTransform findDriftCorrectionTransform(Map<PlanarRegion, PairList<PlanarRegion, Point2D>> matchesWithReferencePoints, PlanarRegionSLAMParameters parameters, RigidBodyTransform referenceTransform) {
        RigidBodyTransform bigT = new RigidBodyTransform();
        SolvePseudoInverseSvd_DDRM solver = new SolvePseudoInverseSvd_DDRM();
        int numberOfMatches = 0;
        for (PairList<PlanarRegion, Point2D> newDataRegionWithReferencePoints : matchesWithReferencePoints.values()) {
            numberOfMatches += newDataRegionWithReferencePoints.size();
        }
        if (numberOfMatches == 0) {
            return new RigidBodyTransform();
        }
        DMatrixRMaj A = new DMatrixRMaj(numberOfMatches, 6);
        DMatrixRMaj b = new DMatrixRMaj(numberOfMatches, 1);
        int i = 0;
        for (PlanarRegion mapRegion : matchesWithReferencePoints.keySet()) {
            Plane3D planarRegionPlane3D = mapRegion.getPlane();
            UnitVector3DBasics normal = planarRegionPlane3D.getNormal();
            Vector3D normalInReferenceFrame = null;
            if (referenceTransform != null) {
                normalInReferenceFrame = new Vector3D((Tuple3DReadOnly)normal);
                referenceTransform.inverseTransform((Vector3DBasics)normalInReferenceFrame);
            }
            for (ImmutablePair newDataRegionWithReferencePoint : matchesWithReferencePoints.get(mapRegion)) {
                PlanarRegion newPlanarRegion = (PlanarRegion)newDataRegionWithReferencePoint.getLeft();
                Point2D referencePointInNewDataLocal = (Point2D)newDataRegionWithReferencePoint.getRight();
                Point3D referencePointInWorld = new Point3D((Tuple2DReadOnly)referencePointInNewDataLocal);
                RigidBodyTransform transformFromNewDataToWorld = new RigidBodyTransform();
                newPlanarRegion.getTransformToWorld(transformFromNewDataToWorld);
                transformFromNewDataToWorld.transform((Point3DBasics)referencePointInWorld);
                Vector3D cross = new Vector3D();
                if (referenceTransform != null) {
                    Point3D referencePointInReferenceFrame = new Point3D((Tuple3DReadOnly)referencePointInWorld);
                    referenceTransform.inverseTransform((Point3DBasics)referencePointInReferenceFrame);
                    cross.cross((Tuple3DReadOnly)referencePointInReferenceFrame, (Tuple3DReadOnly)normalInReferenceFrame);
                } else {
                    cross.cross((Tuple3DReadOnly)referencePointInWorld, (Tuple3DReadOnly)normal);
                }
                A.set(i, 0, cross.getX());
                A.set(i, 1, cross.getY());
                A.set(i, 2, cross.getZ());
                if (referenceTransform != null) {
                    A.set(i, 3, normalInReferenceFrame.getX());
                    A.set(i, 4, normalInReferenceFrame.getY());
                    A.set(i, 5, normalInReferenceFrame.getZ());
                } else {
                    A.set(i, 3, normal.getX());
                    A.set(i, 4, normal.getY());
                    A.set(i, 5, normal.getZ());
                }
                double signedDistanceFromPointToPlane = planarRegionPlane3D.signedDistance((Point3DReadOnly)referencePointInWorld);
                if (verbose && Math.abs(signedDistanceFromPointToPlane) > 0.05) {
                    System.err.println("\n\n*******************\nsignedDistanceFromPointToPlane = " + signedDistanceFromPointToPlane);
                    System.err.println("referencePointInWorld = " + referencePointInWorld);
                    System.err.println("planarRegionPlane3D = " + planarRegionPlane3D);
                    System.err.println("mapRegion = " + mapRegion);
                    System.err.println("newPlanarRegion = " + newPlanarRegion);
                    System.err.println("normal = " + (Vector3DReadOnly)normal);
                    System.err.println("normalOfNewPlanarRegion = " + newPlanarRegion.getNormal());
                }
                b.set(i, 0, -signedDistanceFromPointToPlane);
                ++i;
            }
        }
        if (verbose) {
            LogTools.info((String)"numberReferencePoints: {}", (Object)i);
            LogTools.info((String)"A: {}", (Object)A);
            LogTools.info((String)"b: {}", (Object)b);
        }
        DMatrixRMaj x = new DMatrixRMaj(6, 1);
        DMatrixRMaj ATransposeTimesA = new DMatrixRMaj(6, 6);
        CommonOps_DDRM.multInner((DMatrix1Row)A, (DMatrix1Row)ATransposeTimesA);
        DMatrixRMaj ATransposeB = new DMatrixRMaj(6, 1);
        CommonOps_DDRM.multTransA((DMatrix1Row)A, (DMatrix1Row)b, (DMatrix1Row)ATransposeB);
        DMatrixRMaj lambdaI = CommonOps_DDRM.identity((int)6);
        CommonOps_DDRM.scale((double)parameters.getDampedLeastSquaresLambda(), (DMatrixD1)lambdaI);
        DMatrixRMaj ATransposeTimesAPlusLambdaI = new DMatrixRMaj(6, 6);
        CommonOps_DDRM.add((DMatrixD1)ATransposeTimesA, (DMatrixD1)lambdaI, (DMatrixD1)ATransposeTimesAPlusLambdaI);
        solver.setA(ATransposeTimesAPlusLambdaI);
        solver.solve(ATransposeB, x);
        if (verbose) {
            SingularValueDecomposition_F64 decomposition = solver.getDecomposition();
            double[] singularValues = decomposition.getSingularValues();
            LogTools.info((String)("singularValues = " + PlanarRegionSLAMTools.doubleArrayToString(singularValues)));
            LogTools.info((String)"ATransposeTimesA: {}", (Object)ATransposeTimesA);
            LogTools.info((String)"ATransposeB: {}", (Object)ATransposeTimesA);
            LogTools.info((String)"x: {}", (Object)x);
        }
        double rx = x.get(0, 0);
        double ry = x.get(1, 0);
        double rz = x.get(2, 0);
        double tx = x.get(3, 0);
        double ty = x.get(4, 0);
        double tz = x.get(5, 0);
        RotationMatrix rotationMatrix = new RotationMatrix((Vector3DReadOnly)new Vector3D(rx, ry, rz));
        Vector3D translation = new Vector3D(tx, ty, tz);
        bigT.set((RotationMatrixReadOnly)rotationMatrix, (Tuple3DReadOnly)translation);
        if (referenceTransform != null) {
            RigidBodyTransform transformToReturn = new RigidBodyTransform((RigidBodyTransformReadOnly)bigT);
            transformToReturn.preMultiply((RigidBodyTransformReadOnly)referenceTransform);
            transformToReturn.multiplyInvertOther((RigidBodyTransformReadOnly)referenceTransform);
            return transformToReturn;
        }
        return bigT;
    }

    private static String doubleArrayToString(double[] singularValues) {
        Object returnString = "(";
        for (int i = 0; i < singularValues.length; ++i) {
            returnString = (String)returnString + singularValues[i];
            if (i == singularValues.length - 1) continue;
            returnString = (String)returnString + ", ";
        }
        returnString = (String)returnString + ")";
        return returnString;
    }

    public static Map<PlanarRegion, List<PlanarRegion>> filterMatchesBasedOnNormalSimilarity(Map<PlanarRegion, List<PlanarRegion>> matchesSoFar, double threshold) {
        HashMap<PlanarRegion, List<PlanarRegion>> normalFilteredMap = new HashMap<PlanarRegion, List<PlanarRegion>>();
        for (PlanarRegion mapRegion : matchesSoFar.keySet()) {
            ArrayList<PlanarRegion> normalMatches = new ArrayList<PlanarRegion>();
            for (PlanarRegion newDataRegion : matchesSoFar.get(mapRegion)) {
                double dot = newDataRegion.getNormal().dot((Tuple3DReadOnly)mapRegion.getNormal());
                if (!(dot > threshold)) continue;
                normalMatches.add(newDataRegion);
            }
            if (normalMatches.isEmpty()) continue;
            normalFilteredMap.put(mapRegion, normalMatches);
        }
        return normalFilteredMap;
    }

    public static Map<PlanarRegion, PairList<PlanarRegion, Point2D>> filterMatchesBasedOn2DBoundingBoxShadow(double minimumRegionOverlapDistance, double maximumPointProjectionDistance, Map<PlanarRegion, List<PlanarRegion>> matchesSoFar) {
        HashMap<PlanarRegion, PairList<PlanarRegion, Point2D>> mapToShadowMatchAndFitPoints = new HashMap<PlanarRegion, PairList<PlanarRegion, Point2D>>();
        for (PlanarRegion mapRegion : matchesSoFar.keySet()) {
            PairList shadowMatches = new PairList();
            for (PlanarRegion newDataRegion : matchesSoFar.get(mapRegion)) {
                BoundingBox2D newDataRegionBoundingBoxProjectedToMapLocal = PlanarRegionSLAMTools.computeNewDataRegionBoundingBoxProjectedToMapLocal(newDataRegion, mapRegion.getTransformToLocal(), newDataRegion.getTransformToWorld());
                BoundingBox2D mapBoundingBoxInMapLocal = PlanarRegionTools.getLocalBoundingBox2DInLocal((PlanarRegion)mapRegion);
                boolean boundingBoxShadowsMapRegion = mapBoundingBoxInMapLocal.intersectsEpsilon((BoundingBox2DReadOnly)newDataRegionBoundingBoxProjectedToMapLocal, -minimumRegionOverlapDistance);
                if (!boundingBoxShadowsMapRegion) continue;
                PlanarRegionSLAMTools.addCornerPointsOfBoundingBoxIntersectionToMatches(mapBoundingBoxInMapLocal, newDataRegionBoundingBoxProjectedToMapLocal, newDataRegion, mapRegion.getTransformToLocal(), newDataRegion.getTransformToWorld(), maximumPointProjectionDistance, (PairList<PlanarRegion, Point2D>)shadowMatches);
            }
            if (shadowMatches.isEmpty()) continue;
            mapToShadowMatchAndFitPoints.put(mapRegion, (PairList<PlanarRegion, Point2D>)shadowMatches);
        }
        return mapToShadowMatchAndFitPoints;
    }

    private static void addCornerPointsOfBoundingBoxIntersectionToMatches(BoundingBox2D mapBoundingBoxInMapLocal, BoundingBox2D newDataRegionBoundingBoxProjectedToMapLocal, PlanarRegion newDataRegion, RigidBodyTransformReadOnly transformFromWorldToMap, RigidBodyTransformReadOnly transformFromNewDataToWorld, double maximumPointProjectionDistance, PairList<PlanarRegion, Point2D> shadowMatches) {
        BoundingBox2D intersection = EuclidGeometryMissingTools.computeIntersectionOfTwoBoundingBoxes((BoundingBox2DReadOnly)mapBoundingBoxInMapLocal, (BoundingBox2DReadOnly)newDataRegionBoundingBoxProjectedToMapLocal);
        if (intersection == null) {
            LogTools.error((String)"Woops. Should never get here!!");
            LogTools.error((String)("mapBoundingBoxInMapLocal = " + mapBoundingBoxInMapLocal));
            LogTools.error((String)("newDataRegionBoundingBoxProjectedToMapLocal = " + newDataRegionBoundingBoxProjectedToMapLocal));
            return;
        }
        Point2D centerPoint = new Point2D();
        Point2D minPoint = new Point2D();
        Point2D maxPoint = new Point2D();
        intersection.getCenterPoint((Point2DBasics)centerPoint);
        minPoint.set((Tuple2DReadOnly)intersection.getMinPoint());
        maxPoint.set((Tuple2DReadOnly)intersection.getMaxPoint());
        Point2D newCenterPointInNewDataLocal = PlanarRegionSLAMTools.createNewDataReferencePointInNewDataLocal((Point2DReadOnly)centerPoint, transformFromWorldToMap, transformFromNewDataToWorld, maximumPointProjectionDistance);
        Point2D newMinimumPointInNewDataLocal = PlanarRegionSLAMTools.createNewDataReferencePointInNewDataLocal((Point2DReadOnly)minPoint, transformFromWorldToMap, transformFromNewDataToWorld, maximumPointProjectionDistance);
        Point2D newMaximumPointInNewDataLocal = PlanarRegionSLAMTools.createNewDataReferencePointInNewDataLocal((Point2DReadOnly)maxPoint, transformFromWorldToMap, transformFromNewDataToWorld, maximumPointProjectionDistance);
        Point2D otherCorner = new Point2D(minPoint.getX(), maxPoint.getY());
        Point2D newDataOtherCornerPointInNewDataLocal = PlanarRegionSLAMTools.createNewDataReferencePointInNewDataLocal((Point2DReadOnly)otherCorner, transformFromWorldToMap, transformFromNewDataToWorld, maximumPointProjectionDistance);
        Point2D finalCorner = new Point2D(maxPoint.getX(), minPoint.getY());
        Point2D newFinalCornerPointInNewDataLocal = PlanarRegionSLAMTools.createNewDataReferencePointInNewDataLocal((Point2DReadOnly)finalCorner, transformFromWorldToMap, transformFromNewDataToWorld, maximumPointProjectionDistance);
        PlanarRegionSLAMTools.addAllIfAllAreNotNull(shadowMatches, newDataRegion, newCenterPointInNewDataLocal, newMinimumPointInNewDataLocal, newMaximumPointInNewDataLocal, newDataOtherCornerPointInNewDataLocal, newFinalCornerPointInNewDataLocal);
    }

    private static void addAllIfAllAreNotNull(PairList<PlanarRegion, Point2D> shadowMatches, PlanarRegion planarRegion, Point2D ... pointsToAdd) {
        boolean areAnyNull = PlanarRegionSLAMTools.areAnyNull(pointsToAdd);
        if (areAnyNull) {
            return;
        }
        for (Point2D point : pointsToAdd) {
            shadowMatches.add((Object)planarRegion, (Object)point);
        }
    }

    private static boolean areAnyNull(Point2D[] points) {
        for (Point2D point : points) {
            if (point != null) continue;
            return true;
        }
        return false;
    }

    private static BoundingBox2D computeNewDataRegionBoundingBoxProjectedToMapLocal(PlanarRegion newDataRegion, RigidBodyTransformReadOnly transformFromWorldToMap, RigidBodyTransformReadOnly transformFromNewDataToWorld) {
        BoundingBox2D newDataRegionBoundingBoxInLocal = PlanarRegionTools.getLocalBoundingBox2DInLocal((PlanarRegion)newDataRegion);
        Point3D newDataBoundingBoxMinPoint = new Point3D((Tuple2DReadOnly)newDataRegionBoundingBoxInLocal.getMinPoint());
        Point3D newDataBoundingBoxMaxPoint = new Point3D((Tuple2DReadOnly)newDataRegionBoundingBoxInLocal.getMaxPoint());
        transformFromNewDataToWorld.transform((Point3DBasics)newDataBoundingBoxMinPoint);
        transformFromNewDataToWorld.transform((Point3DBasics)newDataBoundingBoxMaxPoint);
        transformFromWorldToMap.transform((Point3DBasics)newDataBoundingBoxMinPoint);
        transformFromWorldToMap.transform((Point3DBasics)newDataBoundingBoxMaxPoint);
        double minX = Math.min(newDataBoundingBoxMinPoint.getX(), newDataBoundingBoxMaxPoint.getX());
        double minY = Math.min(newDataBoundingBoxMinPoint.getY(), newDataBoundingBoxMaxPoint.getY());
        double maxX = Math.max(newDataBoundingBoxMinPoint.getX(), newDataBoundingBoxMaxPoint.getX());
        double maxY = Math.max(newDataBoundingBoxMinPoint.getY(), newDataBoundingBoxMaxPoint.getY());
        Point2D newDataBoundingBoxMinPoint2D = new Point2D(minX, minY);
        Point2D newDataBoundingBoxMaxPoint2D = new Point2D(maxX, maxY);
        BoundingBox2D newDataRegionBoundingBoxProjectedToMapLocal = new BoundingBox2D((Point2DReadOnly)newDataBoundingBoxMinPoint2D, (Point2DReadOnly)newDataBoundingBoxMaxPoint2D);
        return newDataRegionBoundingBoxProjectedToMapLocal;
    }

    private static Point2D createNewDataReferencePointInNewDataLocal(Point2DReadOnly pointInMapLocal, RigidBodyTransformReadOnly transformFromWorldToMap, RigidBodyTransformReadOnly transformFromNewDataToWorld, double maximumPointProjectionDistance) {
        Point3D newDataReferencePoint = new Point3D((Tuple2DReadOnly)pointInMapLocal);
        newDataReferencePoint.applyInverseTransform((Transform)transformFromWorldToMap);
        newDataReferencePoint.applyInverseTransform((Transform)transformFromNewDataToWorld);
        double distanceProjectedToLocal = Math.abs(newDataReferencePoint.getZ());
        if (distanceProjectedToLocal > maximumPointProjectionDistance) {
            return null;
        }
        return new Point2D((Tuple3DReadOnly)newDataReferencePoint);
    }

    public static Map<PlanarRegion, List<PlanarRegion>> detectLocalBoundingBox3DCollisions(PlanarRegionsList map, PlanarRegionsList newData, double boundingBoxHeight) {
        HashMap<PlanarRegion, List<PlanarRegion>> newDataCollisions = new HashMap<PlanarRegion, List<PlanarRegion>>();
        for (PlanarRegion planarRegion : map.getPlanarRegionsAsList()) {
            ArrayList<PlanarRegion> localCollisions = new ArrayList<PlanarRegion>();
            for (PlanarRegion newRegion : newData.getPlanarRegionsAsList()) {
                if (!PlanarRegionSLAMTools.boxesIn3DIntersect(planarRegion, newRegion, boundingBoxHeight)) continue;
                localCollisions.add(newRegion);
            }
            if (localCollisions.isEmpty()) continue;
            newDataCollisions.put(planarRegion, localCollisions);
        }
        return newDataCollisions;
    }

    public static void findPlanarRegionMatches(PlanarRegionsList map, PlanarRegionsList incoming, HashMap<Integer, TIntArrayList> matches, float overlapThreshold, float normalThreshold, float distanceThreshold, float minBoxSize) {
        matches.clear();
        List newRegions = incoming.getPlanarRegionsAsList();
        List mapRegions = map.getPlanarRegionsAsList();
        for (int i = 0; i < newRegions.size(); ++i) {
            matches.put(i, new TIntArrayList());
            PlanarRegion newRegion = (PlanarRegion)newRegions.get(i);
            for (int j = 0; j < mapRegions.size(); ++j) {
                PlanarRegion mapRegion = (PlanarRegion)mapRegions.get(j);
                if (!PlanarRegionSLAMTools.checkRegionsForOverlap(newRegion, mapRegion, overlapThreshold, normalThreshold, distanceThreshold, minBoxSize, false)) continue;
                matches.get(i).add(j);
            }
        }
    }

    public static boolean boxesIn3DIntersect(PlanarRegion a, PlanarRegion b, double boxHeight) {
        Box3D boxA = PlanarRegionTools.getLocalBoundingBox3DInWorld((PlanarRegion)a, (double)boxHeight);
        Box3D boxB = PlanarRegionTools.getLocalBoundingBox3DInWorld((PlanarRegion)b, (double)boxHeight);
        GilbertJohnsonKeerthiCollisionDetector gjkCollisionDetector = new GilbertJohnsonKeerthiCollisionDetector();
        EuclidShape3DCollisionResult collisionResult = gjkCollisionDetector.evaluateCollision((Shape3DReadOnly)boxA, (Shape3DReadOnly)boxB);
        return collisionResult.areShapesColliding();
    }

    public static double computeBoundingBoxOverlapScore(PlanarRegion a, PlanarRegion b, double minSize, boolean useIntersectionOverUnion) {
        BoundingBox3D boxA = PlanarRegionTools.getWorldBoundingBox3DWithMargin((PlanarRegion)a, (double)minSize);
        BoundingBox3D boxB = PlanarRegionTools.getWorldBoundingBox3DWithMargin((PlanarRegion)b, (double)minSize);
        if (useIntersectionOverUnion) {
            return GeometryTools.computeIntersectionOverUnionOfTwoBoundingBoxes((BoundingBox3DReadOnly)boxA, (BoundingBox3DReadOnly)boxB);
        }
        return GeometryTools.computeIntersectionOverSmallerOfTwoBoundingBoxes((BoundingBox3DReadOnly)boxA, (BoundingBox3DReadOnly)boxB);
    }

    public static boolean boundingBoxesIntersect(PlanarRegion a, PlanarRegion b) {
        return a.getBoundingBox3dInWorld().intersectsEpsilon((BoundingBox3DReadOnly)b.getBoundingBox3dInWorld(), 1.0E-8);
    }

    public static void updateParentPlaneUsingComplementaryFilter(PlanarRegion parentRegion, PlanarRegion childRegion, double updateTowardsChildAlpha) {
        UnitVector3DReadOnly mapNormal = parentRegion.getNormal();
        Point3DReadOnly mapOrigin = parentRegion.getPoint();
        UnitVector3DReadOnly regionNormal = childRegion.getNormal();
        Point3DReadOnly regionOrigin = childRegion.getPoint();
        Vector3D futureNormal = new Vector3D();
        futureNormal.interpolate((Tuple3DReadOnly)mapNormal, (Tuple3DReadOnly)regionNormal, updateTowardsChildAlpha);
        double futureHeightZ = EuclidCoreTools.interpolate((double)mapOrigin.getZ(), (double)regionOrigin.getZ(), (double)updateTowardsChildAlpha);
        Vector3D normalVector = new Vector3D((Tuple3DReadOnly)mapNormal);
        Vector3D axis = new Vector3D();
        axis.cross((Tuple3DReadOnly)normalVector, (Tuple3DReadOnly)futureNormal);
        double angle = normalVector.angle((Vector3DReadOnly)futureNormal);
        Point3D futureOrigin = new Point3D(mapOrigin.getX(), mapOrigin.getY(), futureHeightZ);
        AxisAngle rotationToFutureRegion = new AxisAngle((Vector3DReadOnly)axis, angle);
        Vector3D translationToFutureRegion = new Vector3D();
        translationToFutureRegion.sub((Tuple3DReadOnly)futureOrigin, (Tuple3DReadOnly)mapOrigin);
        RigidBodyTransform transform = new RigidBodyTransform((Orientation3DReadOnly)rotationToFutureRegion, (Tuple3DReadOnly)translationToFutureRegion);
        transform.normalizeRotationPart();
        parentRegion.applyTransform((RigidBodyTransformReadOnly)transform);
    }

    public static boolean mergeRegionIntoParentUsingFilter(PlanarRegion parentRegion, PlanarRegion childRegion, double updateTowardsChildAlpha) {
        PlanarRegionSLAMTools.updateParentPlaneUsingComplementaryFilter(parentRegion, childRegion, updateTowardsChildAlpha);
        return PlanarRegionSLAMTools.mergeRegionHulls(parentRegion, childRegion);
    }

    public static boolean mergeRegionIntoParentUsingOptimalPlane(PlanarRegion parentRegion, PlanarRegion childRegion, Vector4D optimalPlane) {
        return PlanarRegionSLAMTools.mergeRegionHulls(parentRegion, childRegion);
    }

    public static boolean mergeRegionHulls(PlanarRegion parentRegion, PlanarRegion childRegion) {
        ArrayList<PlanarRegion> mergedRegion = ConcaveHullMerger.mergePlanarRegions(parentRegion, childRegion, 1.0, null);
        if (mergedRegion != null) {
            if (mergedRegion.size() > 0) {
                parentRegion.set(mergedRegion.get(0));
                return true;
            }
            if (parentRegion.getConvexHull().isPointInside(childRegion.getConvexHull().getVertex(0))) {
                return true;
            }
            if (childRegion.getConvexHull().isPointInside(parentRegion.getConvexHull().getVertex(0))) {
                parentRegion.set(childRegion);
                return true;
            }
            return false;
        }
        return false;
    }

    private static void updateRegionPlaneTowardsReference(PlanarRegion regionToModify, PlanarRegion regionToRefer, double updateTowardsSecondAlpha) {
        UnitVector3DReadOnly firstNormal = regionToModify.getNormal();
        Point3DReadOnly firstOrigin = regionToModify.getPoint();
        UnitVector3DReadOnly secondNormal = regionToRefer.getNormal();
        Point3DReadOnly secondOrigin = regionToRefer.getPoint();
        Vector3D futureNormal = new Vector3D();
        futureNormal.interpolate((Tuple3DReadOnly)firstNormal, (Tuple3DReadOnly)secondNormal, updateTowardsSecondAlpha);
        double futureHeightZ = EuclidCoreTools.interpolate((double)firstOrigin.getZ(), (double)secondOrigin.getZ(), (double)updateTowardsSecondAlpha);
        Vector3D normalVector = new Vector3D((Tuple3DReadOnly)firstNormal);
        Vector3D axis = new Vector3D();
        axis.cross((Tuple3DReadOnly)normalVector, (Tuple3DReadOnly)futureNormal);
        double angle = normalVector.angle((Vector3DReadOnly)futureNormal);
        Point3D futureOrigin = new Point3D(firstOrigin.getX(), firstOrigin.getY(), futureHeightZ);
        AxisAngle rotationToFutureRegion = new AxisAngle((Vector3DReadOnly)axis, angle);
        Vector3D translationToFutureRegion = new Vector3D();
        translationToFutureRegion.sub((Tuple3DReadOnly)futureOrigin, (Tuple3DReadOnly)firstOrigin);
        RigidBodyTransform transform = new RigidBodyTransform();
        transform.appendOrientation((Orientation3DReadOnly)rotationToFutureRegion);
        transform.appendTranslation((Tuple3DReadOnly)translationToFutureRegion);
        regionToModify.applyTransform((RigidBodyTransformReadOnly)transform);
    }

    public static boolean checkRegionsForOverlap(PlanarRegion regionA, PlanarRegion regionB, float normalThreshold, float normalDistanceThreshold, float overlapThreshold, float minBoxSize, boolean useIntersectionOverUnion) {
        boolean wasMatched;
        Point3D newOrigin = new Point3D();
        regionA.getOrigin((Point3DBasics)newOrigin);
        Point3D mapOrigin = new Point3D();
        regionB.getOrigin((Point3DBasics)mapOrigin);
        Vector3D originVector = new Vector3D();
        originVector.sub((Tuple3DReadOnly)newOrigin, (Tuple3DReadOnly)mapOrigin);
        double normalDistance = 0.0;
        boolean intersects = false;
        double overlapScore = 0.0;
        double normalSimilarity = regionB.getNormal().dot((Tuple3DReadOnly)regionA.getNormal());
        boolean bl = wasMatched = normalSimilarity > (double)normalThreshold;
        if (wasMatched && (wasMatched &= (normalDistance = Math.abs(originVector.dot((Tuple3DReadOnly)regionA.getNormal()))) < (double)normalDistanceThreshold)) {
            overlapScore = PlanarRegionSLAMTools.computeBoundingBoxOverlapScore(regionA, regionB, minBoxSize, useIntersectionOverUnion);
            intersects = overlapScore > (double)overlapThreshold;
            wasMatched &= intersects;
        }
        return wasMatched;
    }

    public static boolean checkRegionsForIntersection(PlanarRegion regionA, PlanarRegion regionB) {
        Vector3D normalA = new Vector3D();
        regionA.getNormal((Vector3DBasics)normalA);
        Vector3D normalB = new Vector3D();
        regionB.getNormal((Vector3DBasics)normalB);
        double overlapScore = PlanarRegionSLAMTools.computeBoundingBoxOverlapScore(regionA, regionB, 0.01, true);
        return Math.abs(normalA.dot((Tuple3DReadOnly)normalB)) < 0.2 && overlapScore > 0.02;
    }

    public static class MatchData {
        private final int matchingMapRegionId;

        public MatchData(int matchingMapRegionId) {
            this.matchingMapRegionId = matchingMapRegionId;
        }

        public int getMatchingMapRegionId() {
            return this.matchingMapRegionId;
        }

        public double getMatchScore() {
            return 100.0;
        }
    }

    public static class IncomingRegionMatchData {
        private final int incomingRegionId;
        private final List<MatchData> goodMatches = new ArrayList<MatchData>();
        private final List<MatchData> badMatches = new ArrayList<MatchData>();

        public IncomingRegionMatchData(int incomingRegionId) {
            this.incomingRegionId = incomingRegionId;
        }

        public void reset() {
            this.goodMatches.clear();
            this.badMatches.clear();
        }

        public int getIncomingRegionId() {
            return this.incomingRegionId;
        }

        public void addMatchData(MatchData matchData) {
            if (matchData.getMatchScore() > 50.0) {
                this.goodMatches.add(matchData);
            } else {
                this.badMatches.add(matchData);
            }
        }

        public int getNumberOfGoodMatches() {
            return this.goodMatches.size();
        }

        public int getNumberOfBadMatches() {
            return this.badMatches.size();
        }

        public int getNumberOfMatches() {
            return this.getNumberOfGoodMatches() + this.getNumberOfBadMatches();
        }

        public MatchData getGoodMatch(int goodMatchNumber) {
            return this.goodMatches.get(goodMatchNumber);
        }

        public MatchData getBadMatch(int badMatchNumber) {
            return this.badMatches.get(badMatchNumber);
        }
    }
}

