/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotEnvironmentAwareness.planarRegion;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import us.ihmc.euclid.geometry.BoundingBox3D;
import us.ihmc.euclid.geometry.LineSegment2D;
import us.ihmc.euclid.geometry.LineSegment3D;
import us.ihmc.euclid.geometry.interfaces.LineSegment3DReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.jOctoMap.node.NormalOcTreeNode;
import us.ihmc.robotEnvironmentAwareness.communication.converters.REAPlanarRegionsConverter;
import us.ihmc.robotEnvironmentAwareness.communication.packets.PlanarRegionSegmentationMessage;
import us.ihmc.robotEnvironmentAwareness.planarRegion.PlanarRegionSegmentationNodeData;
import us.ihmc.robotEnvironmentAwareness.planarRegion.PolygonizerTools;

public class PlanarRegionSegmentationRawData {
    private final int regionId;
    private final Vector3D normal;
    private final Point3D origin;
    private final Quaternion orientation;
    private final List<Point3D> pointCloud;
    private final List<LineSegment3D> intersections = new ArrayList<LineSegment3D>();
    private final BoundingBox3D boundingBoxWorld = new BoundingBox3D();

    public PlanarRegionSegmentationRawData(int regionId, Vector3DReadOnly normal, Point3DReadOnly origin) {
        this(regionId, normal, origin, Collections.emptyList());
    }

    public PlanarRegionSegmentationRawData(PlanarRegionSegmentationNodeData nodeData) {
        this(nodeData.getId(), (Vector3DReadOnly)nodeData.getNormal(), (Point3DReadOnly)nodeData.getOrigin(), nodeData.nodeStream().map(NormalOcTreeNode::getHitLocationCopy), null);
    }

    public PlanarRegionSegmentationRawData(PlanarRegionSegmentationMessage message) {
        this(message.getRegionId(), (Vector3DReadOnly)message.getNormal(), (Point3DReadOnly)message.getOrigin(), Arrays.stream(message.getHitLocations()), null);
    }

    public PlanarRegionSegmentationRawData(int regionId, Vector3DReadOnly normal, Point3DReadOnly origin, List<? extends Point3DReadOnly> pointCloud) {
        this(regionId, normal, origin, pointCloud.stream(), null);
    }

    private PlanarRegionSegmentationRawData(int regionId, Vector3DReadOnly normal, Point3DReadOnly origin, Stream<? extends Point3DReadOnly> streamToConvert, List<? extends LineSegment3DReadOnly> intersections) {
        this.regionId = regionId;
        this.normal = new Vector3D((Tuple3DReadOnly)normal);
        this.origin = new Point3D((Tuple3DReadOnly)origin);
        this.pointCloud = streamToConvert.map(Point3D::new).collect(Collectors.toList());
        this.orientation = PolygonizerTools.getQuaternionFromZUpToVector(normal);
        if (intersections != null) {
            intersections.forEach(this::addIntersection);
        }
        this.getPointCloudInWorld().forEach(arg_0 -> ((BoundingBox3D)this.boundingBoxWorld).updateToIncludePoint(arg_0));
    }

    public void addIntersections(List<? extends LineSegment3DReadOnly> intersectionsToAdd) {
        intersectionsToAdd.forEach(this::addIntersection);
    }

    public void addIntersection(LineSegment3DReadOnly intersectionToAdd) {
        this.intersections.add(new LineSegment3D(intersectionToAdd));
        this.boundingBoxWorld.updateToIncludePoint(intersectionToAdd.getFirstEndpoint());
        this.boundingBoxWorld.updateToIncludePoint(intersectionToAdd.getSecondEndpoint());
    }

    public void clearIntersections() {
        this.intersections.clear();
        this.boundingBoxWorld.setToNaN();
        this.pointCloud.forEach(arg_0 -> ((BoundingBox3D)this.boundingBoxWorld).updateToIncludePoint(arg_0));
    }

    public void translate(Tuple3DReadOnly translation) {
        this.origin.add(translation);
        this.pointCloud.stream().forEach(point -> point.add(translation));
        this.intersections.stream().forEach(segment -> segment.translate(translation));
        Point3D newMin = new Point3D((Tuple3DReadOnly)this.boundingBoxWorld.getMinPoint());
        Point3D newMax = new Point3D((Tuple3DReadOnly)this.boundingBoxWorld.getMaxPoint());
        newMin.add(translation);
        newMax.add(translation);
        this.boundingBoxWorld.set((Point3DReadOnly)newMin, (Point3DReadOnly)newMax);
    }

    public int getRegionId() {
        return this.regionId;
    }

    public int size() {
        return this.pointCloud.size();
    }

    public Point3D getOrigin() {
        return this.origin;
    }

    public Vector3D getNormal() {
        return this.normal;
    }

    public Quaternion getOrientation() {
        return this.orientation;
    }

    public RigidBodyTransform getTransformFromLocalToWorld() {
        return new RigidBodyTransform((Orientation3DReadOnly)this.orientation, (Tuple3DReadOnly)this.origin);
    }

    public BoundingBox3D getBoundingBoxInWorld() {
        return this.boundingBoxWorld;
    }

    public List<Point3D> getPointCloudInWorld() {
        return this.pointCloud;
    }

    public List<Point2D> getPointCloudInPlane() {
        return this.pointCloud.stream().map(this::toPointInPlane).collect(Collectors.toList());
    }

    private Point2D toPointInPlane(Point3D point3d) {
        return PolygonizerTools.toPointInPlane((Point3DReadOnly)point3d, (Point3DReadOnly)this.origin, (Orientation3DReadOnly)this.orientation);
    }

    public void getPoint(int index, Point3D pointToPack) {
        pointToPack.set(this.pointCloud.get(index));
    }

    public Stream<Point3D> stream() {
        return this.pointCloud.stream();
    }

    public Stream<Point3D> parallelStream() {
        return this.pointCloud.parallelStream();
    }

    public boolean hasIntersections() {
        return this.intersections != null;
    }

    public List<LineSegment3D> getIntersectionsInWorld() {
        return this.intersections;
    }

    public List<LineSegment2D> getIntersectionsInPlane() {
        return this.intersections.stream().map(this::toLineSegmentInPlane).collect(Collectors.toList());
    }

    private LineSegment2D toLineSegmentInPlane(LineSegment3D lineSegmentInWorld) {
        return PolygonizerTools.toLineSegmentInPlane((LineSegment3DReadOnly)lineSegmentInWorld, (Point3DReadOnly)this.origin, (Orientation3DReadOnly)this.orientation);
    }

    public PlanarRegionSegmentationMessage toMessage() {
        return REAPlanarRegionsConverter.createPlanarRegionSegmentationMessage(this.regionId, this.origin, this.normal, null, this.pointCloud);
    }

    public static PlanarRegionSegmentationMessage[] toMessageArray(List<PlanarRegionSegmentationRawData> rawData) {
        return (PlanarRegionSegmentationMessage[])rawData.stream().map(PlanarRegionSegmentationRawData::toMessage).toArray(PlanarRegionSegmentationMessage[]::new);
    }
}

