/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotEnvironmentAwareness.planarRegion;

import java.util.Scanner;

public class IntersectionEstimationParameters {
    private double maxDistanceToRegion;
    private int minRegionSize;
    private double minIntersectionLength;
    private double minRegionAngleDifference;
    private boolean addIntersectionsToRegions;

    public IntersectionEstimationParameters() {
        this.setDefaultParameters();
    }

    public IntersectionEstimationParameters(IntersectionEstimationParameters other) {
        this.set(other);
    }

    public void setDefaultParameters() {
        this.maxDistanceToRegion = 0.1;
        this.minRegionSize = 50;
        this.minIntersectionLength = 0.06;
        this.minRegionAngleDifference = Math.toRadians(15.0);
        this.addIntersectionsToRegions = true;
    }

    public void set(IntersectionEstimationParameters other) {
        this.maxDistanceToRegion = other.maxDistanceToRegion;
        this.minRegionSize = other.minRegionSize;
        this.minIntersectionLength = other.minIntersectionLength;
        this.minRegionAngleDifference = other.minRegionAngleDifference;
        this.addIntersectionsToRegions = other.addIntersectionsToRegions;
    }

    public void setMaxDistanceToRegion(double maxDistanceToRegion) {
        this.maxDistanceToRegion = maxDistanceToRegion;
    }

    public void setMinRegionSize(int minRegionSize) {
        this.minRegionSize = minRegionSize;
    }

    public void setMinIntersectionLength(double minIntersectionLength) {
        this.minIntersectionLength = minIntersectionLength;
    }

    public void setMinRegionAngleDifference(double minRegionAngleDifference) {
        this.minRegionAngleDifference = minRegionAngleDifference;
    }

    public void setAddIntersectionsToRegions(boolean addIntersectionsToRegions) {
        this.addIntersectionsToRegions = addIntersectionsToRegions;
    }

    public double getMaxDistanceToRegion() {
        return this.maxDistanceToRegion;
    }

    public int getMinRegionSize() {
        return this.minRegionSize;
    }

    public double getMinIntersectionLength() {
        return this.minIntersectionLength;
    }

    public double getMinRegionAngleDifference() {
        return this.minRegionAngleDifference;
    }

    public boolean isAddIntersectionsToRegions() {
        return this.addIntersectionsToRegions;
    }

    public String toString() {
        return "maxDistanceToRegion: " + this.maxDistanceToRegion + ", minRegionSize: " + this.minRegionSize + ", minIntersectionLength: " + this.minIntersectionLength + ", minRegionAngleDifference: " + this.minRegionAngleDifference + ", addIntersectionsToRegions: " + this.addIntersectionsToRegions;
    }

    public static IntersectionEstimationParameters parse(String parametersAsString) {
        parametersAsString = parametersAsString.replace(",", "");
        Scanner scanner = new Scanner(parametersAsString);
        while (!scanner.hasNextDouble()) {
            scanner.next();
        }
        double maxDistanceToRegion = scanner.nextDouble();
        while (!scanner.hasNextInt()) {
            scanner.next();
        }
        int minRegionSize = scanner.nextInt();
        while (!scanner.hasNextDouble()) {
            scanner.next();
        }
        double minIntersectionLength = scanner.nextDouble();
        while (!scanner.hasNextDouble()) {
            scanner.next();
        }
        double minRegionAngleDifference = scanner.nextDouble();
        while (!scanner.hasNextBoolean()) {
            scanner.next();
        }
        boolean addIntersectionsToRegions = scanner.nextBoolean();
        scanner.close();
        IntersectionEstimationParameters parameters = new IntersectionEstimationParameters();
        parameters.setMaxDistanceToRegion(maxDistanceToRegion);
        parameters.setMinRegionSize(minRegionSize);
        parameters.setMinIntersectionLength(minIntersectionLength);
        parameters.setMinRegionAngleDifference(minRegionAngleDifference);
        parameters.setAddIntersectionsToRegions(addIntersectionsToRegions);
        return parameters;
    }
}

