/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotEnvironmentAwareness.perceptionSuite;

import controller_msgs.msg.dds.StereoVisionPointCloudMessage;
import perception_msgs.msg.dds.NormalEstimationParametersMessage;
import perception_msgs.msg.dds.OcTreeKeyListMessage;
import perception_msgs.msg.dds.PlanarRegionSegmentationParametersMessage;
import perception_msgs.msg.dds.PlanarRegionsListMessage;
import perception_msgs.msg.dds.PolygonizerParametersMessage;
import perception_msgs.msg.dds.REASensorDataFilterParametersMessage;
import perception_msgs.msg.dds.REAStateRequestMessage;
import us.ihmc.communication.PerceptionAPI;
import us.ihmc.communication.ROS2Tools;
import us.ihmc.communication.packets.PlanarRegionMessageConverter;
import us.ihmc.jOctoMap.ocTree.NormalOcTree;
import us.ihmc.messager.Messager;
import us.ihmc.pubsub.DomainFactory;
import us.ihmc.robotEnvironmentAwareness.communication.REACommunicationProperties;
import us.ihmc.robotEnvironmentAwareness.communication.REAModuleAPI;
import us.ihmc.robotEnvironmentAwareness.communication.converters.OcTreeMessageConverter;
import us.ihmc.robotEnvironmentAwareness.communication.converters.REAParametersMessageHelper;
import us.ihmc.robotEnvironmentAwareness.ros.REAModuleROS2Subscription;
import us.ihmc.robotEnvironmentAwareness.ros.REASourceType;
import us.ihmc.robotEnvironmentAwareness.updaters.REANetworkProvider;
import us.ihmc.robotEnvironmentAwareness.updaters.RegionFeaturesProvider;
import us.ihmc.robotics.geometry.PlanarRegionsList;
import us.ihmc.ros2.NewMessageListener;
import us.ihmc.ros2.ROS2Node;
import us.ihmc.ros2.ROS2NodeInterface;
import us.ihmc.ros2.ROS2PublisherBasics;
import us.ihmc.ros2.ROS2QosProfile;
import us.ihmc.ros2.ROS2Topic;

public class RealSenseREANetworkProvider
implements REANetworkProvider {
    private final ROS2PublisherBasics<PlanarRegionsListMessage> stereoRegionPublisher;
    private final ROS2PublisherBasics<OcTreeKeyListMessage> ocTreePublisher;
    private final ROS2Node ros2Node;
    private final ROS2Topic<?> inputTopic;
    private PlanarRegionsListMessage lastPlanarRegionsListMessage;

    public RealSenseREANetworkProvider(ROS2Topic inputTopic, ROS2Topic stereoOutputTopic) {
        this(ROS2Tools.createROS2Node((DomainFactory.PubSubImplementation)DomainFactory.PubSubImplementation.FAST_RTPS, (String)"REA_module"), inputTopic, stereoOutputTopic);
    }

    public RealSenseREANetworkProvider(ROS2Node ros2Node, ROS2Topic inputTopic, ROS2Topic stereoOutputTopic) {
        this.ros2Node = ros2Node;
        this.inputTopic = inputTopic;
        this.stereoRegionPublisher = ros2Node.createPublisher(stereoOutputTopic.withTypeName(PlanarRegionsListMessage.class));
        this.ocTreePublisher = ros2Node.createPublisher(stereoOutputTopic.withTypeName(OcTreeKeyListMessage.class));
    }

    @Override
    public void registerMessager(Messager messager) {
        this.ros2Node.createSubscription(this.inputTopic.withTypeName(NormalEstimationParametersMessage.class), s -> messager.submitMessage(REAModuleAPI.NormalEstimationParameters, (Object)REAParametersMessageHelper.convertFromMessage((NormalEstimationParametersMessage)s.takeNextData())));
        this.ros2Node.createSubscription(this.inputTopic.withTypeName(PlanarRegionSegmentationParametersMessage.class), s -> messager.submitMessage(REAModuleAPI.PlanarRegionsSegmentationParameters, (Object)REAParametersMessageHelper.convertFromMessage((PlanarRegionSegmentationParametersMessage)s.takeNextData())));
        this.ros2Node.createSubscription(this.inputTopic.withTypeName(PolygonizerParametersMessage.class), s -> messager.submitMessage(REAModuleAPI.PlanarRegionsPolygonizerParameters, (Object)((PolygonizerParametersMessage)s.takeNextData())));
    }

    @Override
    public void update(RegionFeaturesProvider regionFeaturesProvider, boolean planarRegionsHaveBeenUpdated, NormalOcTree ocTree) {
        if (regionFeaturesProvider.getPlanarRegionsList() != null && !regionFeaturesProvider.getPlanarRegionsList().isEmpty()) {
            if (planarRegionsHaveBeenUpdated) {
                this.lastPlanarRegionsListMessage = PlanarRegionMessageConverter.convertToPlanarRegionsListMessage((PlanarRegionsList)regionFeaturesProvider.getPlanarRegionsList());
            }
            this.stereoRegionPublisher.publish((Object)this.lastPlanarRegionsListMessage);
        }
        if (ocTree != null && ocTree.getRoot() != null) {
            OcTreeKeyListMessage ocTreeMessage = OcTreeMessageConverter.createOcTreeDataMessage(ocTree);
            this.ocTreePublisher.publish((Object)ocTreeMessage);
        }
    }

    @Override
    public void publishCurrentState() {
    }

    @Override
    public void registerStereoVisionPointCloudHandler(NewMessageListener<StereoVisionPointCloudMessage> stereoVisionPointCloudHandler) {
        this.ros2Node.createSubscription(PerceptionAPI.D435_POINT_CLOUD, stereoVisionPointCloudHandler);
    }

    @Override
    public void registerStereoVisionPointCloudHandler(Messager messager, NewMessageListener<StereoVisionPointCloudMessage> stereoVisionPointCloudHandler) {
        new REAModuleROS2Subscription<StereoVisionPointCloudMessage>((ROS2NodeInterface)this.ros2Node, messager, REASourceType.STEREO_POINT_CLOUD, StereoVisionPointCloudMessage.class, stereoVisionPointCloudHandler, ROS2QosProfile.BEST_EFFORT());
    }

    @Override
    public void registerCustomRegionsHandler(NewMessageListener<PlanarRegionsListMessage> customRegionsHandler) {
        this.ros2Node.createSubscription(REACommunicationProperties.subscriberCustomRegionsTopicName.withTypeName(PlanarRegionsListMessage.class), customRegionsHandler);
    }

    @Override
    public void registerREAStateRequestHandler(NewMessageListener<REAStateRequestMessage> requestHandler) {
        this.ros2Node.createSubscription(this.inputTopic.withTypeName(REAStateRequestMessage.class), requestHandler);
    }

    @Override
    public void registerREASensorDataFilterParametersHandler(NewMessageListener<REASensorDataFilterParametersMessage> parametersHandler) {
        this.ros2Node.createSubscription(this.inputTopic.withTypeName(REASensorDataFilterParametersMessage.class), parametersHandler);
    }

    @Override
    public void stop() {
        this.ros2Node.destroy();
    }
}

