/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotEnvironmentAwareness.geometry;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.robotEnvironmentAwareness.geometry.ConcaveHull;

public class ConcaveHullCollection
implements Iterable<ConcaveHull> {
    private final Set<ConcaveHull> concaveHulls = new HashSet<ConcaveHull>();

    public ConcaveHullCollection() {
    }

    public ConcaveHullCollection(ConcaveHull concaveHull) {
        this.add(concaveHull);
    }

    public ConcaveHullCollection(ConcaveHull ... concaveHulls) {
        this.addAll(concaveHulls);
    }

    public ConcaveHullCollection(List<? extends Point2DReadOnly> concaveHullVertices) {
        this.add(concaveHullVertices);
    }

    public ConcaveHullCollection(ConcaveHullCollection other) {
        other.forEach(concaveHull -> this.add(new ConcaveHull((ConcaveHull)concaveHull)));
    }

    public boolean add(List<? extends Point2DReadOnly> newConcaveHullVertices) {
        if (newConcaveHullVertices == null) {
            return false;
        }
        return this.add(new ConcaveHull(newConcaveHullVertices));
    }

    public boolean add(ConcaveHull newConcaveHull) {
        if (newConcaveHull == null) {
            return false;
        }
        return this.concaveHulls.add(newConcaveHull);
    }

    public boolean addAll(ConcaveHull ... newConcaveHulls) {
        if (newConcaveHulls == null) {
            return false;
        }
        boolean modified = false;
        for (ConcaveHull concaveHull : newConcaveHulls) {
            modified |= this.add(concaveHull);
        }
        return modified;
    }

    public boolean addAll(ConcaveHullCollection other) {
        if (other == null) {
            return false;
        }
        return this.concaveHulls.addAll(other.concaveHulls);
    }

    public boolean remove(ConcaveHull newConcaveHull) {
        return this.concaveHulls.remove(newConcaveHull);
    }

    public int getNumberOfConcaveHulls() {
        return this.concaveHulls.size();
    }

    public boolean isEmpty() {
        return this.concaveHulls.isEmpty();
    }

    public Collection<ConcaveHull> getConcaveHulls() {
        return this.concaveHulls;
    }

    @Override
    public Iterator<ConcaveHull> iterator() {
        return this.concaveHulls.iterator();
    }

    public boolean equals(Object object) {
        if (object instanceof ConcaveHullCollection) {
            return this.concaveHulls.equals(((ConcaveHullCollection)object).concaveHulls);
        }
        return false;
    }

    public int hashCode() {
        int hashCode = 1;
        for (ConcaveHull hull : this) {
            hashCode = 31 * hashCode + (hull == null ? 0 : hull.hashCode());
        }
        return hashCode;
    }
}

