/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotEnvironmentAwareness.fusion.tools;

import boofcv.struct.calib.CameraPinholeBrown;
import gnu.trove.list.array.TIntArrayList;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.bytedeco.javacpp.indexer.UByteRawIndexer;
import org.bytedeco.opencv.global.opencv_core;
import org.bytedeco.opencv.global.opencv_imgproc;
import org.bytedeco.opencv.global.opencv_ximgproc;
import org.bytedeco.opencv.opencv_core.Mat;
import org.bytedeco.opencv.opencv_ximgproc.SuperpixelSLIC;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionBasics;
import us.ihmc.robotEnvironmentAwareness.fusion.data.LidarImageFusionData;
import us.ihmc.robotEnvironmentAwareness.fusion.data.SegmentationRawData;
import us.ihmc.robotEnvironmentAwareness.fusion.parameters.ImageSegmentationParameters;
import us.ihmc.robotEnvironmentAwareness.fusion.parameters.SegmentationRawDataFilteringParameters;
import us.ihmc.robotEnvironmentAwareness.fusion.tools.PointCloudProjectionHelper;

public class LidarImageFusionDataFactory {
    private static final boolean enableDisplaySegmentedContour = true;
    private static final boolean enableDisplayProjectedPointCloud = true;
    private final int bufferedImageType = 1;
    private final int matType = opencv_core.CV_8UC3;
    private int imageWidth;
    private int imageHeight;
    private BufferedImage segmentedContour;
    private BufferedImage projectedPointCloud;
    private final AtomicReference<CameraPinholeBrown> intrinsicParameters = new AtomicReference<CameraPinholeBrown>(PointCloudProjectionHelper.multisenseOnCartIntrinsicParameters);
    private final AtomicReference<ImageSegmentationParameters> imageSegmentationParameters = new AtomicReference<Object>(null);
    private final AtomicReference<SegmentationRawDataFilteringParameters> segmentationRawDataFilteringParameters = new AtomicReference<Object>(null);
    private final AtomicReference<Point3D> cameraPosition = new AtomicReference<Point3D>(new Point3D());
    private final AtomicReference<Quaternion> cameraOrientation = new AtomicReference<Quaternion>(new Quaternion());

    public LidarImageFusionData createLidarImageFusionData(Point3D[] pointCloud, int[] colors, BufferedImage bufferedImage) {
        this.imageWidth = bufferedImage.getWidth();
        this.imageHeight = bufferedImage.getHeight();
        this.segmentedContour = new BufferedImage(this.imageWidth, this.imageHeight, 1);
        this.projectedPointCloud = new BufferedImage(this.imageWidth, this.imageHeight, 1);
        int[] labels = this.calculateNewLabelsSLIC(bufferedImage);
        List<SegmentationRawData> fusionDataSegments = this.createListOfSegmentationRawData(labels, pointCloud, colors);
        return new LidarImageFusionData(fusionDataSegments, this.imageWidth, this.imageHeight);
    }

    private int[] calculateNewLabelsSLIC(BufferedImage bufferedImage) {
        int pixelSize = this.imageSegmentationParameters.get().getPixelSize();
        double ruler = this.imageSegmentationParameters.get().getPixelRuler();
        int iterate = this.imageSegmentationParameters.get().getIterate();
        boolean enableConnectivity = true;
        int elementSize = this.imageSegmentationParameters.get().getMinElementSize();
        Mat imageMat = this.convertBufferedImageToMat(bufferedImage);
        Mat convertedMat = new Mat();
        opencv_imgproc.cvtColor((Mat)imageMat, (Mat)convertedMat, (int)41);
        SuperpixelSLIC slic = opencv_ximgproc.createSuperpixelSLIC((Mat)convertedMat, (int)100, (int)pixelSize, (float)((float)ruler));
        slic.iterate(iterate);
        if (enableConnectivity) {
            slic.enforceLabelConnectivity(elementSize);
        }
        Mat labelMat = new Mat();
        slic.getLabels(labelMat);
        int[] labels = new int[this.imageWidth * this.imageHeight];
        for (int i = 0; i < labels.length; ++i) {
            labels[i] = labelMat.getIntBuffer().get(i);
        }
        return labels;
    }

    private List<SegmentationRawData> createListOfSegmentationRawData(int[] labels, Point3D[] pointCloud, int[] colors) {
        int i;
        Point3D point;
        int i2;
        if (labels.length != this.imageWidth * this.imageHeight) {
            throw new RuntimeException("newLabels length is different with size of image " + labels.length + ", (w)" + this.imageWidth + ", (h)" + this.imageHeight);
        }
        ArrayList<SegmentationRawData> fusionDataSegments = new ArrayList<SegmentationRawData>();
        TIntArrayList labelList = new TIntArrayList(labels);
        int numberOfLabels = labelList.max() + 1;
        for (i2 = 0; i2 < numberOfLabels; ++i2) {
            fusionDataSegments.add(new SegmentationRawData(i2));
        }
        for (i2 = 0; i2 < pointCloud.length && (point = pointCloud[i2]) != null; ++i2) {
            int[] pixel = PointCloudProjectionHelper.projectMultisensePointCloudOnImage((Point3DBasics)point, this.intrinsicParameters.get(), (Point3DBasics)this.cameraPosition.get(), (QuaternionBasics)this.cameraOrientation.get());
            if (pixel[0] < 0 || pixel[0] >= this.imageWidth || pixel[1] < 0 || pixel[1] >= this.imageHeight) continue;
            int arrayIndex = this.getArrayIndex(pixel[0], pixel[1]);
            int label = labels[arrayIndex];
            ((SegmentationRawData)fusionDataSegments.get(label)).addPoint(new Point3D((Tuple3DReadOnly)point));
            this.projectedPointCloud.setRGB(pixel[0], pixel[1], colors[i2]);
        }
        for (int u = 1; u < this.imageWidth - 1; ++u) {
            for (int v = 1; v < this.imageHeight - 1; ++v) {
                int curLabel = labels[this.getArrayIndex(u, v)];
                int[] labelsOfAdjacentPixels = new int[]{labels[this.getArrayIndex(u, v - 1)], labels[this.getArrayIndex(u, v + 1)], labels[this.getArrayIndex(u - 1, v)], labels[this.getArrayIndex(u + 1, v)]};
                for (int labelOfAdjacentPixel : labelsOfAdjacentPixels) {
                    if (curLabel == labelOfAdjacentPixel || ((SegmentationRawData)fusionDataSegments.get(curLabel)).contains(labelOfAdjacentPixel)) continue;
                    ((SegmentationRawData)fusionDataSegments.get(curLabel)).addAdjacentSegmentLabel(labelOfAdjacentPixel);
                }
            }
        }
        for (SegmentationRawData fusionDataSegment : fusionDataSegments) {
            if (this.segmentationRawDataFilteringParameters.get().isEnableFilterFlyingPoint()) {
                fusionDataSegment.filteringFlyingPoints(this.segmentationRawDataFilteringParameters.get().getFlyingPointThreshold(), this.segmentationRawDataFilteringParameters.get().getMinimumNumberOfFlyingPointNeighbors());
            }
            fusionDataSegment.update();
        }
        int[] totalU = new int[numberOfLabels];
        int[] totalV = new int[numberOfLabels];
        int[] numberOfPixels = new int[numberOfLabels];
        for (i = 0; i < this.imageWidth; ++i) {
            for (int j = 0; j < this.imageHeight; ++j) {
                int label;
                int n = label = labels[this.getArrayIndex(i, j)];
                totalU[n] = totalU[n] + i;
                int n2 = label;
                totalV[n2] = totalV[n2] + j;
                int n3 = label;
                numberOfPixels[n3] = numberOfPixels[n3] + 1;
            }
        }
        for (i = 0; i < numberOfLabels; ++i) {
            ((SegmentationRawData)fusionDataSegments.get(i)).setSegmentCenter(totalU[i] / numberOfPixels[i], totalV[i] / numberOfPixels[i]);
        }
        return fusionDataSegments;
    }

    private Mat convertBufferedImageToMat(BufferedImage bufferedImage) {
        Mat imageMat = new Mat(bufferedImage.getHeight(), bufferedImage.getWidth(), this.matType);
        UByteRawIndexer indexer = (UByteRawIndexer)imageMat.createIndexer();
        for (int y = 0; y < bufferedImage.getHeight(); ++y) {
            for (int x = 0; x < bufferedImage.getWidth(); ++x) {
                int rgb = bufferedImage.getRGB(x, y);
                byte r = (byte)(rgb >> 0 & 0xFF);
                byte g = (byte)(rgb >> 8 & 0xFF);
                byte b = (byte)(rgb >> 16 & 0xFF);
                indexer.put((long)y, (long)x, 0L, (int)r);
                indexer.put((long)y, (long)x, 1L, (int)g);
                indexer.put((long)y, (long)x, 2L, (int)b);
            }
        }
        indexer.release();
        return imageMat;
    }

    private int getArrayIndex(int u, int v) {
        return u + v * this.imageWidth;
    }

    public BufferedImage getSegmentedContourBufferedImage() {
        return this.segmentedContour;
    }

    public BufferedImage getProjectedPointCloudBufferedImage() {
        return this.projectedPointCloud;
    }

    public void setIntrinsicParameters(CameraPinholeBrown intrinsicParameters) {
        this.intrinsicParameters.set(intrinsicParameters);
    }

    public void setImageSegmentationParameters(ImageSegmentationParameters imageSegmentationParameters) {
        this.imageSegmentationParameters.set(imageSegmentationParameters);
    }

    public void setSegmentationRawDataFilteringParameters(SegmentationRawDataFilteringParameters segmentationRawDataFilteringParameters) {
        this.segmentationRawDataFilteringParameters.set(segmentationRawDataFilteringParameters);
    }

    public void setCameraPose(Point3D position, Quaternion orientation) {
        this.cameraPosition.set(position);
        this.cameraOrientation.set(orientation);
    }
}

