/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotEnvironmentAwareness.fusion.objectDetection;

import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicReference;
import javafx.collections.ObservableList;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.paint.Color;
import javafx.scene.shape.MeshView;
import perception_msgs.msg.dds.DoorParameterPacket;
import us.ihmc.communication.ROS2Tools;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.javaFXToolkit.shapes.JavaFXMultiColorMeshBuilder;
import us.ihmc.log.LogTools;
import us.ihmc.pubsub.subscriber.Subscriber;
import us.ihmc.ros2.ROS2Node;

public class DetectedObjectViewer {
    private final Group root = new Group();
    protected final ObservableList<Node> children = this.root.getChildren();
    private final AtomicReference<MeshView> meshToRender = new AtomicReference<Object>(null);
    private final AtomicReference<Boolean> clear = new AtomicReference<Boolean>(false);
    private static final double doorEdgeVizThickness = 0.01;
    private static final double doorHingeVizRadius = 0.03;
    private static final Color doorEdgeColor = Color.PINK;
    private static final Color doorHingeColor = Color.GREEN;

    public DetectedObjectViewer(ROS2Node ros2Node) {
        ros2Node.createSubscription(ROS2Tools.IHMC_ROOT.withTypeName(DoorParameterPacket.class), this::renderDoor);
    }

    public void renderDoor(Subscriber<DoorParameterPacket> subscriber) {
        DoorParameterPacket message = (DoorParameterPacket)subscriber.takeNextData();
        double doorHeight = message.getDoorHeight();
        Point3D hingePoint = message.getHingedPointOnGround();
        Point3D endPoint = message.getEndPointOnGround();
        LogTools.info((String)("doorHeight " + doorHeight));
        LogTools.info((String)("hingePoint " + hingePoint));
        LogTools.info((String)("endPoint " + endPoint));
        ArrayList<Point3D> doorVertices = new ArrayList<Point3D>();
        doorVertices.add(hingePoint);
        doorVertices.add(new Point3D(hingePoint.getX(), hingePoint.getY(), hingePoint.getZ() + doorHeight));
        doorVertices.add(new Point3D(endPoint.getX(), endPoint.getY(), endPoint.getZ() + doorHeight));
        doorVertices.add(endPoint);
        JavaFXMultiColorMeshBuilder meshBuilder = new JavaFXMultiColorMeshBuilder();
        meshBuilder.addMultiLine(doorVertices, 0.01, doorEdgeColor, true);
        meshBuilder.addSphere(0.03, (Tuple3DReadOnly)hingePoint, doorHingeColor);
        MeshView doorMeshView = new MeshView(meshBuilder.generateMesh());
        doorMeshView.setMaterial(meshBuilder.generateMaterial());
        this.meshToRender.set(doorMeshView);
    }

    public void render() {
        MeshView newScanMeshView = this.meshToRender.getAndSet(null);
        if (this.clear.getAndSet(false).booleanValue()) {
            this.children.clear();
        }
        if (newScanMeshView != null) {
            this.children.add((Object)newScanMeshView);
        }
    }

    public void clear() {
        this.clear.set(true);
    }

    public Node getRoot() {
        return this.root;
    }
}

