/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotEnvironmentAwareness.fusion.objectDetection;

import boofcv.struct.calib.CameraPinholeBrown;
import controller_msgs.msg.dds.StereoVisionPointCloudMessage;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import sensor_msgs.msg.dds.RegionOfInterest;
import us.ihmc.commons.MathTools;
import us.ihmc.communication.ROS2Tools;
import us.ihmc.communication.packets.Packet;
import us.ihmc.communication.packets.StereoPointCloudCompression;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.interfaces.Point2DBasics;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.log.LogTools;
import us.ihmc.robotEnvironmentAwareness.fusion.tools.PointCloudProjectionHelper;
import us.ihmc.ros2.ROS2Node;
import us.ihmc.ros2.ROS2PublisherBasics;
import us.ihmc.ros2.ROS2TopicNameTools;

public abstract class AbstractObjectParameterCalculator<T extends Packet<?>> {
    private static final CameraPinholeBrown intrinsicParameters = PointCloudProjectionHelper.multisenseOnCartIntrinsicParameters;
    protected final List<Point3DBasics> pointCloudToCalculate;
    protected final RegionOfInterest objectROI = new RegionOfInterest();
    private final Class<T> messageType;
    private final ROS2PublisherBasics<T> packetPublisher;
    protected final AtomicReference<T> newPacket = new AtomicReference<Object>(null);

    public AbstractObjectParameterCalculator(ROS2Node ros2Node, Class<T> messageType) {
        this.messageType = messageType;
        this.pointCloudToCalculate = new ArrayList<Point3DBasics>();
        this.packetPublisher = ros2Node.createPublisher(ROS2Tools.IHMC_ROOT.withTypeName(messageType));
        this.newPacket.set((Packet)ROS2TopicNameTools.newMessageInstance(messageType));
    }

    public void trimPointCloudInROI(StereoVisionPointCloudMessage pointCloudMessage, final RegionOfInterest roi) {
        StereoPointCloudCompression.decompressPointCloud((StereoVisionPointCloudMessage)pointCloudMessage, (StereoPointCloudCompression.PointCoordinateConsumer)new StereoPointCloudCompression.PointCoordinateConsumer(){

            public void accept(double x, double y, double z) {
                Point3D point = new Point3D(x, y, z);
                Point2D projectedPixel = new Point2D();
                PointCloudProjectionHelper.projectMultisensePointCloudOnImage((Point3DBasics)point, (Point2DBasics)projectedPixel, intrinsicParameters);
                if (MathTools.intervalContains((double)projectedPixel.getX(), (double)roi.getXOffset(), (double)(roi.getXOffset() + roi.getWidth())) && MathTools.intervalContains((double)projectedPixel.getY(), (double)roi.getYOffset(), (double)(roi.getYOffset() + roi.getHeight()))) {
                    AbstractObjectParameterCalculator.this.pointCloudToCalculate.add((Point3DBasics)point);
                }
            }
        });
        this.objectROI.set(roi);
        LogTools.info((String)("total number of points in roi " + this.pointCloudToCalculate.size()));
    }

    public void initialize() {
        this.newPacket.set((Packet)ROS2TopicNameTools.newMessageInstance(this.messageType));
        this.pointCloudToCalculate.clear();
    }

    public void publish() {
        this.packetPublisher.publish((Object)((Packet)this.newPacket.get()));
    }

    public abstract void calculate(RegionOfInterest ... var1);
}

