/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotEnvironmentAwareness.fusion.data;

import java.util.ArrayList;
import java.util.Random;
import java.util.concurrent.atomic.AtomicReference;
import javafx.collections.ObservableList;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.paint.Color;
import javafx.scene.shape.MeshView;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.javaFXToolkit.shapes.JavaFXMultiColorMeshBuilder;
import us.ihmc.javaFXToolkit.shapes.TextureColorAdaptivePalette;
import us.ihmc.javaFXToolkit.shapes.TextureColorPalette;
import us.ihmc.messager.javafx.SharedMemoryJavaFXMessager;
import us.ihmc.robotEnvironmentAwareness.communication.LidarImageFusionAPI;
import us.ihmc.robotEnvironmentAwareness.fusion.data.LidarImageFusionData;
import us.ihmc.robotEnvironmentAwareness.fusion.data.SegmentationNodeData;
import us.ihmc.robotEnvironmentAwareness.fusion.data.SegmentationRawData;
import us.ihmc.robotEnvironmentAwareness.planarRegion.PlanarRegionSegmentationRawData;

public class LidarImageFusionDataViewer {
    private final AtomicReference<LidarImageFusionData> lidarImageFusionDataToRender;
    protected final JavaFXMultiColorMeshBuilder meshBuilder;
    private final AtomicReference<MeshView> meshToRender = new AtomicReference<Object>(null);
    private final Group root = new Group();
    protected final ObservableList<Node> children = this.root.getChildren();
    private final AtomicReference<Boolean> clear = new AtomicReference<Boolean>(false);

    public LidarImageFusionDataViewer(SharedMemoryJavaFXMessager messager) {
        this.lidarImageFusionDataToRender = messager.createInput(LidarImageFusionAPI.FusionDataState, null);
        this.meshBuilder = new JavaFXMultiColorMeshBuilder((TextureColorPalette)new TextureColorAdaptivePalette(2048));
        messager.addTopicListener(LidarImageFusionAPI.ShowFusionData, content -> this.unpackFusionData());
    }

    private void unpackFusionData() {
        int i;
        this.clear();
        double lineWidth = 0.01;
        this.meshBuilder.clear();
        LidarImageFusionData lidarImageFusionData = this.lidarImageFusionDataToRender.get();
        if (lidarImageFusionData == null) {
            return;
        }
        int numberOfSegment = lidarImageFusionData.getNumberOfImageSegments();
        ArrayList<PlanarRegionSegmentationRawData> planarRegionSegmentationRawDataList = new ArrayList<PlanarRegionSegmentationRawData>();
        for (i = 0; i < numberOfSegment; ++i) {
            SegmentationRawData data = lidarImageFusionData.getFusionDataSegment(i);
            SegmentationNodeData segmentationNodeData = new SegmentationNodeData(data);
            PlanarRegionSegmentationRawData planarRegionSegmentationRawData = new PlanarRegionSegmentationRawData(i, (Vector3DReadOnly)segmentationNodeData.getNormal(), (Point3DReadOnly)segmentationNodeData.getCenter(), segmentationNodeData.getPointsInSegment());
            planarRegionSegmentationRawDataList.add(planarRegionSegmentationRawData);
        }
        for (i = 0; i < numberOfSegment; ++i) {
            int randomID = new Random().nextInt();
            Color regionColor = this.getRegionColor(randomID);
            SegmentationRawData data = lidarImageFusionData.getFusionDataSegment(i);
            Point3D center = data.getCenter();
            Vector3D normal = data.getNormal();
            Point3D centerEnd = new Point3D((Tuple3DReadOnly)normal);
            centerEnd.scaleAdd(0.1, (Tuple3DReadOnly)center);
            if (data.isSparse()) {
                regionColor = Color.rgb((int)0, (int)0, (int)0);
            }
            this.meshBuilder.addLine((Tuple3DReadOnly)center, (Tuple3DReadOnly)centerEnd, lineWidth, regionColor);
            for (Point3D point : data.getPoints()) {
                this.meshBuilder.addTetrahedron(0.02, (Tuple3DReadOnly)point, regionColor);
            }
        }
        MeshView scanMeshView = new MeshView(this.meshBuilder.generateMesh());
        scanMeshView.setMaterial(this.meshBuilder.generateMaterial());
        this.meshToRender.set(scanMeshView);
        this.meshBuilder.clear();
    }

    public void render() {
        MeshView newScanMeshView = this.meshToRender.getAndSet(null);
        if (this.clear.getAndSet(false).booleanValue()) {
            this.children.clear();
        }
        if (newScanMeshView != null) {
            this.children.add((Object)newScanMeshView);
        }
    }

    public void clear() {
        this.clear.set(true);
    }

    public Node getRoot() {
        return this.root;
    }

    private Color getRegionColor(int regionId) {
        java.awt.Color awtColor = new java.awt.Color(regionId);
        return Color.rgb((int)awtColor.getRed(), (int)awtColor.getGreen(), (int)awtColor.getBlue());
    }
}

