/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotEnvironmentAwareness.fusion;

import boofcv.struct.calib.CameraPinholeBrown;
import controller_msgs.msg.dds.StereoVisionPointCloudMessage;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import perception_msgs.msg.dds.Image32;
import perception_msgs.msg.dds.IntrinsicParametersMessage;
import perception_msgs.msg.dds.LidarScanMessage;
import perception_msgs.msg.dds.PlanarRegionsListMessage;
import perception_msgs.msg.dds.VideoPacket;
import us.ihmc.communication.ROS2Tools;
import us.ihmc.communication.producers.JPEGDecompressor;
import us.ihmc.communication.util.NetworkPorts;
import us.ihmc.log.LogTools;
import us.ihmc.messager.Messager;
import us.ihmc.messager.javafx.SharedMemoryJavaFXMessager;
import us.ihmc.pubsub.subscriber.Subscriber;
import us.ihmc.robotEnvironmentAwareness.communication.KryoMessager;
import us.ihmc.robotEnvironmentAwareness.communication.LidarImageFusionAPI;
import us.ihmc.robotEnvironmentAwareness.communication.REACommunicationProperties;
import us.ihmc.robotEnvironmentAwareness.communication.REAModuleAPI;
import us.ihmc.robotEnvironmentAwareness.fusion.StereoREAModule;
import us.ihmc.robotEnvironmentAwareness.fusion.objectDetection.FusionSensorObjectDetectionManager;
import us.ihmc.robotEnvironmentAwareness.fusion.objectDetection.ObjectType;
import us.ihmc.robotEnvironmentAwareness.fusion.tools.ImageVisualizationHelper;
import us.ihmc.robotEnvironmentAwareness.updaters.REAModuleStateReporter;
import us.ihmc.robotEnvironmentAwareness.updaters.REANetworkProvider;
import us.ihmc.robotEnvironmentAwareness.updaters.REAPlanarRegionPublicNetworkProvider;
import us.ihmc.ros2.NewMessageListener;
import us.ihmc.ros2.ROS2Callback;
import us.ihmc.ros2.ROS2Node;
import us.ihmc.ros2.ROS2NodeInterface;
import us.ihmc.tools.thread.ExceptionHandlingThreadScheduler;

public class LidarImageFusionProcessorCommunicationModule {
    private final Messager messager;
    private final ROS2Node ros2Node;
    private final REAModuleStateReporter moduleStateReporter;
    private final StereoREAModule stereoREAModule;
    private final FusionSensorObjectDetectionManager objectDetectionManager;
    private final AtomicReference<String> socketHostIPAddress;
    private final AtomicReference<BufferedImage> latestBufferedImage = new AtomicReference<Object>(null);
    private final AtomicReference<List<ObjectType>> selectedObjecTypes;
    private final JPEGDecompressor jpegDecompressor = new JPEGDecompressor();
    private final ExceptionHandlingThreadScheduler scheduler;
    private static final int BUFFER_THREAD_PERIOD_MILLISECONDS = 1500;

    private LidarImageFusionProcessorCommunicationModule(ROS2Node ros2Node, REANetworkProvider networkProvider, Messager reaMessager, SharedMemoryJavaFXMessager messager) {
        this.messager = messager;
        this.ros2Node = ros2Node;
        this.moduleStateReporter = new REAModuleStateReporter(reaMessager);
        this.stereoREAModule = new StereoREAModule(networkProvider, reaMessager, messager);
        networkProvider.registerMessager(reaMessager);
        networkProvider.registerLidarScanHandler((NewMessageListener<LidarScanMessage>)((NewMessageListener)this::dispatchLidarScanMessage));
        networkProvider.registerStereoVisionPointCloudHandler((NewMessageListener<StereoVisionPointCloudMessage>)((NewMessageListener)this::dispatchStereoVisionPointCloudMessage));
        networkProvider.registerCustomRegionsHandler((NewMessageListener<PlanarRegionsListMessage>)((NewMessageListener)this::dispatchCustomPlanarRegion));
        new ROS2Callback((ROS2NodeInterface)ros2Node, Image32.class, ROS2Tools.IHMC_ROOT, this::dispatchImage32);
        new ROS2Callback((ROS2NodeInterface)ros2Node, VideoPacket.class, ROS2Tools.IHMC_ROOT, this::dispatchVideoPacket);
        this.objectDetectionManager = new FusionSensorObjectDetectionManager(ros2Node, messager);
        messager.addTopicListener(LidarImageFusionAPI.RequestSocketConnection, content -> this.connect());
        messager.addTopicListener(LidarImageFusionAPI.RequestObjectDetection, content -> this.request());
        this.selectedObjecTypes = messager.createInput(LidarImageFusionAPI.SelectedObjecTypes, new ArrayList());
        this.socketHostIPAddress = messager.createInput(LidarImageFusionAPI.ObjectDetectionModuleAddress);
        messager.addTopicListener(LidarImageFusionAPI.RunStereoREA, content -> this.stereoREAModule.singleRun());
        this.scheduler = new ExceptionHandlingThreadScheduler(this.getClass().getSimpleName(), t -> {
            LogTools.error((String)t.getMessage());
            t.printStackTrace();
            LogTools.error((String)"{} is crashing due to an exception.", (Object)Thread.currentThread().getName());
        });
    }

    private void connect() {
        this.objectDetectionManager.connectExternalModule(this.socketHostIPAddress.get());
    }

    private void request() {
        this.objectDetectionManager.requestObjectDetection(this.latestBufferedImage.getAndSet(null), this.selectedObjecTypes.get());
    }

    private void dispatchCustomPlanarRegion(Subscriber<PlanarRegionsListMessage> subscriber) {
        PlanarRegionsListMessage message = (PlanarRegionsListMessage)subscriber.takeNextData();
        this.stereoREAModule.dispatchCustomPlanarRegion(message);
    }

    private void dispatchLidarScanMessage(Subscriber<LidarScanMessage> message) {
        this.moduleStateReporter.registerLidarScanMessage((LidarScanMessage)message.takeNextData());
    }

    private void dispatchStereoVisionPointCloudMessage(Subscriber<StereoVisionPointCloudMessage> subscriber) {
        StereoVisionPointCloudMessage message = (StereoVisionPointCloudMessage)subscriber.takeNextData();
        this.moduleStateReporter.registerStereoVisionPointCloudMessage(message);
        this.objectDetectionManager.updateLatestStereoVisionPointCloudMessage(message);
        this.stereoREAModule.updateLatestStereoVisionPointCloudMessage(message);
    }

    private void dispatchImage32(Image32 message) {
        if (this.messager.isMessagerOpen()) {
            this.messager.submitMessage(LidarImageFusionAPI.ImageState, (Object)new Image32(message));
        }
        this.latestBufferedImage.set(ImageVisualizationHelper.convertImageMessageToBufferedImage(message));
        this.stereoREAModule.updateLatestBufferedImage(this.latestBufferedImage.get());
    }

    private void dispatchVideoPacket(VideoPacket message) {
        BufferedImage bufferedImage = this.jpegDecompressor.decompressJPEGDataToBufferedImage(message.getData().copyArray());
        this.stereoREAModule.updateLatestBufferedImage(bufferedImage);
        this.latestBufferedImage.set(bufferedImage);
        this.messager.submitMessage(LidarImageFusionAPI.CameraPositionState, (Object)message.getPosition());
        this.messager.submitMessage(LidarImageFusionAPI.CameraOrientationState, (Object)message.getOrientation());
        this.messager.submitMessage(LidarImageFusionAPI.CameraIntrinsicParametersState, (Object)LidarImageFusionProcessorCommunicationModule.toIntrinsicParameters(message.getIntrinsicParameters()));
    }

    public void start() throws IOException {
        this.scheduler.schedule((Runnable)this.stereoREAModule, 1500L, TimeUnit.MILLISECONDS);
    }

    public void stop() throws Exception {
        this.messager.closeMessager();
        this.ros2Node.destroy();
        this.objectDetectionManager.close();
        this.scheduler.shutdown();
    }

    public static LidarImageFusionProcessorCommunicationModule createIntraprocessModule(ROS2Node ros2Node, SharedMemoryJavaFXMessager messager) throws IOException {
        KryoMessager kryoMessager = KryoMessager.createIntraprocess(REAModuleAPI.API, NetworkPorts.REA_MODULE_UI_PORT, REACommunicationProperties.getPrivateNetClassList());
        kryoMessager.setAllowSelfSubmit(true);
        kryoMessager.startMessager();
        REAPlanarRegionPublicNetworkProvider networkProvider = new REAPlanarRegionPublicNetworkProvider((ROS2NodeInterface)ros2Node, REACommunicationProperties.outputTopic, REACommunicationProperties.lidarOutputTopic, REACommunicationProperties.stereoOutputTopic, REACommunicationProperties.depthOutputTopic);
        return new LidarImageFusionProcessorCommunicationModule(ros2Node, networkProvider, kryoMessager, messager);
    }

    private static CameraPinholeBrown toIntrinsicParameters(IntrinsicParametersMessage message) {
        CameraPinholeBrown intrinsicParameters = new CameraPinholeBrown();
        intrinsicParameters.width = message.getWidth();
        intrinsicParameters.height = message.getHeight();
        intrinsicParameters.fx = message.getFx();
        intrinsicParameters.fy = message.getFy();
        intrinsicParameters.skew = message.getSkew();
        intrinsicParameters.cx = message.getCx();
        intrinsicParameters.cy = message.getCy();
        if (!message.getRadial().isEmpty()) {
            intrinsicParameters.radial = message.getRadial().toArray();
        }
        intrinsicParameters.t1 = message.getT1();
        intrinsicParameters.t2 = message.getT2();
        return intrinsicParameters;
    }
}

