/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotEnvironmentAwareness;

import java.nio.file.Path;
import java.nio.file.Paths;
import javafx.application.Platform;
import javafx.stage.Stage;
import us.ihmc.javaFXToolkit.ApplicationNoModule;
import us.ihmc.messager.Messager;
import us.ihmc.messager.javafx.SharedMemoryJavaFXMessager;
import us.ihmc.robotEnvironmentAwareness.communication.SegmentationModuleAPI;
import us.ihmc.robotEnvironmentAwareness.ui.PlanarSegmentationUI;
import us.ihmc.robotEnvironmentAwareness.updaters.PlanarSegmentationModule;
import us.ihmc.tools.io.WorkspacePathTools;

public class PlanarSegmentationStandaloneLauncher
extends ApplicationNoModule {
    private static final String SEGMENTATION_CONFIGURATION_FILE_NAME = "atlasSLAMSegmentationModuleConfiguration.txt";
    private Messager messager;
    private PlanarSegmentationUI ui;
    private PlanarSegmentationModule module;

    public void start(Stage primaryStage) throws Exception {
        this.messager = new SharedMemoryJavaFXMessager(SegmentationModuleAPI.API);
        this.messager.startMessager();
        Path segmentationConfigurationFilePath = WorkspacePathTools.handleWorkingDirectoryFuzziness((String)"ihmc-open-robotics-software/atlas");
        segmentationConfigurationFilePath = Paths.get(segmentationConfigurationFilePath.toString(), "/src/main/resources/atlasSLAMSegmentationModuleConfiguration.txt");
        this.ui = PlanarSegmentationUI.createIntraprocessUI(this.messager, primaryStage);
        this.module = PlanarSegmentationModule.createIntraprocessModule(segmentationConfigurationFilePath.toFile(), this.messager);
        this.ui.show();
        this.module.start();
    }

    public void stop() throws Exception {
        this.ui.stop();
        this.module.stop();
        this.messager.closeMessager();
        Platform.exit();
    }

    public static void main(String[] args) {
        PlanarSegmentationStandaloneLauncher.launch((String[])args);
    }
}

