/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotEnvironmentAwareness.updaters;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import us.ihmc.euclid.geometry.Pose3D;
import us.ihmc.euclid.geometry.interfaces.Pose3DBasics;
import us.ihmc.euclid.geometry.interfaces.Pose3DReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.jOctoMap.boundingBox.OcTreeBoundingBoxInterface;
import us.ihmc.jOctoMap.boundingBox.OcTreeBoundingBoxWithCenterAndYaw;
import us.ihmc.jOctoMap.key.OcTreeKeyReadOnly;
import us.ihmc.jOctoMap.node.NormalOcTreeNode;
import us.ihmc.jOctoMap.normalEstimation.NormalEstimationParameters;
import us.ihmc.jOctoMap.ocTree.NormalOcTree;
import us.ihmc.jOctoMap.pointCloud.PointCloud;
import us.ihmc.jOctoMap.pointCloud.Scan;
import us.ihmc.messager.Messager;
import us.ihmc.robotEnvironmentAwareness.communication.REAModuleAPI;
import us.ihmc.robotEnvironmentAwareness.communication.converters.BoundingBoxMessageConverter;
import us.ihmc.robotEnvironmentAwareness.communication.packets.BoundingBoxParametersMessage;
import us.ihmc.robotEnvironmentAwareness.io.FilePropertyHelper;
import us.ihmc.robotEnvironmentAwareness.updaters.AdaptiveRayMissProbabilityUpdater;
import us.ihmc.robotEnvironmentAwareness.updaters.REAOcTreeBuffer;

public class REAOcTreeUpdater {
    private final Messager reaMessager;
    private NormalOcTree referenceOctree;
    private Pose3DBasics sensorPose = new Pose3D();
    private final REAOcTreeBuffer[] reaOcTreeBuffers;
    private final Map<REAOcTreeBuffer, AtomicReference<Pose3D>> sensorPoses;
    private final Map<REAOcTreeBuffer, AtomicBoolean> bufferClearRequest = new HashMap<REAOcTreeBuffer, AtomicBoolean>();
    private final AtomicReference<Boolean> enable;
    private final AtomicReference<Boolean> enableNormalEstimation;
    private final AtomicReference<Boolean> clearNormals;
    private final AtomicReference<Double> minRange;
    private final AtomicReference<Double> maxRange;
    private final AtomicReference<NormalEstimationParameters> normalEstimationParameters;
    private final AtomicReference<Boolean> useBoundingBox;
    private final AtomicReference<BoundingBoxParametersMessage> atomicBoundingBoxParameters;
    private final AtomicReference<Long> nodeLifetimeMilliseconds;

    public REAOcTreeUpdater(double octreeResolution, REAOcTreeBuffer[] buffers, Map<REAOcTreeBuffer, AtomicReference<Pose3D>> sensorPoses, Messager reaMessager) {
        this.initializeReferenceOctree(octreeResolution);
        this.reaOcTreeBuffers = buffers;
        this.sensorPoses = sensorPoses;
        this.reaMessager = reaMessager;
        for (REAOcTreeBuffer buffer : buffers) {
            this.bufferClearRequest.put(buffer, new AtomicBoolean(false));
        }
        this.enable = reaMessager.createInput(REAModuleAPI.OcTreeEnable, (Object)true);
        this.enableNormalEstimation = reaMessager.createInput(REAModuleAPI.NormalEstimationEnable, (Object)true);
        this.clearNormals = reaMessager.createInput(REAModuleAPI.NormalEstimationClear, (Object)false);
        this.minRange = reaMessager.createInput(REAModuleAPI.LidarMinRange, (Object)0.2);
        this.maxRange = reaMessager.createInput(REAModuleAPI.LidarMaxRange, (Object)5.0);
        this.useBoundingBox = reaMessager.createInput(REAModuleAPI.OcTreeBoundingBoxEnable, (Object)true);
        this.atomicBoundingBoxParameters = reaMessager.createInput(REAModuleAPI.OcTreeBoundingBoxParameters, (Object)BoundingBoxMessageConverter.createBoundingBoxParametersMessage(-1.0f, -2.0f, -3.0f, 5.0f, 2.0f, 0.5f));
        this.normalEstimationParameters = reaMessager.createInput(REAModuleAPI.NormalEstimationParameters, (Object)new NormalEstimationParameters());
        this.nodeLifetimeMilliseconds = reaMessager.createInput(REAModuleAPI.OcTreeNodeLifetimeMillis, (Object)60000L);
        reaMessager.addTopicListener(REAModuleAPI.RequestEntireModuleState, messageContent -> this.sendCurrentState());
    }

    public void initializeReferenceOctree(double octreeResolution) {
        this.referenceOctree = new NormalOcTree(octreeResolution);
        this.referenceOctree.enableParallelComputationForNormals(true);
        this.referenceOctree.enableParallelInsertionOfMisses(true);
        this.referenceOctree.setCustomRayMissProbabilityUpdater((NormalOcTree.RayMissProbabilityUpdater)new AdaptiveRayMissProbabilityUpdater());
    }

    private void sendCurrentState() {
        this.reaMessager.submitMessage(REAModuleAPI.OcTreeEnable, (Object)this.enable.get());
        this.reaMessager.submitMessage(REAModuleAPI.NormalEstimationEnable, (Object)this.enableNormalEstimation.get());
        this.reaMessager.submitMessage(REAModuleAPI.OcTreeNodeLifetimeMillis, (Object)this.nodeLifetimeMilliseconds.get());
        this.reaMessager.submitMessage(REAModuleAPI.LidarMinRange, (Object)this.minRange.get());
        this.reaMessager.submitMessage(REAModuleAPI.LidarMaxRange, (Object)this.maxRange.get());
        this.reaMessager.submitMessage(REAModuleAPI.OcTreeBoundingBoxEnable, (Object)this.useBoundingBox.get());
        this.reaMessager.submitMessage(REAModuleAPI.OcTreeBoundingBoxParameters, (Object)this.atomicBoundingBoxParameters.get());
        this.reaMessager.submitMessage(REAModuleAPI.NormalEstimationParameters, (Object)this.normalEstimationParameters.get());
    }

    public void loadConfiguration(FilePropertyHelper filePropertyHelper) {
        Double maxRangeFile;
        Double minRangeFile;
        String boundingBoxParametersFile;
        Boolean useBoundingBoxFile;
        String normalEstimationParametersFile;
        Long nodeLifetimeMillisFile;
        Boolean enableNormalEstimationFile;
        Boolean enableFile = filePropertyHelper.loadBooleanProperty(REAModuleAPI.OcTreeEnable.getName());
        if (enableFile != null) {
            this.enable.set(enableFile);
        }
        if ((enableNormalEstimationFile = filePropertyHelper.loadBooleanProperty(REAModuleAPI.NormalEstimationEnable.getName())) != null) {
            this.enableNormalEstimation.set(enableNormalEstimationFile);
        }
        if ((nodeLifetimeMillisFile = filePropertyHelper.loadLongProperty(REAModuleAPI.OcTreeNodeLifetimeMillis.getName())) != null) {
            this.nodeLifetimeMilliseconds.set(nodeLifetimeMillisFile);
        }
        if ((normalEstimationParametersFile = filePropertyHelper.loadProperty(REAModuleAPI.NormalEstimationParameters.getName())) != null) {
            this.normalEstimationParameters.set(NormalEstimationParameters.parse((String)normalEstimationParametersFile));
        }
        if ((useBoundingBoxFile = filePropertyHelper.loadBooleanProperty(REAModuleAPI.OcTreeBoundingBoxEnable.getName())) != null) {
            this.useBoundingBox.set(useBoundingBoxFile);
        }
        if ((boundingBoxParametersFile = filePropertyHelper.loadProperty(REAModuleAPI.OcTreeBoundingBoxParameters.getName())) != null) {
            this.atomicBoundingBoxParameters.set(BoundingBoxMessageConverter.parse(boundingBoxParametersFile));
        }
        if ((minRangeFile = filePropertyHelper.loadDoubleProperty(REAModuleAPI.LidarMinRange.getName())) != null) {
            this.minRange.set(minRangeFile);
        }
        if ((maxRangeFile = filePropertyHelper.loadDoubleProperty(REAModuleAPI.LidarMaxRange.getName())) != null) {
            this.maxRange.set(maxRangeFile);
        }
    }

    public void saveConfiguration(FilePropertyHelper filePropertyHelper) {
        filePropertyHelper.saveProperty(REAModuleAPI.OcTreeEnable.getName(), this.enable.get());
        filePropertyHelper.saveProperty(REAModuleAPI.NormalEstimationEnable.getName(), this.enableNormalEstimation.get());
        filePropertyHelper.saveProperty(REAModuleAPI.OcTreeNodeLifetimeMillis.getName(), this.nodeLifetimeMilliseconds.get());
        filePropertyHelper.saveProperty(REAModuleAPI.OcTreeBoundingBoxEnable.getName(), this.useBoundingBox.get());
        filePropertyHelper.saveProperty(REAModuleAPI.NormalEstimationParameters.getName(), this.normalEstimationParameters.get().toString());
        filePropertyHelper.saveProperty(REAModuleAPI.OcTreeBoundingBoxParameters.getName(), this.atomicBoundingBoxParameters.get().toString());
        filePropertyHelper.saveProperty(REAModuleAPI.LidarMinRange.getName(), this.minRange.get());
        filePropertyHelper.saveProperty(REAModuleAPI.LidarMaxRange.getName(), this.maxRange.get());
    }

    public void update() {
        if (!this.enable.get().booleanValue()) {
            return;
        }
        this.handleBoundingBox();
        if (this.minRange.get() != null && this.maxRange.get() != null) {
            this.referenceOctree.setBoundsInsertRange(this.minRange.get().doubleValue(), this.maxRange.get().doubleValue());
        }
        this.referenceOctree.setNormalEstimationParameters(this.normalEstimationParameters.get());
        boolean hasOcTreeBeenUpdated = false;
        for (REAOcTreeBuffer buffer : this.reaOcTreeBuffers) {
            AtomicReference<Pose3D> sensorPoseReference = this.sensorPoses.get(buffer);
            if (sensorPoseReference.get() == null) continue;
            Point3D sensorOrigin = sensorPoseReference.get().getPosition();
            boolean isBufferFull = buffer.isBufferFull();
            if (isBufferFull) {
                buffer.submitBufferRequest();
            }
            NormalOcTree bufferOctree = buffer.pollNewBuffer();
            Pose3DReadOnly bufferSensorPose = buffer.pollNewSensorPoseBuffer();
            if (bufferOctree != null) {
                if (this.bufferClearRequest.get(buffer).getAndSet(false)) {
                    this.referenceOctree.clear();
                }
                PointCloud pointCloud = new PointCloud();
                bufferOctree.forEach(node -> pointCloud.add(node.getHitLocationX(), node.getHitLocationY(), node.getHitLocationZ()));
                pointCloud.setTimestamp(TimeUnit.NANOSECONDS.toMillis(System.nanoTime()));
                Scan scan = new Scan((Point3DReadOnly)sensorOrigin, pointCloud);
                HashSet updatedNodes = new HashSet();
                this.referenceOctree.insertScan(scan, updatedNodes, null);
                if (this.nodeLifetimeMilliseconds.get() > 0L) {
                    this.decayOcTreeNodes();
                }
                hasOcTreeBeenUpdated = true;
            }
            if (bufferSensorPose == null) continue;
            this.sensorPose.set(bufferSensorPose);
        }
        if (this.clearNormals.getAndSet(false).booleanValue()) {
            this.referenceOctree.clearNormals();
            return;
        }
        if (!hasOcTreeBeenUpdated || !this.enableNormalEstimation.get().booleanValue()) {
            return;
        }
        this.referenceOctree.updateNormals();
    }

    private void decayOcTreeNodes() {
        long currentTimestamp = TimeUnit.NANOSECONDS.toMillis(System.nanoTime());
        ArrayList<NormalOcTreeNode> decayedNodes = new ArrayList<NormalOcTreeNode>();
        for (NormalOcTreeNode node2 : this.referenceOctree) {
            if (currentTimestamp - node2.getLastHitTimestamp() < this.nodeLifetimeMilliseconds.get()) continue;
            decayedNodes.add(node2);
        }
        decayedNodes.forEach(node -> this.referenceOctree.deleteNode((OcTreeKeyReadOnly)node.getKeyCopy()));
    }

    public void clearOcTreeOnNextUpdate(REAOcTreeBuffer bufferToClear) {
        this.bufferClearRequest.get(bufferToClear).set(true);
    }

    public void clearOcTree() {
        this.referenceOctree.clear();
    }

    private void handleBoundingBox() {
        if (!this.useBoundingBox.get().booleanValue()) {
            this.referenceOctree.disableBoundingBox();
            return;
        }
        OcTreeBoundingBoxWithCenterAndYaw boundingBox = new OcTreeBoundingBoxWithCenterAndYaw();
        Point3D min = this.atomicBoundingBoxParameters.get().getMin();
        Point3D max = this.atomicBoundingBoxParameters.get().getMax();
        boundingBox.setLocalMinMaxCoordinates((Point3DReadOnly)min, (Point3DReadOnly)max);
        Pose3D sensorPose = null;
        for (REAOcTreeBuffer buffer : this.reaOcTreeBuffers) {
            AtomicReference<Pose3D> sensorPoseReference = this.sensorPoses.get(buffer);
            if (sensorPoseReference.get() == null) continue;
            sensorPose = sensorPoseReference.get();
        }
        if (sensorPose != null) {
            boundingBox.setOffset((Tuple3DReadOnly)sensorPose.getPosition());
            boundingBox.setYawFromQuaternion(new Quaternion((QuaternionReadOnly)sensorPose.getOrientation()));
        }
        boundingBox.update(this.referenceOctree.getResolution(), this.referenceOctree.getTreeDepth());
        this.referenceOctree.setBoundingBox((OcTreeBoundingBoxInterface)boundingBox);
    }

    public NormalOcTree getMainOctree() {
        return this.referenceOctree;
    }

    public Pose3DReadOnly getSensorPose() {
        return this.sensorPose;
    }
}

