/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotEnvironmentAwareness.updaters;

import java.util.concurrent.atomic.AtomicReference;
import perception_msgs.msg.dds.REASensorDataFilterParametersMessage;
import perception_msgs.msg.dds.REAStatusMessage;
import us.ihmc.communication.IHMCROS2Publisher;
import us.ihmc.communication.ROS2Tools;
import us.ihmc.messager.Messager;
import us.ihmc.robotEnvironmentAwareness.communication.REAModuleAPI;
import us.ihmc.robotEnvironmentAwareness.communication.packets.BoundingBoxParametersMessage;
import us.ihmc.ros2.ROS2NodeInterface;
import us.ihmc.ros2.ROS2Topic;

public class REACurrentStateProvider {
    private final IHMCROS2Publisher<REAStatusMessage> currentStatePublisher;
    private final AtomicReference<Boolean> isRunning;
    private final AtomicReference<Boolean> hasCleared;
    private final AtomicReference<Boolean> isUsingLidar;
    private final AtomicReference<Boolean> isUsingStereoVision;
    private final AtomicReference<Boolean> isUsingDepthCloud;
    private final AtomicReference<Double> minRange;
    private final AtomicReference<Double> maxRange;
    private final AtomicReference<BoundingBoxParametersMessage> boundingBoxParameters;
    private final REAStatusMessage currentState = new REAStatusMessage();

    public REACurrentStateProvider(ROS2NodeInterface ros2Node, ROS2Topic outputTopic, Messager messager) {
        this.currentStatePublisher = ROS2Tools.createPublisherTypeNamed((ROS2NodeInterface)ros2Node, REAStatusMessage.class, (ROS2Topic)outputTopic);
        this.isRunning = messager.createInput(REAModuleAPI.OcTreeEnable);
        this.hasCleared = messager.createInput(REAModuleAPI.OcTreeClear, (Object)false);
        this.isUsingLidar = messager.createInput(REAModuleAPI.LidarBufferEnable);
        this.isUsingStereoVision = messager.createInput(REAModuleAPI.StereoVisionBufferEnable);
        this.isUsingDepthCloud = messager.createInput(REAModuleAPI.DepthCloudBufferEnable);
        this.minRange = messager.createInput(REAModuleAPI.LidarMinRange);
        this.maxRange = messager.createInput(REAModuleAPI.LidarMaxRange);
        this.boundingBoxParameters = messager.createInput(REAModuleAPI.OcTreeBoundingBoxParameters);
    }

    public void publishCurrentState() {
        this.currentState.setIsRunning(this.isRunning.get().booleanValue());
        this.currentState.setIsUsingLidar(this.isUsingLidar.get().booleanValue());
        this.currentState.setIsUsingStereoVision(this.isUsingStereoVision.get().booleanValue());
        this.currentState.setHasCleared(this.hasCleared.getAndSet(false).booleanValue());
        REASensorDataFilterParametersMessage sensorFilterParameters = this.currentState.getCurrentSensorFilterParameters();
        sensorFilterParameters.setSensorMinRange(this.minRange.get().doubleValue());
        sensorFilterParameters.setSensorMaxRange(this.maxRange.get().doubleValue());
        sensorFilterParameters.getBoundingBoxMin().set(this.boundingBoxParameters.get().getMin());
        sensorFilterParameters.getBoundingBoxMax().set(this.boundingBoxParameters.get().getMax());
        this.currentStatePublisher.publish((Object)this.currentState);
    }
}

