/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotEnvironmentAwareness.ui.viewer;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javafx.animation.AnimationTimer;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.paint.Color;
import javafx.scene.paint.Material;
import javafx.scene.shape.Mesh;
import javafx.scene.shape.MeshView;
import javafx.util.Pair;
import us.ihmc.robotEnvironmentAwareness.communication.REAModuleAPI;
import us.ihmc.robotEnvironmentAwareness.communication.REAUIMessager;
import us.ihmc.robotEnvironmentAwareness.ui.graphicsBuilders.BoundingBoxMeshView;
import us.ihmc.robotEnvironmentAwareness.ui.graphicsBuilders.BufferOctreeMeshBuilder;
import us.ihmc.robotEnvironmentAwareness.ui.graphicsBuilders.LidarScanViewer;
import us.ihmc.robotEnvironmentAwareness.ui.graphicsBuilders.OcTreeMeshBuilder;
import us.ihmc.robotEnvironmentAwareness.ui.graphicsBuilders.PlanarRegionsIntersectionsMeshBuilder;
import us.ihmc.robotEnvironmentAwareness.ui.graphicsBuilders.PlanarRegionsMeshBuilder;
import us.ihmc.robotEnvironmentAwareness.ui.graphicsBuilders.StereoVisionPointCloudViewer;
import us.ihmc.tools.thread.ExecutorServiceTools;

public class REAMeshViewer {
    private static final int SLOW_PACE_UPDATE_PERIOD = 2000;
    private static final int MEDIUM_PACE_UPDATE_PERIOD = 100;
    private static final int HIGH_PACE_UPDATE_PERIOD = 10;
    private final Group root = new Group();
    private final List<ScheduledFuture<?>> meshBuilderScheduledFutures = new ArrayList();
    private final MeshView lidarBufferOcTreeMeshView = new MeshView();
    private final MeshView stereoVisionBufferOcTreeMeshView = new MeshView();
    private final MeshView depthCloudBufferOcTreeMeshView = new MeshView();
    private final MeshView planarRegionMeshView = new MeshView();
    private final MeshView intersectionsMeshView = new MeshView();
    private ScheduledExecutorService executorService = ExecutorServiceTools.newScheduledThreadPool((int)2, this.getClass(), (ExecutorServiceTools.ExceptionHandling)ExecutorServiceTools.ExceptionHandling.CANCEL_AND_REPORT);
    private final AnimationTimer renderMeshAnimation;
    private final LidarScanViewer lidarScanViewer;
    private final StereoVisionPointCloudViewer stereoVisionPointCloudViewer;
    private final StereoVisionPointCloudViewer depthPointCloudViewer;
    private final BufferOctreeMeshBuilder lidarBufferOctreeMeshBuilder;
    private final BufferOctreeMeshBuilder stereoVisionBufferOctreeMeshBuilder;
    private final BufferOctreeMeshBuilder depthCloudBufferOctreeMeshBuilder;
    private final OcTreeMeshBuilder ocTreeViewer;
    private final PlanarRegionsMeshBuilder planarRegionsMeshBuilder;
    private final PlanarRegionsIntersectionsMeshBuilder intersectionsMeshBuilder;
    private final BoundingBoxMeshView boundingBoxMeshView;

    public REAMeshViewer(REAUIMessager uiMessager) {
        this.lidarScanViewer = new LidarScanViewer(REAModuleAPI.LidarScanState, uiMessager, REAModuleAPI.UILidarScanShow, REAModuleAPI.UILidarScanClear);
        this.stereoVisionPointCloudViewer = new StereoVisionPointCloudViewer(REAModuleAPI.StereoVisionPointCloudState, uiMessager, REAModuleAPI.UIStereoVisionShow, REAModuleAPI.UIStereoVisionClear, REAModuleAPI.UIStereoVisionSize);
        this.depthPointCloudViewer = new StereoVisionPointCloudViewer(REAModuleAPI.DepthPointCloudState, uiMessager, REAModuleAPI.UIDepthCloudShow, REAModuleAPI.UIDepthCloudClear, REAModuleAPI.UIDepthCloudSize);
        this.lidarBufferOctreeMeshBuilder = new BufferOctreeMeshBuilder(uiMessager, REAModuleAPI.UIOcTreeShowLidarBuffer, REAModuleAPI.RequestLidarBuffer, REAModuleAPI.LidarBufferState, Color.DARKRED);
        this.stereoVisionBufferOctreeMeshBuilder = new BufferOctreeMeshBuilder(uiMessager, REAModuleAPI.UIOcTreeShowStereoVisionBuffer, REAModuleAPI.RequestStereoVisionBuffer, REAModuleAPI.StereoVisionBufferState, Color.DARKORANGE);
        this.depthCloudBufferOctreeMeshBuilder = new BufferOctreeMeshBuilder(uiMessager, REAModuleAPI.UIOcTreeShowDepthCloudBuffer, REAModuleAPI.RequestDepthCloudBuffer, REAModuleAPI.DepthCloudBufferState, Color.DARKBLUE);
        this.ocTreeViewer = new OcTreeMeshBuilder(uiMessager, REAModuleAPI.OcTreeEnable, REAModuleAPI.OcTreeClear, REAModuleAPI.RequestOctree, REAModuleAPI.RequestPlanarRegionSegmentation, REAModuleAPI.UIOcTreeDepth, REAModuleAPI.UIOcTreeColoringMode, REAModuleAPI.UIOcTreeDisplayType, REAModuleAPI.UIPlanarRegionHideNodes, REAModuleAPI.OcTreeState, REAModuleAPI.PlanarRegionsSegmentationState);
        this.planarRegionsMeshBuilder = new PlanarRegionsMeshBuilder(uiMessager, REAModuleAPI.PlanarRegionsState);
        this.intersectionsMeshBuilder = new PlanarRegionsIntersectionsMeshBuilder(uiMessager);
        this.boundingBoxMeshView = new BoundingBoxMeshView(uiMessager);
        Node lidarScanRootNode = this.lidarScanViewer.getRoot();
        lidarScanRootNode.setMouseTransparent(true);
        Node stereoVisionPointCloudRootNode = this.stereoVisionPointCloudViewer.getRoot();
        stereoVisionPointCloudRootNode.setMouseTransparent(true);
        Node depthPointCloudRootNode = this.depthPointCloudViewer.getRoot();
        depthPointCloudRootNode.setMouseTransparent(true);
        this.lidarBufferOcTreeMeshView.setMouseTransparent(true);
        this.stereoVisionBufferOcTreeMeshView.setMouseTransparent(true);
        this.depthCloudBufferOcTreeMeshView.setMouseTransparent(true);
        this.ocTreeViewer.getRoot().setMouseTransparent(true);
        this.boundingBoxMeshView.setMouseTransparent(true);
        this.root.getChildren().addAll((Object[])new Node[]{lidarScanRootNode, stereoVisionPointCloudRootNode, depthPointCloudRootNode, this.lidarBufferOcTreeMeshView, this.stereoVisionBufferOcTreeMeshView, this.depthCloudBufferOcTreeMeshView, this.ocTreeViewer.getRoot(), this.planarRegionMeshView, this.intersectionsMeshView, this.boundingBoxMeshView});
        this.renderMeshAnimation = new AnimationTimer(){

            public void handle(long now) {
                REAMeshViewer.this.lidarScanViewer.render();
                REAMeshViewer.this.stereoVisionPointCloudViewer.render();
                REAMeshViewer.this.depthPointCloudViewer.render();
                REAMeshViewer.this.ocTreeViewer.render();
                if (REAMeshViewer.this.lidarBufferOctreeMeshBuilder.hasNewMeshAndMaterial()) {
                    REAMeshViewer.this.updateMeshView(REAMeshViewer.this.lidarBufferOcTreeMeshView, REAMeshViewer.this.lidarBufferOctreeMeshBuilder.pollMeshAndMaterial());
                }
                if (REAMeshViewer.this.stereoVisionBufferOctreeMeshBuilder.hasNewMeshAndMaterial()) {
                    REAMeshViewer.this.updateMeshView(REAMeshViewer.this.stereoVisionBufferOcTreeMeshView, REAMeshViewer.this.stereoVisionBufferOctreeMeshBuilder.pollMeshAndMaterial());
                }
                if (REAMeshViewer.this.depthCloudBufferOctreeMeshBuilder.hasNewMeshAndMaterial()) {
                    REAMeshViewer.this.updateMeshView(REAMeshViewer.this.depthCloudBufferOcTreeMeshView, REAMeshViewer.this.depthCloudBufferOctreeMeshBuilder.pollMeshAndMaterial());
                }
                if (REAMeshViewer.this.planarRegionsMeshBuilder.hasNewMeshAndMaterial()) {
                    REAMeshViewer.this.updateMeshView(REAMeshViewer.this.planarRegionMeshView, REAMeshViewer.this.planarRegionsMeshBuilder.pollMeshAndMaterial());
                }
                if (REAMeshViewer.this.intersectionsMeshBuilder.hasNewMeshAndMaterial()) {
                    REAMeshViewer.this.updateMeshView(REAMeshViewer.this.intersectionsMeshView, REAMeshViewer.this.intersectionsMeshBuilder.pollMeshAndMaterial());
                }
            }
        };
        uiMessager.registerModuleMessagerStateListener(isMessagerOpen -> {
            if (isMessagerOpen) {
                this.start();
            } else {
                this.sleep();
            }
        });
    }

    public void start() {
        if (!this.meshBuilderScheduledFutures.isEmpty()) {
            return;
        }
        this.renderMeshAnimation.start();
        this.meshBuilderScheduledFutures.add(this.executorService.scheduleAtFixedRate(this.lidarScanViewer, 0L, 10L, TimeUnit.MILLISECONDS));
        this.meshBuilderScheduledFutures.add(this.executorService.scheduleAtFixedRate(this.stereoVisionPointCloudViewer, 0L, 10L, TimeUnit.MILLISECONDS));
        this.meshBuilderScheduledFutures.add(this.executorService.scheduleAtFixedRate(this.depthPointCloudViewer, 0L, 10L, TimeUnit.MILLISECONDS));
        this.meshBuilderScheduledFutures.add(this.executorService.scheduleAtFixedRate(this.lidarBufferOctreeMeshBuilder, 0L, 10L, TimeUnit.MILLISECONDS));
        this.meshBuilderScheduledFutures.add(this.executorService.scheduleAtFixedRate(this.stereoVisionBufferOctreeMeshBuilder, 0L, 10L, TimeUnit.MILLISECONDS));
        this.meshBuilderScheduledFutures.add(this.executorService.scheduleAtFixedRate(this.depthCloudBufferOctreeMeshBuilder, 0L, 10L, TimeUnit.MILLISECONDS));
        this.meshBuilderScheduledFutures.add(this.executorService.scheduleAtFixedRate(this.ocTreeViewer, 0L, 2000L, TimeUnit.MILLISECONDS));
        this.meshBuilderScheduledFutures.add(this.executorService.scheduleAtFixedRate(this.planarRegionsMeshBuilder, 0L, 100L, TimeUnit.MILLISECONDS));
        this.meshBuilderScheduledFutures.add(this.executorService.scheduleAtFixedRate(this.intersectionsMeshBuilder, 0L, 100L, TimeUnit.MILLISECONDS));
        this.meshBuilderScheduledFutures.add(this.executorService.scheduleAtFixedRate(this.boundingBoxMeshView, 0L, 100L, TimeUnit.MILLISECONDS));
    }

    public void sleep() {
        if (this.meshBuilderScheduledFutures.isEmpty()) {
            return;
        }
        this.renderMeshAnimation.stop();
        for (ScheduledFuture<?> scheduledFuture : this.meshBuilderScheduledFutures) {
            scheduledFuture.cancel(true);
        }
        this.meshBuilderScheduledFutures.clear();
    }

    public void stop() {
        this.sleep();
        if (this.executorService != null) {
            this.executorService.shutdownNow();
            this.executorService = null;
        }
    }

    private void updateMeshView(MeshView meshViewToUpdate, Pair<Mesh, Material> meshMaterial) {
        meshViewToUpdate.setMesh((Mesh)meshMaterial.getKey());
        meshViewToUpdate.setMaterial((Material)meshMaterial.getValue());
    }

    public Node getRoot() {
        return this.root;
    }
}

