/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotEnvironmentAwareness.ui.graphicsBuilders;

import java.util.Iterator;
import java.util.concurrent.atomic.AtomicReference;
import javafx.scene.paint.Color;
import javafx.scene.paint.Material;
import javafx.scene.paint.PhongMaterial;
import javafx.scene.shape.Mesh;
import javafx.util.Pair;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.javaFXToolkit.shapes.JavaFXMeshBuilder;
import us.ihmc.messager.MessagerAPIFactory;
import us.ihmc.robotEnvironmentAwareness.communication.REAUIMessager;
import us.ihmc.robotEnvironmentAwareness.communication.packets.NormalOcTreeMessage;
import us.ihmc.robotEnvironmentAwareness.ui.UIOcTree;
import us.ihmc.robotEnvironmentAwareness.ui.UIOcTreeNode;

public class BufferOctreeMeshBuilder
implements Runnable {
    private static final double NODE_SCALE = 0.5;
    private final JavaFXMeshBuilder bufferMeshBuilder = new JavaFXMeshBuilder();
    private final Material bufferMaterial;
    private final AtomicReference<Boolean> showBuffer;
    private final AtomicReference<NormalOcTreeMessage> bufferState;
    private final AtomicReference<Pair<Mesh, Material>> meshAndMaterialToRender = new AtomicReference<Object>(null);
    private boolean hasClearedBufferGraphics = false;
    private final REAUIMessager uiMessager;
    private final MessagerAPIFactory.Topic<Boolean> requestBufferTopic;

    public BufferOctreeMeshBuilder(REAUIMessager uiMessager, MessagerAPIFactory.Topic<Boolean> uiShowBufferTopic, MessagerAPIFactory.Topic<Boolean> requestBufferTopic, MessagerAPIFactory.Topic<NormalOcTreeMessage> bufferStateTopic, Color color) {
        this.uiMessager = uiMessager;
        this.requestBufferTopic = requestBufferTopic;
        this.bufferMaterial = new PhongMaterial(color);
        this.showBuffer = uiMessager.createInput(uiShowBufferTopic, false);
        this.bufferState = uiMessager.createInput(bufferStateTopic);
    }

    @Override
    public void run() {
        NormalOcTreeMessage newBufferState = this.bufferState.getAndSet(null);
        if (!this.showBuffer.get().booleanValue()) {
            if (this.hasClearedBufferGraphics) {
                return;
            }
            this.bufferMeshBuilder.clear();
            this.meshAndMaterialToRender.set((Pair<Mesh, Material>)new Pair(null, null));
            this.hasClearedBufferGraphics = true;
            return;
        }
        this.uiMessager.submitStateRequestToModule(this.requestBufferTopic);
        this.bufferMeshBuilder.clear();
        if (newBufferState == null) {
            return;
        }
        UIOcTree uiOcTree = new UIOcTree(newBufferState);
        Iterator iterator = uiOcTree.iterator();
        while (iterator.hasNext()) {
            UIOcTreeNode uiOcTreeNode = (UIOcTreeNode)((Object)iterator.next());
            Point3D nodeCenter = new Point3D(uiOcTreeNode.getX(), uiOcTreeNode.getY(), uiOcTreeNode.getZ());
            this.bufferMeshBuilder.addTetrahedron(0.5 * uiOcTreeNode.getSize(), (Tuple3DReadOnly)nodeCenter);
        }
        this.meshAndMaterialToRender.set((Pair<Mesh, Material>)new Pair((Object)this.bufferMeshBuilder.generateMesh(), (Object)this.bufferMaterial));
        this.hasClearedBufferGraphics = false;
    }

    public boolean hasNewMeshAndMaterial() {
        return this.meshAndMaterialToRender.get() != null;
    }

    public Pair<Mesh, Material> pollMeshAndMaterial() {
        return this.meshAndMaterialToRender.getAndSet(null);
    }
}

