/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotEnvironmentAwareness.ui.graphicsBuilders;

import java.util.concurrent.atomic.AtomicReference;
import javafx.application.Platform;
import javafx.scene.paint.Color;
import javafx.scene.paint.Material;
import javafx.scene.paint.PhongMaterial;
import javafx.scene.shape.Mesh;
import javafx.scene.shape.MeshView;
import javafx.scene.shape.TriangleMesh;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.tuple3D.Point3D32;
import us.ihmc.euclid.tuple3D.Vector3D32;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion32;
import us.ihmc.graphicsDescription.MeshDataGenerator;
import us.ihmc.graphicsDescription.MeshDataHolder;
import us.ihmc.javaFXToolkit.graphics.JavaFXMeshDataInterpreter;
import us.ihmc.messager.MessagerAPIFactory;
import us.ihmc.robotEnvironmentAwareness.communication.REAModuleAPI;
import us.ihmc.robotEnvironmentAwareness.communication.REAUIMessager;
import us.ihmc.robotEnvironmentAwareness.communication.packets.BoxMessage;

public class BoundingBoxMeshView
extends MeshView
implements Runnable {
    private static final Color OCTREE_BBX_COLOR = new Color(Color.DARKGREY.getRed(), Color.DARKGREY.getGreen(), Color.DARKGREY.getBlue(), 0.0);
    private final Material material = new PhongMaterial(OCTREE_BBX_COLOR);
    private final AtomicReference<Boolean> showOcTreeBoundingBox;
    private final AtomicReference<BoxMessage> boundingBoxState;
    private final REAUIMessager uiMessager;
    private final MessagerAPIFactory.Topic<Boolean> requestBoundingBoxTopic;

    public BoundingBoxMeshView(REAUIMessager uiMessager) {
        this(uiMessager, REAModuleAPI.UIOcTreeBoundingBoxShow, REAModuleAPI.RequestBoundingBox, REAModuleAPI.OcTreeBoundingBoxState);
    }

    public BoundingBoxMeshView(REAUIMessager uiMessager, MessagerAPIFactory.Topic<Boolean> uiOcTreeBoundingBoxShowTopic, MessagerAPIFactory.Topic<Boolean> requestBoundingBoxTopic, MessagerAPIFactory.Topic<BoxMessage> ocTreeBoundingBoxStateTopic) {
        this.uiMessager = uiMessager;
        this.requestBoundingBoxTopic = requestBoundingBoxTopic;
        this.showOcTreeBoundingBox = uiMessager.createInput(uiOcTreeBoundingBoxShowTopic, false);
        this.boundingBoxState = uiMessager.createInput(ocTreeBoundingBoxStateTopic);
        this.setMaterial(this.material);
    }

    @Override
    public void run() {
        BoxMessage newMessage = this.boundingBoxState.getAndSet(null);
        if (!this.showOcTreeBoundingBox.get().booleanValue()) {
            Platform.runLater(() -> this.setMesh(null));
            return;
        }
        this.uiMessager.submitStateRequestToModule(this.requestBoundingBoxTopic);
        if (newMessage == null) {
            return;
        }
        if (newMessage.isEmpty()) {
            Platform.runLater(() -> this.setMesh(null));
            return;
        }
        Vector3D32 boxSize = newMessage.getSize();
        Quaternion32 boxOrientation = newMessage.getOrientation();
        Point3D32 boxCenter = newMessage.getCenter();
        MeshDataHolder boxMeshDataHolder = MeshDataGenerator.Cube((double)boxSize.getX(), (double)boxSize.getY(), (double)boxSize.getZ(), (boolean)true);
        boxMeshDataHolder = MeshDataHolder.rotate((MeshDataHolder)boxMeshDataHolder, (Orientation3DReadOnly)boxOrientation);
        boxMeshDataHolder = MeshDataHolder.translate((MeshDataHolder)boxMeshDataHolder, (Tuple3DReadOnly)boxCenter);
        TriangleMesh boxMesh = JavaFXMeshDataInterpreter.interpretMeshData((MeshDataHolder)boxMeshDataHolder);
        Platform.runLater(() -> this.lambda$run$2((Mesh)boxMesh));
    }

    private /* synthetic */ void lambda$run$2(Mesh boxMesh) {
        this.setMesh(boxMesh);
    }
}

