/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotEnvironmentAwareness.ui.graphicsBuilders;

import java.util.concurrent.atomic.AtomicReference;
import javafx.collections.ObservableList;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.shape.MeshView;
import us.ihmc.communication.packets.Packet;
import us.ihmc.javaFXToolkit.shapes.JavaFXMultiColorMeshBuilder;
import us.ihmc.javaFXToolkit.shapes.TextureColorAdaptivePalette;
import us.ihmc.javaFXToolkit.shapes.TextureColorPalette;
import us.ihmc.messager.MessagerAPIFactory;
import us.ihmc.robotEnvironmentAwareness.communication.REAUIMessager;

public abstract class AbstractSourceViewer<T extends Packet<?>>
implements Runnable {
    protected static final float SCAN_POINT_SIZE = 0.0075f;
    private static final int palleteSizeForMeshBuilder = 2048;
    private final Group root = new Group();
    protected final ObservableList<Node> children = this.root.getChildren();
    protected final JavaFXMultiColorMeshBuilder meshBuilder;
    protected final AtomicReference<T> newMessageToRender;
    protected final AtomicReference<MeshView> scanMeshToRender = new AtomicReference<Object>(null);
    protected final AtomicReference<Boolean> enable;
    protected final AtomicReference<Boolean> clear;

    public AbstractSourceViewer(MessagerAPIFactory.Topic<T> messageState, REAUIMessager uiMessager, MessagerAPIFactory.Topic<Boolean> enableTopic, MessagerAPIFactory.Topic<Boolean> clearTopic) {
        this.newMessageToRender = uiMessager.createInput(messageState);
        this.meshBuilder = new JavaFXMultiColorMeshBuilder((TextureColorPalette)new TextureColorAdaptivePalette(2048));
        this.enable = uiMessager.createInput(enableTopic, false);
        this.clear = uiMessager.createInput(clearTopic, false);
    }

    @Override
    public void run() {
        if (!this.enable.get().booleanValue()) {
            return;
        }
        if (this.newMessageToRender.get() == null) {
            return;
        }
        this.unpackPointCloud(this.newMessageToRender.getAndSet(null));
    }

    public void clear() {
        this.children.clear();
    }

    public Node getRoot() {
        return this.root;
    }

    public abstract void render();

    public abstract void unpackPointCloud(T var1);
}

