/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotEnvironmentAwareness.ui.controller;

import java.io.File;
import javafx.application.Platform;
import javafx.fxml.FXML;
import javafx.scene.control.TextField;
import javafx.stage.DirectoryChooser;
import javafx.stage.Window;
import us.ihmc.messager.MessagerAPIFactory;
import us.ihmc.robotEnvironmentAwareness.communication.REAModuleAPI;
import us.ihmc.robotEnvironmentAwareness.ui.controller.REABasicUIController;

public class SegmentationDataExporterAnchorPaneController
extends REABasicUIController {
    private final File defaultSegmentationDataFile = new File("Data/Segmentation/");
    private final File defaultPlanarRegionDataFile = new File("Data/PlanarRegion/");
    @FXML
    private TextField currentSegmentationDataFolderTextField;
    @FXML
    private TextField currentPlanarRegionDataFolderTextField;
    private final DirectoryChooser segmentationDirectoryChooser = new DirectoryChooser();
    private final DirectoryChooser planarRegionDirectoryChooser = new DirectoryChooser();
    private Window ownerWindow;
    private MessagerAPIFactory.Topic<Boolean> uiSegmentationDataExportRequestTopic = REAModuleAPI.UISegmentationDataExportRequest;
    private MessagerAPIFactory.Topic<Boolean> uiPlanarRegionDataExportRequestTopic = REAModuleAPI.UIPlanarRegionDataExportRequest;
    private MessagerAPIFactory.Topic<String> uiSegmentationDataExporterDirectoryTopic = REAModuleAPI.UISegmentationDataExporterDirectory;
    private MessagerAPIFactory.Topic<String> uiPlanarRegionDataExporterDirectoryTopic = REAModuleAPI.UIPlanarRegionDataExporterDirectory;

    public void setMainWindow(Window ownerWindow) {
        this.ownerWindow = ownerWindow;
    }

    public void setUiSegmentationDataExportRequestTopic(MessagerAPIFactory.Topic<Boolean> uiSegmentationDataExportRequestTopic) {
        this.uiSegmentationDataExportRequestTopic = uiSegmentationDataExportRequestTopic;
    }

    public void setUiPlanarRegionDataExportRequestTopic(MessagerAPIFactory.Topic<Boolean> uiPlanarRegionDataExportRequestTopic) {
        this.uiPlanarRegionDataExportRequestTopic = uiPlanarRegionDataExportRequestTopic;
    }

    public void setUiSegmentationDataExporterDirectoryTopic(MessagerAPIFactory.Topic<String> uiSegmentationDataExporterDirectoryTopic) {
        this.uiSegmentationDataExporterDirectoryTopic = uiSegmentationDataExporterDirectoryTopic;
    }

    public void setUiPlanarRegionDataExporterDirectoryTopic(MessagerAPIFactory.Topic<String> uiPlanarRegionDataExporterDirectoryTopic) {
        this.uiPlanarRegionDataExporterDirectoryTopic = uiPlanarRegionDataExporterDirectoryTopic;
    }

    @Override
    public void bindControls() {
        this.currentSegmentationDataFolderTextField.setText(this.defaultSegmentationDataFile.getAbsolutePath());
        this.currentPlanarRegionDataFolderTextField.setText(this.defaultPlanarRegionDataFile.getAbsolutePath());
    }

    @FXML
    private void exportSegmentation() {
        this.uiMessager.submitMessageInternal(this.uiSegmentationDataExportRequestTopic, true);
    }

    @FXML
    private void exportPlanarRegion() {
        this.uiMessager.submitMessageInternal(this.uiPlanarRegionDataExportRequestTopic, true);
    }

    @FXML
    private void browseSegmentationOutputFolder() {
        this.segmentationDirectoryChooser.setInitialDirectory(this.defaultSegmentationDataFile);
        String newPath = this.segmentationDirectoryChooser.showDialog(this.ownerWindow).getAbsolutePath();
        this.uiMessager.submitMessageInternal(this.uiSegmentationDataExporterDirectoryTopic, newPath);
        Platform.runLater(() -> this.currentSegmentationDataFolderTextField.setText(newPath));
    }

    @FXML
    private void browsePlanarRegionOutputFolder() {
        this.planarRegionDirectoryChooser.setInitialDirectory(this.defaultPlanarRegionDataFile);
        String newPath = this.planarRegionDirectoryChooser.showDialog(this.ownerWindow).getAbsolutePath();
        this.uiMessager.submitMessageInternal(this.uiPlanarRegionDataExporterDirectoryTopic, newPath);
        Platform.runLater(() -> this.currentPlanarRegionDataFolderTextField.setText(newPath));
    }
}

