/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotEnvironmentAwareness.ui.controller;

import controller_msgs.msg.dds.StereoVisionPointCloudMessage;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javafx.application.Platform;
import javafx.fxml.FXML;
import javafx.scene.control.TextField;
import javafx.scene.control.ToggleButton;
import javafx.stage.DirectoryChooser;
import javafx.stage.Window;
import us.ihmc.communication.IHMCROS2Publisher;
import us.ihmc.communication.ROS2Tools;
import us.ihmc.log.LogTools;
import us.ihmc.pubsub.DomainFactory;
import us.ihmc.robotEnvironmentAwareness.communication.SLAMModuleAPI;
import us.ihmc.robotEnvironmentAwareness.ui.controller.REABasicUIController;
import us.ihmc.robotEnvironmentAwareness.ui.io.StereoVisionPointCloudDataLoader;
import us.ihmc.ros2.ROS2Node;
import us.ihmc.ros2.ROS2NodeInterface;
import us.ihmc.ros2.ROS2Topic;
import us.ihmc.tools.thread.ExecutorServiceTools;

public class SLAMDataManagerAnchorPaneController
extends REABasicUIController {
    @FXML
    private ToggleButton exportRawData;
    @FXML
    private TextField currentRawDataOutputFolderTextField;
    @FXML
    private TextField currentSLAMDataOutputFolderTextField;
    @FXML
    private TextField currentRawDataInputFolderTextField;
    @FXML
    private TextField currentPlanarRegionsInputFolderTextField;
    private final DirectoryChooser exportRawDataDirectoryChooser = new DirectoryChooser();
    private final DirectoryChooser exportSLAMDataDirectoryChooser = new DirectoryChooser();
    private final DirectoryChooser importRawDataDirectoryChooser = new DirectoryChooser();
    private final DirectoryChooser importPlanarRegionsDirectoryChooser = new DirectoryChooser();
    private final File defaultExportRawDataFile = new File("../robot-environment-awareness/Data/");
    private final File defaultExportSLAMDataFile = new File("../robot-environment-awareness/Data/");
    private final File defaultImportRawDataFile = new File("../robot-environment-awareness/Data/");
    private final File defaultImportPlanarRegionsFile = new File("../robot-environment-awareness/Data/PlanarRegion");
    private Window ownerWindow;
    private static long DEFAULT_PUBLISHING_PERIOD_MS = 250L;
    private final ScheduledExecutorService executor = ExecutorServiceTools.newSingleThreadScheduledExecutor(this.getClass(), (ExecutorServiceTools.ExceptionHandling)ExecutorServiceTools.ExceptionHandling.CANCEL_AND_REPORT);
    private ScheduledFuture<?> scheduledFuture;
    private final List<StereoVisionPointCloudMessage> stereoVisionPointCloudMessagesToPublish = new ArrayList<StereoVisionPointCloudMessage>();
    private int indexToPublish = 0;
    private final ROS2Node ros2Node = ROS2Tools.createROS2Node((DomainFactory.PubSubImplementation)DomainFactory.PubSubImplementation.FAST_RTPS, (String)"stereoVisionPublisherNode");
    private final IHMCROS2Publisher<StereoVisionPointCloudMessage> stereoVisionPublisher = ROS2Tools.createPublisherTypeNamed((ROS2NodeInterface)this.ros2Node, StereoVisionPointCloudMessage.class, (ROS2Topic)ROS2Tools.IHMC_ROOT);

    public SLAMDataManagerAnchorPaneController() {
        this.scheduledFuture = this.executor.scheduleAtFixedRate(this::publish, 0L, DEFAULT_PUBLISHING_PERIOD_MS, TimeUnit.MILLISECONDS);
    }

    public void setMainWindow(Window ownerWindow) {
        this.ownerWindow = ownerWindow;
    }

    @Override
    public void bindControls() {
        this.currentRawDataOutputFolderTextField.setText(this.defaultExportRawDataFile.getAbsolutePath());
        this.currentSLAMDataOutputFolderTextField.setText(this.defaultExportSLAMDataFile.getAbsolutePath());
        this.currentRawDataInputFolderTextField.setText(this.defaultImportRawDataFile.getAbsolutePath());
        this.currentPlanarRegionsInputFolderTextField.setText(this.defaultImportPlanarRegionsFile.getAbsolutePath());
        this.uiMessager.bindBidirectionalGlobal(SLAMModuleAPI.UIRawDataExportRequest, this.exportRawData.selectedProperty());
    }

    @FXML
    private void exportSLAMData() {
        this.uiMessager.submitMessageToModule(SLAMModuleAPI.UISLAMDataExportDirectory, this.currentSLAMDataOutputFolderTextField.getText());
        this.uiMessager.submitMessageToModule(SLAMModuleAPI.UISLAMDataExportRequest, true);
    }

    @FXML
    private void importRawData() {
        String rawDataFilePath = this.currentRawDataInputFolderTextField.getText();
        File rawDataFile = new File(rawDataFilePath);
        List<StereoVisionPointCloudMessage> messagesFromFile = StereoVisionPointCloudDataLoader.getMessagesFromFile(rawDataFile);
        this.stereoVisionPointCloudMessagesToPublish.clear();
        this.stereoVisionPointCloudMessagesToPublish.addAll(messagesFromFile);
        this.indexToPublish = 0;
        LogTools.info((String)("Loading Data Is Done " + messagesFromFile.size() + " messages."));
        LogTools.info((String)"Publishing Is Started.");
    }

    @FXML
    private void browseRawDataOutputFolder() {
        this.exportRawDataDirectoryChooser.setInitialDirectory(this.defaultExportRawDataFile);
        String newPath = this.exportRawDataDirectoryChooser.showDialog(this.ownerWindow).getAbsolutePath();
        this.uiMessager.submitMessageInternal(SLAMModuleAPI.UIRawDataExportDirectory, newPath);
        Platform.runLater(() -> this.currentRawDataOutputFolderTextField.setText(newPath));
    }

    @FXML
    private void browseSLAMDataOutputFolder() {
        this.exportSLAMDataDirectoryChooser.setInitialDirectory(this.defaultExportSLAMDataFile);
        String newPath = this.exportSLAMDataDirectoryChooser.showDialog(this.ownerWindow).getAbsolutePath();
        this.uiMessager.submitMessageInternal(SLAMModuleAPI.UISLAMDataExportDirectory, newPath);
        Platform.runLater(() -> this.currentSLAMDataOutputFolderTextField.setText(newPath));
    }

    @FXML
    private void browseRawDataInputFolder() {
        this.importRawDataDirectoryChooser.setInitialDirectory(this.defaultImportRawDataFile);
        String newPath = this.importRawDataDirectoryChooser.showDialog(this.ownerWindow).getAbsolutePath();
        Platform.runLater(() -> this.currentRawDataInputFolderTextField.setText(newPath));
    }

    @FXML
    private void browsePlanarRegionsInputFolder() {
        this.importPlanarRegionsDirectoryChooser.setInitialDirectory(this.defaultImportPlanarRegionsFile);
        String newPath = this.importPlanarRegionsDirectoryChooser.showDialog(this.ownerWindow).getAbsolutePath();
        Platform.runLater(() -> this.currentPlanarRegionsInputFolderTextField.setText(newPath));
    }

    private void publish() {
        if (this.stereoVisionPointCloudMessagesToPublish.size() == this.indexToPublish) {
            return;
        }
        System.out.println("publish " + this.indexToPublish);
        StereoVisionPointCloudMessage stereoVisionPointCloudMessage = this.stereoVisionPointCloudMessagesToPublish.get(this.indexToPublish);
        this.stereoVisionPublisher.publish((Object)stereoVisionPointCloudMessage);
        ++this.indexToPublish;
    }

    public void destroy() {
        if (this.scheduledFuture != null) {
            this.scheduledFuture.cancel(true);
            this.scheduledFuture = null;
        }
        this.executor.shutdownNow();
    }
}

