/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotEnvironmentAwareness.ui.controller;

import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.fxml.FXML;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.control.ToggleButton;
import us.ihmc.robotEnvironmentAwareness.communication.SLAMModuleAPI;
import us.ihmc.robotEnvironmentAwareness.ui.controller.REABasicUIController;
import us.ihmc.robotEnvironmentAwareness.ui.properties.SurfaceElementICPSLAMParametersProperty;

public class SLAMAnchorPaneController
extends REABasicUIController {
    @FXML
    private ToggleButton enableSLAMButton;
    @FXML
    private TextField queuedBufferSize;
    @FXML
    private TextField frameComputationTime;
    @FXML
    private TextField slamComputationTime;
    @FXML
    private TextField averageComputationTime;
    @FXML
    private TextField listenerComputationTime;
    @FXML
    private TextField totalComputationTime;
    @FXML
    private ToggleButton latestFrameEnable;
    @FXML
    private ToggleButton octreeMapEnable;
    @FXML
    private ToggleButton showNormal;
    @FXML
    private ToggleButton sensorFrameEnable;
    @FXML
    private Label stationaryFlag;
    @FXML
    private Label velocityLimitFlag;
    @FXML
    private TextField speed;
    private final BooleanProperty sensorMovingProperty = new SimpleBooleanProperty((Object)this, "sensorMovingProperty", false);
    private final BooleanProperty velocityLimitProperty = new SimpleBooleanProperty((Object)this, "velocityLimitProperty", false);
    private final SurfaceElementICPSLAMParametersProperty ihmcSLAMParametersProperty = new SurfaceElementICPSLAMParametersProperty(this, "ihmcSLAMParameters");

    private void updateSensorStatusViz(boolean notMoving) {
        Platform.runLater(() -> {
            if (!notMoving) {
                this.stationaryFlag.setStyle("-fx-background-color: red;");
            } else {
                this.stationaryFlag.setStyle("-fx-background-color: green;");
            }
        });
    }

    private void updateVelocityLimitStatus(boolean notMoving) {
        Platform.runLater(() -> {
            if (!notMoving) {
                this.velocityLimitFlag.setStyle("-fx-background-color: red;");
            } else {
                this.velocityLimitFlag.setStyle("-fx-background-color: green;");
            }
        });
    }

    @Override
    public void bindControls() {
        this.uiMessager.bindBidirectionalGlobal(SLAMModuleAPI.SLAMEnable, this.enableSLAMButton.selectedProperty());
        this.uiMessager.bindBidirectionalGlobal(SLAMModuleAPI.QueuedBuffers, this.queuedBufferSize.textProperty());
        this.uiMessager.bindBidirectionalGlobal(SLAMModuleAPI.FrameComputationTime, this.frameComputationTime.textProperty());
        this.uiMessager.bindBidirectionalGlobal(SLAMModuleAPI.SLAMComputationTime, this.slamComputationTime.textProperty());
        this.uiMessager.bindBidirectionalGlobal(SLAMModuleAPI.AverageComputationTime, this.averageComputationTime.textProperty());
        this.uiMessager.bindBidirectionalGlobal(SLAMModuleAPI.ListenerComputationTime, this.listenerComputationTime.textProperty());
        this.uiMessager.bindBidirectionalGlobal(SLAMModuleAPI.TotalComputationTime, this.totalComputationTime.textProperty());
        this.uiMessager.bindBidirectionalGlobal(SLAMModuleAPI.ShowLatestFrame, this.latestFrameEnable.selectedProperty());
        this.uiMessager.bindBidirectionalGlobal(SLAMModuleAPI.ShowSLAMOctreeMap, this.octreeMapEnable.selectedProperty());
        this.uiMessager.bindBidirectionalGlobal(SLAMModuleAPI.ShowSLAMOctreeNormalMap, this.showNormal.selectedProperty());
        this.uiMessager.bindBidirectionalGlobal(SLAMModuleAPI.ShowSLAMSensorTrajectory, this.sensorFrameEnable.selectedProperty());
        this.uiMessager.bindBidirectionalGlobal(SLAMModuleAPI.SLAMParameters, this.ihmcSLAMParametersProperty);
        this.initializeSetup();
        this.uiMessager.bindPropertyToTopic(SLAMModuleAPI.SensorStatus, this.sensorMovingProperty);
        this.updateSensorStatusViz(false);
        this.sensorMovingProperty.addListener((o, oldValue, newValue) -> {
            if (newValue != oldValue) {
                this.updateSensorStatusViz((boolean)newValue);
            }
        });
        this.uiMessager.bindPropertyToTopic(SLAMModuleAPI.VelocityLimitStatus, this.velocityLimitProperty);
        this.updateVelocityLimitStatus(false);
        this.velocityLimitProperty.addListener((o, oldValue, newValue) -> {
            if (newValue != oldValue) {
                this.updateVelocityLimitStatus((boolean)newValue);
            }
        });
        this.uiMessager.bindBidirectionalGlobal(SLAMModuleAPI.SensorSpeed, this.speed.textProperty());
    }

    private void initializeSetup() {
        this.uiMessager.broadcastMessage(SLAMModuleAPI.SLAMEnable, true);
        this.uiMessager.broadcastMessage(SLAMModuleAPI.ShowLatestFrame, true);
        this.uiMessager.broadcastMessage(SLAMModuleAPI.ShowSLAMOctreeMap, true);
        this.uiMessager.broadcastMessage(SLAMModuleAPI.ShowSLAMSensorTrajectory, true);
    }

    @FXML
    public void clear() {
        this.uiMessager.broadcastMessage(SLAMModuleAPI.SLAMClear, true);
        this.uiMessager.broadcastMessage(SLAMModuleAPI.SLAMVizClear, true);
        this.uiMessager.broadcastMessage(SLAMModuleAPI.SensorPoseHistoryClear, true);
    }

    @FXML
    public void clearFootsteps() {
        this.uiMessager.broadcastMessage(SLAMModuleAPI.ClearFootstepDataViz, true);
    }
}

