/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotEnvironmentAwareness.ui.controller;

import javafx.beans.property.Property;
import javafx.fxml.FXML;
import javafx.scene.control.Slider;
import javafx.scene.control.ToggleButton;
import us.ihmc.javaFXToolkit.StringConverterTools;
import us.ihmc.messager.MessagerAPIFactory;
import us.ihmc.robotEnvironmentAwareness.communication.REAModuleAPI;
import us.ihmc.robotEnvironmentAwareness.planarRegion.PlanarRegionSegmentationParameters;
import us.ihmc.robotEnvironmentAwareness.ui.controller.REABasicUIController;
import us.ihmc.robotEnvironmentAwareness.ui.properties.PlanarRegionSegmentationParametersProperty;

public class RegionSegmentationAnchorPaneController
extends REABasicUIController {
    @FXML
    private ToggleButton enableSegmentationButton;
    @FXML
    private Slider searchRadiusSlider;
    @FXML
    private Slider maxDistanceFromPlaneSlider;
    @FXML
    private Slider maxAngleFromPlaneSlider;
    @FXML
    private Slider minNormalQualitySlider;
    @FXML
    private Slider minRegionSizeSlider;
    @FXML
    private Slider maxStandardDeviationSlider;
    @FXML
    private Slider minVolumicDensitySlider;
    private final PlanarRegionSegmentationParametersProperty planarRegionSegmentationParametersProperty = new PlanarRegionSegmentationParametersProperty(this, "planarRegionSegmentationParameters");
    private MessagerAPIFactory.Topic<Boolean> planarRegionsSegmentationEnableTopic = REAModuleAPI.PlanarRegionsSegmentationEnable;
    private MessagerAPIFactory.Topic<Boolean> planarRegionsSegmentationClearTopic = REAModuleAPI.PlanarRegionsSegmentationClear;
    private MessagerAPIFactory.Topic<Boolean> saveRegionUpdaterConfigurationTopic = REAModuleAPI.SaveRegionUpdaterConfiguration;
    private MessagerAPIFactory.Topic<PlanarRegionSegmentationParameters> planarRegionsSegmentationParametersTopic = REAModuleAPI.PlanarRegionsSegmentationParameters;

    private void setupControls() {
        this.searchRadiusSlider.setLabelFormatter(StringConverterTools.metersToRoundedCentimeters());
        this.maxDistanceFromPlaneSlider.setLabelFormatter(StringConverterTools.metersToRoundedCentimeters());
        this.maxAngleFromPlaneSlider.setLabelFormatter(StringConverterTools.radiansToRoundedDegrees());
        this.minNormalQualitySlider.setLabelFormatter(StringConverterTools.metersToRoundedCentimeters());
        this.maxStandardDeviationSlider.setLabelFormatter(StringConverterTools.rounding((double)1000.0, (int)1));
        this.minVolumicDensitySlider.setLabelFormatter(StringConverterTools.rounding((double)1.0E-6, (int)2));
    }

    public void setPlanarRegionsSegmentationEnableTopic(MessagerAPIFactory.Topic<Boolean> planarRegionsSegmentationEnableTopic) {
        this.planarRegionsSegmentationEnableTopic = planarRegionsSegmentationEnableTopic;
    }

    public void setPlanarRegionsSegmentationClearTopic(MessagerAPIFactory.Topic<Boolean> planarRegionsSegmentationClearTopic) {
        this.planarRegionsSegmentationClearTopic = planarRegionsSegmentationClearTopic;
    }

    public void setSaveRegionUpdaterConfigurationTopic(MessagerAPIFactory.Topic<Boolean> saveRegionUpdaterConfigurationTopic) {
        this.saveRegionUpdaterConfigurationTopic = saveRegionUpdaterConfigurationTopic;
    }

    public void setPlanarRegionsSegmentationParametersTopic(MessagerAPIFactory.Topic<PlanarRegionSegmentationParameters> planarRegionSegmentationParametersTopic) {
        this.planarRegionsSegmentationParametersTopic = planarRegionSegmentationParametersTopic;
    }

    @Override
    public void bindControls() {
        this.setupControls();
        this.uiMessager.bindBidirectionalGlobal(this.planarRegionsSegmentationEnableTopic, this.enableSegmentationButton.selectedProperty());
        this.planarRegionSegmentationParametersProperty.bindBidirectionalSearchRadius((Property<? extends Number>)this.searchRadiusSlider.valueProperty());
        this.planarRegionSegmentationParametersProperty.bindBidirectionalMaxDistanceFromPlane((Property<? extends Number>)this.maxDistanceFromPlaneSlider.valueProperty());
        this.planarRegionSegmentationParametersProperty.bindBidirectionalMaxAngleFromPlane((Property<? extends Number>)this.maxAngleFromPlaneSlider.valueProperty());
        this.planarRegionSegmentationParametersProperty.bindBidirectionalMinNormalQuality((Property<? extends Number>)this.minNormalQualitySlider.valueProperty());
        this.planarRegionSegmentationParametersProperty.bindBidirectionalMinRegionSize((Property<? extends Number>)this.minRegionSizeSlider.valueProperty());
        this.planarRegionSegmentationParametersProperty.bindBidirectionalMaxStandardDeviation((Property<? extends Number>)this.maxStandardDeviationSlider.valueProperty());
        this.planarRegionSegmentationParametersProperty.bindBidirectionalMinVolumicDensity((Property<? extends Number>)this.minVolumicDensitySlider.valueProperty());
        this.uiMessager.bindBidirectionalGlobal(this.planarRegionsSegmentationParametersTopic, this.planarRegionSegmentationParametersProperty);
    }

    @FXML
    public void save() {
        this.uiMessager.submitStateRequestToModule(this.saveRegionUpdaterConfigurationTopic);
    }

    @FXML
    public void clear() {
        this.uiMessager.submitMessageToModule(this.planarRegionsSegmentationClearTopic, true);
    }
}

