/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotEnvironmentAwareness.ui.controller;

import controller_msgs.msg.dds.ConcaveHullFactoryParametersMessage;
import javafx.beans.property.Property;
import javafx.fxml.FXML;
import javafx.scene.control.Spinner;
import javafx.scene.control.SpinnerValueFactory;
import javafx.scene.control.ToggleButton;
import perception_msgs.msg.dds.PolygonizerParametersMessage;
import us.ihmc.javaFXToolkit.StringConverterTools;
import us.ihmc.messager.MessagerAPIFactory;
import us.ihmc.robotEnvironmentAwareness.communication.REAModuleAPI;
import us.ihmc.robotEnvironmentAwareness.communication.converters.REAParametersMessageHelper;
import us.ihmc.robotEnvironmentAwareness.planarRegion.IntersectionEstimationParameters;
import us.ihmc.robotEnvironmentAwareness.ui.controller.REABasicUIController;
import us.ihmc.robotEnvironmentAwareness.ui.properties.ConcaveHullFactoryParametersProperty;
import us.ihmc.robotEnvironmentAwareness.ui.properties.IntersectionEstimationParametersProperty;
import us.ihmc.robotEnvironmentAwareness.ui.properties.PolygonizerParametersProperty;

public class PolygonizerAnchorPaneController
extends REABasicUIController {
    @FXML
    private ToggleButton enablePolygonizerButton;
    @FXML
    private ToggleButton enableIntersectionCalculatorButton;
    @FXML
    private ToggleButton hideRegionNodes;
    @FXML
    private Spinner<Double> concaveHullThresholdSpinner;
    @FXML
    private Spinner<Integer> minRegionSizePolygonizerSpinner;
    @FXML
    private Spinner<Double> peakAngleThresholdSpinner;
    @FXML
    private Spinner<Double> shallowAngleThresholdSpinner;
    @FXML
    private Spinner<Double> minEdgeLengthSpinner;
    @FXML
    private Spinner<Double> depthThresholdSpinner;
    @FXML
    private ToggleButton enableNarrowPassageFilterButton;
    private final ConcaveHullFactoryParametersProperty concaveHullFactoryParametersProperty = new ConcaveHullFactoryParametersProperty(this, "concaveHullParameters");
    private final PolygonizerParametersProperty polygonizerParametersProperty = new PolygonizerParametersProperty(this, "polygonizerParameters");
    @FXML
    private Spinner<Double> maxDistanceToRegionSpinner;
    @FXML
    private Spinner<Integer> minRegionSizeIntersectionSpinner;
    @FXML
    private Spinner<Double> minIntersectionLengthSpinner;
    @FXML
    private Spinner<Double> minRegionAngleDifferenceSpinner;
    @FXML
    private ToggleButton addIntersectionsToRegionsButton;
    private final IntersectionEstimationParametersProperty intersectionEstimationParametersProperty = new IntersectionEstimationParametersProperty(this, "intersectionEstimationParameters");
    private MessagerAPIFactory.Topic<Boolean> planarRegionsPolygonizerEnableTopic = REAModuleAPI.PlanarRegionsPolygonizerEnable;
    private MessagerAPIFactory.Topic<Boolean> planarRegionsPolygonizerClearTopic = REAModuleAPI.PlanarRegionsPolygonizerClear;
    private MessagerAPIFactory.Topic<Boolean> planarRegionsIntersectionEnableTopic = REAModuleAPI.PlanarRegionsIntersectionEnable;
    private MessagerAPIFactory.Topic<Boolean> uiPlanarRegionHideNodesTopic = REAModuleAPI.UIPlanarRegionHideNodes;
    private MessagerAPIFactory.Topic<Boolean> saveRegionUpdaterConfigurationTopic = REAModuleAPI.SaveRegionUpdaterConfiguration;
    private MessagerAPIFactory.Topic<ConcaveHullFactoryParametersMessage> planarRegionsConcaveHullParametersTopic = REAModuleAPI.PlanarRegionsConcaveHullParameters;
    private MessagerAPIFactory.Topic<PolygonizerParametersMessage> planarRegionsPolygonizerParametersTopic = REAModuleAPI.PlanarRegionsPolygonizerParameters;
    private MessagerAPIFactory.Topic<IntersectionEstimationParameters> planarRegionsIntersectionParametersTopic = REAModuleAPI.PlanarRegionsIntersectionParameters;

    private void setupControls() {
        this.concaveHullThresholdSpinner.setValueFactory((SpinnerValueFactory)PolygonizerAnchorPaneController.createLengthValueFactory(0.001, 0.5, 0.2, 0.05));
        this.minRegionSizePolygonizerSpinner.setValueFactory((SpinnerValueFactory)new SpinnerValueFactory.IntegerSpinnerValueFactory(0, 1000, 10, 10));
        this.peakAngleThresholdSpinner.setValueFactory((SpinnerValueFactory)PolygonizerAnchorPaneController.createAngleValueFactory(1.5707963267948966, Math.PI, Math.toRadians(160.0), Math.toRadians(5.0)));
        this.shallowAngleThresholdSpinner.setValueFactory((SpinnerValueFactory)PolygonizerAnchorPaneController.createAngleValueFactory(0.0, 1.5707963267948966, Math.toRadians(10.0), Math.toRadians(2.5)));
        this.minEdgeLengthSpinner.setValueFactory((SpinnerValueFactory)PolygonizerAnchorPaneController.createLengthValueFactory(0.0, 0.2, 0.05, 0.005));
        this.depthThresholdSpinner.setValueFactory((SpinnerValueFactory)PolygonizerAnchorPaneController.createLengthValueFactory(0.001, 0.5, 0.1, 0.05));
        this.maxDistanceToRegionSpinner.setValueFactory((SpinnerValueFactory)PolygonizerAnchorPaneController.createLengthValueFactory(0.0, 0.5, 0.05, 0.01));
        this.minRegionSizeIntersectionSpinner.setValueFactory((SpinnerValueFactory)new SpinnerValueFactory.IntegerSpinnerValueFactory(0, 1000, 10, 10));
        this.minIntersectionLengthSpinner.setValueFactory((SpinnerValueFactory)PolygonizerAnchorPaneController.createLengthValueFactory(0.0, 0.5, 0.06, 0.01));
        this.minRegionAngleDifferenceSpinner.setValueFactory((SpinnerValueFactory)PolygonizerAnchorPaneController.createAngleValueFactory(0.0, 1.5707963267948966, Math.toRadians(15.0), Math.toRadians(5.0)));
        this.concaveHullThresholdSpinner.getValueFactory().setConverter(StringConverterTools.metersToRoundedCentimeters());
        this.peakAngleThresholdSpinner.getValueFactory().setConverter(StringConverterTools.radiansToRoundedDegrees());
        this.shallowAngleThresholdSpinner.getValueFactory().setConverter(StringConverterTools.radiansToRoundedDegrees());
        this.minEdgeLengthSpinner.getValueFactory().setConverter(StringConverterTools.metersToRoundedCentimeters());
        this.depthThresholdSpinner.getValueFactory().setConverter(StringConverterTools.metersToRoundedCentimeters());
        this.maxDistanceToRegionSpinner.getValueFactory().setConverter(StringConverterTools.metersToRoundedCentimeters());
        this.minIntersectionLengthSpinner.getValueFactory().setConverter(StringConverterTools.metersToRoundedCentimeters());
        this.minRegionAngleDifferenceSpinner.getValueFactory().setConverter(StringConverterTools.radiansToRoundedDegrees());
    }

    public void setPlanarRegionsPolygonizerEnableTopic(MessagerAPIFactory.Topic<Boolean> planarRegionsPolygonizerEnableTopic) {
        this.planarRegionsPolygonizerEnableTopic = planarRegionsPolygonizerEnableTopic;
    }

    public void setPlanarRegionsPolygonizerClearTopic(MessagerAPIFactory.Topic<Boolean> planarRegionsPolygonizerClearTopic) {
        this.planarRegionsPolygonizerClearTopic = planarRegionsPolygonizerClearTopic;
    }

    public void setPlanarRegionsIntersectionEnableTopic(MessagerAPIFactory.Topic<Boolean> planarRegionsIntersectionEnableTopic) {
        this.planarRegionsIntersectionEnableTopic = planarRegionsIntersectionEnableTopic;
    }

    public void setUiPlanarRegionHideNodesTopic(MessagerAPIFactory.Topic<Boolean> uiPlanarRegionHideNodesTopic) {
        this.uiPlanarRegionHideNodesTopic = uiPlanarRegionHideNodesTopic;
    }

    public void setSaveRegionUpdaterConfigurationTopic(MessagerAPIFactory.Topic<Boolean> saveRegionUpdaterConfigurationTopic) {
        this.saveRegionUpdaterConfigurationTopic = saveRegionUpdaterConfigurationTopic;
    }

    public void setPlanarRegionsConcaveHullParametersTopic(MessagerAPIFactory.Topic<ConcaveHullFactoryParametersMessage> planarRegionsConcaveHullParametersTopic) {
        this.planarRegionsConcaveHullParametersTopic = planarRegionsConcaveHullParametersTopic;
    }

    public void setPlanarRegionsPolygonizerParametersTopic(MessagerAPIFactory.Topic<PolygonizerParametersMessage> planarRegionsPolygonizerParametersTopic) {
        this.planarRegionsPolygonizerParametersTopic = planarRegionsPolygonizerParametersTopic;
    }

    public void setPlanarRegionsIntersectionParametersTopic(MessagerAPIFactory.Topic<IntersectionEstimationParameters> planarRegionsIntersectionParametersTopic) {
        this.planarRegionsIntersectionParametersTopic = planarRegionsIntersectionParametersTopic;
    }

    @Override
    public void bindControls() {
        this.setupControls();
        this.uiMessager.bindBidirectionalGlobal(this.planarRegionsPolygonizerEnableTopic, this.enablePolygonizerButton.selectedProperty());
        this.uiMessager.bindBidirectionalGlobal(this.planarRegionsIntersectionEnableTopic, this.enableIntersectionCalculatorButton.selectedProperty());
        this.concaveHullFactoryParametersProperty.bindBidirectionalEdgeLengthThreshold((Property<? extends Number>)this.concaveHullThresholdSpinner.getValueFactory().valueProperty());
        this.uiMessager.registerTopicListener(this.planarRegionsConcaveHullParametersTopic, message -> this.concaveHullFactoryParametersProperty.set(REAParametersMessageHelper.convertFromMessage(message)));
        this.concaveHullFactoryParametersProperty.addListener((obs, oldValue, newValue) -> this.uiMessager.submitMessageToModule(this.planarRegionsConcaveHullParametersTopic, REAParametersMessageHelper.convertToMessage(newValue)));
        this.uiMessager.registerTopicListener(this.planarRegionsPolygonizerParametersTopic, parametersMessage -> this.polygonizerParametersProperty.set(REAParametersMessageHelper.convertFromMessage(parametersMessage)));
        this.polygonizerParametersProperty.addListener((obs, oldValue, newValue) -> this.uiMessager.submitMessageToModule(this.planarRegionsPolygonizerParametersTopic, REAParametersMessageHelper.convertToMessage(newValue)));
        this.polygonizerParametersProperty.bindBidirectionalMinNumberOfNodes((Property<? extends Number>)this.minRegionSizePolygonizerSpinner.getValueFactory().valueProperty());
        this.polygonizerParametersProperty.bindBidirectionalPeakAngleThreshold((Property<? extends Number>)this.peakAngleThresholdSpinner.getValueFactory().valueProperty());
        this.polygonizerParametersProperty.bindBidirectionalShallowAngleThreshold((Property<? extends Number>)this.shallowAngleThresholdSpinner.getValueFactory().valueProperty());
        this.polygonizerParametersProperty.bindBidirectionalLengthThreshold((Property<? extends Number>)this.minEdgeLengthSpinner.getValueFactory().valueProperty());
        this.polygonizerParametersProperty.bindBidirectionalDepthThreshold((Property<? extends Number>)this.depthThresholdSpinner.getValueFactory().valueProperty());
        this.polygonizerParametersProperty.bindBidirectionalEnableNarrowPassageFilter((Property<Boolean>)this.enableNarrowPassageFilterButton.selectedProperty());
        this.intersectionEstimationParametersProperty.bindBidirectionalMaxDistanceToRegion((Property<? extends Number>)this.maxDistanceToRegionSpinner.getValueFactory().valueProperty());
        this.intersectionEstimationParametersProperty.bindBidirectionalMinRegionSize((Property<? extends Number>)this.minRegionSizeIntersectionSpinner.getValueFactory().valueProperty());
        this.intersectionEstimationParametersProperty.bindBidirectionalMinIntersectionLength((Property<? extends Number>)this.minIntersectionLengthSpinner.getValueFactory().valueProperty());
        this.intersectionEstimationParametersProperty.bindBidirectionalMinRegionAngleDifference((Property<? extends Number>)this.minRegionAngleDifferenceSpinner.getValueFactory().valueProperty());
        this.intersectionEstimationParametersProperty.bindBidirectionalAddIntersectionsToRegions((Property<Boolean>)this.addIntersectionsToRegionsButton.selectedProperty());
        this.uiMessager.bindBidirectionalGlobal(this.planarRegionsIntersectionParametersTopic, this.intersectionEstimationParametersProperty);
        this.load();
        this.uiMessager.bindBidirectionalInternal(this.uiPlanarRegionHideNodesTopic, this.hideRegionNodes.selectedProperty(), true);
    }

    @FXML
    public void clear() {
        this.uiMessager.broadcastMessage(this.planarRegionsPolygonizerClearTopic, true);
    }

    @FXML
    public void save() {
        this.uiMessager.submitStateRequestToModule(this.saveRegionUpdaterConfigurationTopic);
        this.saveUIControlProperty(this.uiPlanarRegionHideNodesTopic, this.hideRegionNodes);
    }

    public void load() {
        this.loadUIControlProperty(this.uiPlanarRegionHideNodesTopic, this.hideRegionNodes);
    }

    public static SpinnerValueFactory.DoubleSpinnerValueFactory createLengthValueFactory(double min, double max, double initialValue, double amountToStepBy) {
        SpinnerValueFactory.DoubleSpinnerValueFactory doubleSpinnerValueFactory = new SpinnerValueFactory.DoubleSpinnerValueFactory(min, max, initialValue, amountToStepBy);
        doubleSpinnerValueFactory.setConverter(StringConverterTools.metersToRoundedCentimeters());
        return doubleSpinnerValueFactory;
    }

    public static SpinnerValueFactory.DoubleSpinnerValueFactory createAngleValueFactory(double min, double max, double initialValue, double amountToStepBy) {
        SpinnerValueFactory.DoubleSpinnerValueFactory doubleSpinnerValueFactory = new SpinnerValueFactory.DoubleSpinnerValueFactory(min, max, initialValue, amountToStepBy);
        doubleSpinnerValueFactory.setConverter(StringConverterTools.radiansToRoundedDegrees());
        return doubleSpinnerValueFactory;
    }
}

