/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotEnvironmentAwareness.ui.controller;

import javafx.fxml.FXML;
import javafx.scene.control.Slider;
import javafx.scene.control.Spinner;
import javafx.scene.control.SpinnerValueFactory;
import javafx.scene.control.ToggleButton;
import us.ihmc.messager.javafx.MessageBidirectionalBinding;
import us.ihmc.robotEnvironmentAwareness.communication.REAModuleAPI;
import us.ihmc.robotEnvironmentAwareness.ui.controller.REABasicUIController;

public class PointCloudAnchorPaneController
extends REABasicUIController {
    @FXML
    private ToggleButton enableLidarButton;
    @FXML
    private Slider scanHistorySizeSlider;
    @FXML
    private ToggleButton enableStereoButton;
    @FXML
    private ToggleButton enableDepthButton;
    @FXML
    private Spinner<Integer> stereoVisionSizeSpinner;
    @FXML
    private Spinner<Integer> depthCloudSizeSpinner;
    @FXML
    private Slider navigationFramesSlider;
    private static final int maximumSizeOfPointCloud = 200000;
    private static final int minimumSizeOfPointCloud = 1000;
    public static final int initialSizeOfPointCloud = 5000;
    private final MessageBidirectionalBinding.PropertyToMessageTypeConverter<Integer, Number> numberToIntegerConverter = new MessageBidirectionalBinding.PropertyToMessageTypeConverter<Integer, Number>(){

        public Integer convert(Number propertyValue) {
            return propertyValue.intValue();
        }

        public Number interpret(Integer newValue) {
            return new Double(newValue.intValue());
        }
    };

    @Override
    public void bindControls() {
        this.load();
        this.stereoVisionSizeSpinner.setValueFactory((SpinnerValueFactory)this.createNumberOfPointsValueFactory(5000));
        this.depthCloudSizeSpinner.setValueFactory((SpinnerValueFactory)this.createNumberOfPointsValueFactory(5000));
        this.uiMessager.bindBidirectionalInternal(REAModuleAPI.UILidarScanShow, this.enableLidarButton.selectedProperty(), true);
        this.uiMessager.bindBidirectionalInternal(REAModuleAPI.UILidarScanSize, this.scanHistorySizeSlider.valueProperty(), this.numberToIntegerConverter, true);
        this.uiMessager.bindBidirectionalInternal(REAModuleAPI.UIStereoVisionShow, this.enableStereoButton.selectedProperty(), true);
        this.uiMessager.bindBidirectionalInternal(REAModuleAPI.UIDepthCloudShow, this.enableDepthButton.selectedProperty(), true);
        this.uiMessager.bindBidirectionalGlobal(REAModuleAPI.UIStereoVisionSize, this.stereoVisionSizeSpinner.getValueFactory().valueProperty());
        this.uiMessager.bindBidirectionalGlobal(REAModuleAPI.UIDepthCloudSize, this.depthCloudSizeSpinner.getValueFactory().valueProperty());
        this.uiMessager.bindBidirectionalInternal(REAModuleAPI.UISensorPoseHistoryFrames, this.navigationFramesSlider.valueProperty(), this.numberToIntegerConverter, true);
    }

    @FXML
    public void clearLidar() {
        this.uiMessager.submitMessageInternal(REAModuleAPI.UILidarScanClear, true);
    }

    @FXML
    public void clearStereo() {
        this.uiMessager.submitMessageInternal(REAModuleAPI.UIStereoVisionClear, true);
    }

    @FXML
    public void clearDepth() {
        this.uiMessager.submitMessageInternal(REAModuleAPI.UIDepthCloudClear, true);
    }

    @FXML
    public void save() {
        this.saveUIControlProperty(REAModuleAPI.UILidarScanShow, this.enableLidarButton);
        this.saveUIControlProperty(REAModuleAPI.UILidarScanSize, this.scanHistorySizeSlider);
        this.saveUIControlProperty(REAModuleAPI.UIStereoVisionShow, this.enableStereoButton);
        this.saveUIControlProperty(REAModuleAPI.UIDepthCloudShow, this.enableDepthButton);
    }

    @FXML
    public void clearNavigation() {
        this.uiMessager.submitMessageInternal(REAModuleAPI.UISensorPoseHistoryClear, true);
    }

    public void load() {
        this.loadUIControlProperty(REAModuleAPI.UILidarScanShow, this.enableLidarButton);
        this.loadUIControlProperty(REAModuleAPI.UILidarScanSize, this.scanHistorySizeSlider);
        this.loadUIControlProperty(REAModuleAPI.UIStereoVisionShow, this.enableStereoButton);
        this.loadUIControlProperty(REAModuleAPI.UIDepthCloudShow, this.enableDepthButton);
    }

    private SpinnerValueFactory.IntegerSpinnerValueFactory createNumberOfPointsValueFactory(int initialValue) {
        int min = 1000;
        int max = 200000;
        int amountToStepBy = 1000;
        return new SpinnerValueFactory.IntegerSpinnerValueFactory(min, max, initialValue, amountToStepBy);
    }
}

